/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.IDN;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.validator.routines.DomainValidator;

public class DomainValidatorTest
extends TestCase {
    private DomainValidator validator;

    public void setUp() {
        this.validator = DomainValidator.getInstance();
        DomainValidator.clearTLDOverrides();
    }

    public void testValidDomains() {
        DomainValidatorTest.assertTrue((String)"apache.org should validate", (boolean)this.validator.isValid("apache.org"));
        DomainValidatorTest.assertTrue((String)"www.google.com should validate", (boolean)this.validator.isValid("www.google.com"));
        DomainValidatorTest.assertTrue((String)"test-domain.com should validate", (boolean)this.validator.isValid("test-domain.com"));
        DomainValidatorTest.assertTrue((String)"test---domain.com should validate", (boolean)this.validator.isValid("test---domain.com"));
        DomainValidatorTest.assertTrue((String)"test-d-o-m-ain.com should validate", (boolean)this.validator.isValid("test-d-o-m-ain.com"));
        DomainValidatorTest.assertTrue((String)"two-letter domain label should validate", (boolean)this.validator.isValid("as.uk"));
        DomainValidatorTest.assertTrue((String)"case-insensitive ApAchE.Org should validate", (boolean)this.validator.isValid("ApAchE.Org"));
        DomainValidatorTest.assertTrue((String)"single-character domain label should validate", (boolean)this.validator.isValid("z.com"));
        DomainValidatorTest.assertTrue((String)"i.have.an-example.domain.name should validate", (boolean)this.validator.isValid("i.have.an-example.domain.name"));
    }

    public void testInvalidDomains() {
        DomainValidatorTest.assertFalse((String)"bare TLD .org shouldn't validate", (boolean)this.validator.isValid(".org"));
        DomainValidatorTest.assertFalse((String)"domain name with spaces shouldn't validate", (boolean)this.validator.isValid(" apache.org "));
        DomainValidatorTest.assertFalse((String)"domain name containing spaces shouldn't validate", (boolean)this.validator.isValid("apa che.org"));
        DomainValidatorTest.assertFalse((String)"domain name starting with dash shouldn't validate", (boolean)this.validator.isValid("-testdomain.name"));
        DomainValidatorTest.assertFalse((String)"domain name ending with dash shouldn't validate", (boolean)this.validator.isValid("testdomain-.name"));
        DomainValidatorTest.assertFalse((String)"domain name starting with multiple dashes shouldn't validate", (boolean)this.validator.isValid("---c.com"));
        DomainValidatorTest.assertFalse((String)"domain name ending with multiple dashes shouldn't validate", (boolean)this.validator.isValid("c--.com"));
        DomainValidatorTest.assertFalse((String)"domain name with invalid TLD shouldn't validate", (boolean)this.validator.isValid("apache.rog"));
        DomainValidatorTest.assertFalse((String)"URL shouldn't validate", (boolean)this.validator.isValid("http://www.apache.org"));
        DomainValidatorTest.assertFalse((String)"Empty string shouldn't validate as domain name", (boolean)this.validator.isValid(" "));
        DomainValidatorTest.assertFalse((String)"Null shouldn't validate as domain name", (boolean)this.validator.isValid(null));
    }

    public void testTopLevelDomains() {
        DomainValidatorTest.assertTrue((String)".arpa should validate as iTLD", (boolean)this.validator.isValidInfrastructureTld(".arpa"));
        DomainValidatorTest.assertFalse((String)".com shouldn't validate as iTLD", (boolean)this.validator.isValidInfrastructureTld(".com"));
        DomainValidatorTest.assertTrue((String)".name should validate as gTLD", (boolean)this.validator.isValidGenericTld(".name"));
        DomainValidatorTest.assertFalse((String)".us shouldn't validate as gTLD", (boolean)this.validator.isValidGenericTld(".us"));
        DomainValidatorTest.assertTrue((String)".uk should validate as ccTLD", (boolean)this.validator.isValidCountryCodeTld(".uk"));
        DomainValidatorTest.assertFalse((String)".org shouldn't validate as ccTLD", (boolean)this.validator.isValidCountryCodeTld(".org"));
        DomainValidatorTest.assertTrue((String)".COM should validate as TLD", (boolean)this.validator.isValidTld(".COM"));
        DomainValidatorTest.assertTrue((String)".BiZ should validate as TLD", (boolean)this.validator.isValidTld(".BiZ"));
        DomainValidatorTest.assertFalse((String)"invalid TLD shouldn't validate", (boolean)this.validator.isValid(".nope"));
        DomainValidatorTest.assertFalse((String)"empty string shouldn't validate as TLD", (boolean)this.validator.isValid(""));
        DomainValidatorTest.assertFalse((String)"null shouldn't validate as TLD", (boolean)this.validator.isValid(null));
    }

    public void testAllowLocal() {
        DomainValidator noLocal = DomainValidator.getInstance((boolean)false);
        DomainValidator allowLocal = DomainValidator.getInstance((boolean)true);
        DomainValidatorTest.assertEquals((Object)noLocal, (Object)this.validator);
        DomainValidatorTest.assertFalse((String)"localhost.localdomain should validate", (boolean)noLocal.isValid("localhost.localdomain"));
        DomainValidatorTest.assertFalse((String)"localhost should validate", (boolean)noLocal.isValid("localhost"));
        DomainValidatorTest.assertTrue((String)"localhost.localdomain should validate", (boolean)allowLocal.isValid("localhost.localdomain"));
        DomainValidatorTest.assertTrue((String)"localhost should validate", (boolean)allowLocal.isValid("localhost"));
        DomainValidatorTest.assertTrue((String)"hostname should validate", (boolean)allowLocal.isValid("hostname"));
        DomainValidatorTest.assertTrue((String)"machinename should validate", (boolean)allowLocal.isValid("machinename"));
        DomainValidatorTest.assertTrue((String)"apache.org should validate", (boolean)allowLocal.isValid("apache.org"));
        DomainValidatorTest.assertFalse((String)"domain name with spaces shouldn't validate", (boolean)allowLocal.isValid(" apache.org "));
    }

    public void testIDN() {
        DomainValidatorTest.assertTrue((String)"b\u00fccher.ch in IDN should validate", (boolean)this.validator.isValid("www.xn--bcher-kva.ch"));
    }

    public void testIDNJava6OrLater() {
        String version = System.getProperty("java.version");
        if (version.compareTo("1.6") < 0) {
            System.out.println("Cannot run Unicode IDN tests");
            return;
        }
        DomainValidatorTest.assertTrue((String)"b\u00fccher.ch should validate", (boolean)this.validator.isValid("www.b\u00fccher.ch"));
        DomainValidatorTest.assertTrue((String)"xn--d1abbgf6aiiy.xn--p1ai should validate", (boolean)this.validator.isValid("xn--d1abbgf6aiiy.xn--p1ai"));
        DomainValidatorTest.assertTrue((String)"\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444 should validate", (boolean)this.validator.isValid("\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444"));
        DomainValidatorTest.assertFalse((String)"www.\ufffd.ch FFFD should fail", (boolean)this.validator.isValid("www.\ufffd.ch"));
    }

    public void testRFC2396domainlabel() {
        DomainValidatorTest.assertTrue((String)"a.ch should validate", (boolean)this.validator.isValid("a.ch"));
        DomainValidatorTest.assertTrue((String)"9.ch should validate", (boolean)this.validator.isValid("9.ch"));
        DomainValidatorTest.assertTrue((String)"az.ch should validate", (boolean)this.validator.isValid("az.ch"));
        DomainValidatorTest.assertTrue((String)"09.ch should validate", (boolean)this.validator.isValid("09.ch"));
        DomainValidatorTest.assertTrue((String)"9-1.ch should validate", (boolean)this.validator.isValid("9-1.ch"));
        DomainValidatorTest.assertFalse((String)"91-.ch should not validate", (boolean)this.validator.isValid("91-.ch"));
        DomainValidatorTest.assertFalse((String)"-.ch should not validate", (boolean)this.validator.isValid("-.ch"));
    }

    public void testRFC2396toplabel() {
        DomainValidatorTest.assertTrue((String)"a.c (alpha) should validate", (boolean)this.validator.isValidDomainSyntax("a.c"));
        DomainValidatorTest.assertTrue((String)"a.cc (alpha alpha) should validate", (boolean)this.validator.isValidDomainSyntax("a.cc"));
        DomainValidatorTest.assertTrue((String)"a.c9 (alpha alphanum) should validate", (boolean)this.validator.isValidDomainSyntax("a.c9"));
        DomainValidatorTest.assertTrue((String)"a.c-9 (alpha - alphanum) should validate", (boolean)this.validator.isValidDomainSyntax("a.c-9"));
        DomainValidatorTest.assertTrue((String)"a.c-z (alpha - alpha) should validate", (boolean)this.validator.isValidDomainSyntax("a.c-z"));
        DomainValidatorTest.assertFalse((String)"a.9c (alphanum alpha) should fail", (boolean)this.validator.isValidDomainSyntax("a.9c"));
        DomainValidatorTest.assertFalse((String)"a.c- (alpha -) should fail", (boolean)this.validator.isValidDomainSyntax("a.c-"));
        DomainValidatorTest.assertFalse((String)"a.- (-) should fail", (boolean)this.validator.isValidDomainSyntax("a.-"));
        DomainValidatorTest.assertFalse((String)"a.-9 (- alphanum) should fail", (boolean)this.validator.isValidDomainSyntax("a.-9"));
    }

    public void testDomainNoDots() {
        DomainValidatorTest.assertTrue((String)"a (alpha) should validate", (boolean)this.validator.isValidDomainSyntax("a"));
        DomainValidatorTest.assertTrue((String)"9 (alphanum) should validate", (boolean)this.validator.isValidDomainSyntax("9"));
        DomainValidatorTest.assertTrue((String)"c-z (alpha - alpha) should validate", (boolean)this.validator.isValidDomainSyntax("c-z"));
        DomainValidatorTest.assertFalse((String)"c- (alpha -) should fail", (boolean)this.validator.isValidDomainSyntax("c-"));
        DomainValidatorTest.assertFalse((String)"-c (- alpha) should fail", (boolean)this.validator.isValidDomainSyntax("-c"));
        DomainValidatorTest.assertFalse((String)"- (-) should fail", (boolean)this.validator.isValidDomainSyntax("-"));
    }

    public void testValidator297() {
        DomainValidatorTest.assertTrue((String)"xn--d1abbgf6aiiy.xn--p1ai should validate", (boolean)this.validator.isValid("xn--d1abbgf6aiiy.xn--p1ai"));
    }

    public void testValidator306() {
        String longString = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A";
        DomainValidatorTest.assertEquals((int)63, (int)"abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A".length());
        DomainValidatorTest.assertTrue((String)"63 chars label should validate", (boolean)this.validator.isValidDomainSyntax("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A.com"));
        DomainValidatorTest.assertFalse((String)"64 chars label should fail", (boolean)this.validator.isValidDomainSyntax("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789Ax.com"));
        DomainValidatorTest.assertTrue((String)"63 chars TLD should validate", (boolean)this.validator.isValidDomainSyntax("test.abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A"));
        DomainValidatorTest.assertFalse((String)"64 chars TLD should fail", (boolean)this.validator.isValidDomainSyntax("test.xabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A"));
        String longDomain = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A.abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A.abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A." + "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A".substring(0, 61);
        DomainValidatorTest.assertEquals((int)253, (int)longDomain.length());
        DomainValidatorTest.assertTrue((String)"253 chars domain should validate", (boolean)this.validator.isValidDomainSyntax(longDomain));
        DomainValidatorTest.assertFalse((String)"254 chars domain should fail", (boolean)this.validator.isValidDomainSyntax(longDomain + "x"));
    }

    public void testUnicodeToASCII() {
        String[][] otherDots;
        String[] asciidots;
        for (String s : asciidots = new String[]{"", ",", ".", "a.", "a.b", "a..b", "a...b", ".a", "..a"}) {
            DomainValidatorTest.assertEquals((String)s, (String)DomainValidator.unicodeToASCII((String)s));
        }
        for (String[] s : otherDots = new String[][]{{"b\u3002", "b."}, {"b\uff0e", "b."}, {"b\uff61", "b."}, {"\u3002", "."}, {"\uff0e", "."}, {"\uff61", "."}}) {
            DomainValidatorTest.assertEquals((String)s[1], (String)DomainValidator.unicodeToASCII((String)s[0]));
        }
    }

    public void testIsIDNtoASCIIBroken() {
        String[] props;
        System.out.println(">>DomainValidatorTest.testIsIDNtoASCIIBroken()");
        String input = ".";
        boolean ok = ".".equals(IDN.toASCII("."));
        System.out.println("IDN.toASCII is " + (ok ? "OK" : "BROKEN"));
        for (String t : props = new String[]{"java.version", "java.vendor", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version"}) {
            System.out.println(t + "=" + System.getProperty(t));
        }
        System.out.println("<<DomainValidatorTest.testIsIDNtoASCIIBroken()");
    }

    public void test_INFRASTRUCTURE_TLDS_sortedAndLowerCase() throws Exception {
        boolean sorted = DomainValidatorTest.isSortedLowerCase("INFRASTRUCTURE_TLDS");
        DomainValidatorTest.assertTrue((boolean)sorted);
    }

    public void test_COUNTRY_CODE_TLDS_sortedAndLowerCase() throws Exception {
        boolean sorted = DomainValidatorTest.isSortedLowerCase("COUNTRY_CODE_TLDS");
        DomainValidatorTest.assertTrue((boolean)sorted);
    }

    public void test_GENERIC_TLDS_sortedAndLowerCase() throws Exception {
        boolean sorted = DomainValidatorTest.isSortedLowerCase("GENERIC_TLDS");
        DomainValidatorTest.assertTrue((boolean)sorted);
    }

    public void test_LOCAL_TLDS_sortedAndLowerCase() throws Exception {
        boolean sorted = DomainValidatorTest.isSortedLowerCase("LOCAL_TLDS");
        DomainValidatorTest.assertTrue((boolean)sorted);
    }

    public void testEnumIsPublic() {
        DomainValidatorTest.assertTrue((boolean)Modifier.isPublic(DomainValidator.ArrayType.class.getModifiers()));
    }

    public void testUpdateBaseArrays() {
        try {
            DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_RO, (String[])new String[]{"com"});
            DomainValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_RO, (String[])new String[]{"com"});
            DomainValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.INFRASTRUCTURE_RO, (String[])new String[]{"com"});
            DomainValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_RO, (String[])new String[]{"com"});
            DomainValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetArray() {
        DomainValidatorTest.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS));
        DomainValidatorTest.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS));
        DomainValidatorTest.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS));
        DomainValidatorTest.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS));
        DomainValidatorTest.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_RO));
        DomainValidatorTest.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_RO));
        DomainValidatorTest.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.INFRASTRUCTURE_RO));
        DomainValidatorTest.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_RO));
    }

    public void testUpdateCountryCode() {
        DomainValidatorTest.assertFalse((boolean)this.validator.isValidCountryCodeTld("com"));
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS, (String[])new String[]{"com"});
        DomainValidatorTest.assertTrue((boolean)this.validator.isValidCountryCodeTld("com"));
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"com"});
        DomainValidatorTest.assertFalse((boolean)this.validator.isValidCountryCodeTld("com"));
        DomainValidatorTest.assertTrue((boolean)this.validator.isValidCountryCodeTld("ch"));
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"ch"});
        DomainValidatorTest.assertFalse((boolean)this.validator.isValidCountryCodeTld("ch"));
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"xx"});
        DomainValidatorTest.assertTrue((boolean)this.validator.isValidCountryCodeTld("ch"));
    }

    public void testUpdateGeneric() {
        DomainValidatorTest.assertFalse((boolean)this.validator.isValidGenericTld("ch"));
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidatorTest.assertTrue((boolean)this.validator.isValidGenericTld("ch"));
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"ch"});
        DomainValidatorTest.assertFalse((boolean)this.validator.isValidGenericTld("ch"));
        DomainValidatorTest.assertTrue((boolean)this.validator.isValidGenericTld("com"));
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"com"});
        DomainValidatorTest.assertFalse((boolean)this.validator.isValidGenericTld("com"));
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"xx"});
        DomainValidatorTest.assertTrue((boolean)this.validator.isValidGenericTld("com"));
    }

    public void testCannotUpdate() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator dv = DomainValidator.getInstance();
        DomainValidatorTest.assertNotNull((Object)dv);
        try {
            DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
            DomainValidatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void main(String[] a) throws Exception {
        boolean OK = true;
        for (String list : new String[]{"INFRASTRUCTURE_TLDS", "COUNTRY_CODE_TLDS", "GENERIC_TLDS", "LOCAL_TLDS"}) {
            OK &= DomainValidatorTest.isSortedLowerCase(list);
        }
        if (!OK) {
            System.out.println("Fix arrays before retrying; cannot continue");
            return;
        }
        HashSet<String> ianaTlds = new HashSet<String>();
        DomainValidator dv = DomainValidator.getInstance();
        File txtFile = new File("target/tlds-alpha-by-domain.txt");
        long timestamp = DomainValidatorTest.download(txtFile, "http://data.iana.org/TLD/tlds-alpha-by-domain.txt", 0L);
        File htmlFile = new File("target/tlds-alpha-by-domain.html");
        DomainValidatorTest.download(htmlFile, "http://www.iana.org/domains/root/db", timestamp);
        BufferedReader br = new BufferedReader(new FileReader(txtFile));
        String line = br.readLine();
        if (!line.startsWith("# Version ")) {
            br.close();
            throw new IOException("File does not have expected Version header");
        }
        String header = line.substring(2);
        boolean generateUnicodeTlds = false;
        Map<String, String[]> htmlInfo = DomainValidatorTest.getHtmlInfo(htmlFile);
        TreeMap<String, String> missingTLD = new TreeMap<String, String>();
        TreeMap<String, String> missingCC = new TreeMap<String, String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String asciiTld = line.toLowerCase(Locale.ENGLISH);
            String unicodeTld = line.startsWith("XN--") ? IDN.toUnicode(line) : asciiTld;
            if (!dv.isValidTld(asciiTld)) {
                String[] info = htmlInfo.get(asciiTld);
                if (info != null) {
                    String type = info[0];
                    String comment = info[1];
                    if ("country-code".equals(type)) {
                        missingCC.put(asciiTld, unicodeTld + " " + comment);
                    } else {
                        missingTLD.put(asciiTld, unicodeTld + " " + comment);
                    }
                } else {
                    System.err.println("Expected to find HTML info for " + asciiTld);
                }
            }
            ianaTlds.add(asciiTld);
        }
        br.close();
        for (String key : new TreeMap<String, String[]>(htmlInfo).keySet()) {
            if (ianaTlds.contains(key)) continue;
            if (DomainValidatorTest.isNotInRootZone(key)) {
                System.out.println("INFO: HTML entry not yet in root zone: " + key);
                continue;
            }
            System.err.println("WARN: Expected to find text entry for html: " + key);
        }
        if (!missingTLD.isEmpty()) {
            DomainValidatorTest.printMap(header, missingTLD, "TLD");
        }
        if (!missingCC.isEmpty()) {
            DomainValidatorTest.printMap(header, missingCC, "CC");
        }
        DomainValidatorTest.isInIanaList("INFRASTRUCTURE_TLDS", ianaTlds);
        DomainValidatorTest.isInIanaList("COUNTRY_CODE_TLDS", ianaTlds);
        DomainValidatorTest.isInIanaList("GENERIC_TLDS", ianaTlds);
        System.out.println("Finished checks");
    }

    private static void printMap(String header, Map<String, String> map, String string) {
        System.out.println("Entries missing from " + string + " List\n");
        if (header != null) {
            System.out.println("        // Taken from " + header);
        }
        for (Map.Entry<String, String> me : map.entrySet()) {
            System.out.println("        \"" + me.getKey() + "\", // " + me.getValue());
        }
        System.out.println("\nDone");
    }

    private static Map<String, String[]> getHtmlInfo(File f) throws IOException {
        String line;
        HashMap<String, String[]> info = new HashMap<String, String[]>();
        Pattern domain = Pattern.compile(".*<a href=\"/domains/root/db/([^.]+)\\.html");
        Pattern type = Pattern.compile("\\s+<td>([^<]+)</td>");
        Pattern comment = Pattern.compile("\\s+<td>([^<]+)</td>");
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            Matcher m = domain.matcher(line);
            if (!m.lookingAt()) continue;
            String dom = m.group(1);
            String typ = "??";
            String com = "??";
            line = br.readLine();
            while (line.matches("^\\s*$")) {
                line = br.readLine();
            }
            Matcher t = type.matcher(line);
            if (t.lookingAt()) {
                typ = t.group(1);
                line = br.readLine();
                if (line.matches("\\s+<!--.*")) {
                    while (!line.matches(".*-->.*")) {
                        line = br.readLine();
                    }
                    line = br.readLine();
                }
                while (!line.matches(".*</td>.*")) {
                    line = line + " " + br.readLine();
                }
                Matcher n = comment.matcher(line);
                if (n.lookingAt()) {
                    com = n.group(1);
                }
                if (com.contains("Not assigned") || com.contains("Retired") || typ.equals("test")) continue;
                info.put(dom.toLowerCase(Locale.ENGLISH), new String[]{typ, com});
                continue;
            }
            System.err.println("Unexpected type: " + line);
        }
        br.close();
        return info;
    }

    private static long download(File f, String tldurl, long timestamp) throws IOException {
        long modTime;
        int HOUR = 3600000;
        if (f.canRead()) {
            modTime = f.lastModified();
            if (modTime > System.currentTimeMillis() - 3600000L) {
                System.out.println("Skipping download - found recent " + f);
                return modTime;
            }
        } else {
            modTime = 0L;
        }
        HttpURLConnection hc = (HttpURLConnection)new URL(tldurl).openConnection();
        if (modTime > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            String since = sdf.format(new Date(modTime));
            hc.addRequestProperty("If-Modified-Since", since);
            System.out.println("Found " + f + " with date " + since);
        }
        if (hc.getResponseCode() == 304) {
            System.out.println("Already have most recent " + tldurl);
        } else {
            int len;
            System.out.println("Downloading " + tldurl);
            byte[] buff = new byte[1024];
            InputStream is = hc.getInputStream();
            FileOutputStream fos = new FileOutputStream(f);
            while ((len = is.read(buff)) != -1) {
                fos.write(buff, 0, len);
            }
            fos.close();
            is.close();
            System.out.println("Done");
        }
        return f.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isNotInRootZone(String domain) {
        block6: {
            tldurl = "http://www.iana.org/domains/root/db/" + domain + ".html";
            rootCheck = new File("target", "tld_" + domain + ".html");
            in = null;
            try {
                DomainValidatorTest.download(rootCheck, tldurl, 0L);
                in = new BufferedReader(new FileReader(rootCheck));
                while ((inputLine = in.readLine()) != null) {
                    if (!inputLine.contains("This domain is not present in the root zone at this time.")) continue;
                    var5_6 = true;
                    break block6;
                }
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                DomainValidatorTest.closeQuietly(in);
                return false;
                catch (Throwable var6_7) {
                    DomainValidatorTest.closeQuietly(in);
                    throw var6_7;
                }
            }
        }
        DomainValidatorTest.closeQuietly(in);
        return var5_6;
lbl-1000:
        // 1 sources

        {
            in.close();
        }
        DomainValidatorTest.closeQuietly(in);
        return false;
    }

    private static void closeQuietly(Closeable in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInIanaList(String arrayName, Set<String> ianaTlds) throws Exception {
        Field f = DomainValidator.class.getDeclaredField(arrayName);
        boolean isPrivate = Modifier.isPrivate(f.getModifiers());
        if (isPrivate) {
            f.setAccessible(true);
        }
        String[] array = (String[])f.get(null);
        try {
            boolean bl = DomainValidatorTest.isInIanaList(arrayName, array, ianaTlds);
            return bl;
        }
        finally {
            if (isPrivate) {
                f.setAccessible(false);
            }
        }
    }

    private static boolean isInIanaList(String name, String[] array, Set<String> ianaTlds) {
        for (int i = 0; i < array.length; ++i) {
            if (ianaTlds.contains(array[i])) continue;
            System.out.println(name + " contains unexpected value: " + array[i]);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSortedLowerCase(String arrayName) throws Exception {
        Field f = DomainValidator.class.getDeclaredField(arrayName);
        boolean isPrivate = Modifier.isPrivate(f.getModifiers());
        if (isPrivate) {
            f.setAccessible(true);
        }
        String[] array = (String[])f.get(null);
        try {
            boolean bl = DomainValidatorTest.isSortedLowerCase(arrayName, array);
            return bl;
        }
        finally {
            if (isPrivate) {
                f.setAccessible(false);
            }
        }
    }

    private static boolean isLowerCase(String string) {
        return string.equals(string.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isSortedLowerCase(String name, String[] array) {
        boolean sorted = true;
        boolean strictlySorted = true;
        int length = array.length;
        boolean lowerCase = DomainValidatorTest.isLowerCase(array[length - 1]);
        for (int i = 0; i < length - 1; ++i) {
            String entry = array[i];
            String nextEntry = array[i + 1];
            int cmp = entry.compareTo(nextEntry);
            if (cmp > 0) {
                System.out.println("Out of order entry: " + entry + " < " + nextEntry + " in " + name);
                sorted = false;
            } else if (cmp == 0) {
                strictlySorted = false;
                System.out.println("Duplicated entry: " + entry + " in " + name);
            }
            if (DomainValidatorTest.isLowerCase(entry)) continue;
            System.out.println("Non lowerCase entry: " + entry + " in " + name);
            lowerCase = false;
        }
        return sorted && strictlySorted && lowerCase;
    }
}

