/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.commons.validator.routines.TimeValidator;

public class TimeValidatorTest
extends TestCase {
    protected static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected static final TimeZone EST = TimeZone.getTimeZone("EST");
    protected TimeValidator validator;
    protected String[] patternValid = new String[]{"23-59-59", "00-00-00", "00-00-01", "0-0-0", "1-12-1", "10-49-18", "16-23-46"};
    protected Date[] patternExpect = new Date[]{TimeValidatorTest.createDate(null, 235959, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 1, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 11201, 0), TimeValidatorTest.createDate(null, 104918, 0), TimeValidatorTest.createDate(null, 162346, 0)};
    protected String[] localeValid = new String[]{"23:59", "00:00", "00:01", "0:0", "1:12", "10:49", "16:23"};
    protected Date[] localeExpect = new Date[]{TimeValidatorTest.createDate(null, 235900, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 100, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 11200, 0), TimeValidatorTest.createDate(null, 104900, 0), TimeValidatorTest.createDate(null, 162300, 0)};
    protected String[] patternInvalid = new String[]{"24-00-00", "24-00-01", "25-02-03", "10-61-31", "10-01-61", "05:02-29", "0X-01:01", "05-0X-01", "10-01-0X", "01:01:05", "10-10", "10--10", "10-10-"};
    protected String[] localeInvalid = new String[]{"24:00", "24:00", "25:02", "10:61", "05-02", "0X:01", "05:0X", "01-01", "10:", "10::1", "10:1:"};

    public TimeValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new TimeValidator();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.validator = null;
    }

    public void testPatternValid() {
        for (int i = 0; i < this.patternValid.length; ++i) {
            String text = i + " value=[" + this.patternValid[i] + "] failed ";
            Calendar calendar = this.validator.validate(this.patternValid[i], "HH-mm-ss");
            TimeValidatorTest.assertNotNull((String)("validateObj() " + text), (Object)calendar);
            Date date = calendar.getTime();
            TimeValidatorTest.assertTrue((String)("isValid() " + text), (boolean)this.validator.isValid(this.patternValid[i], "HH-mm-ss"));
            TimeValidatorTest.assertEquals((String)("compare " + text), (Object)this.patternExpect[i], (Object)date);
        }
    }

    public void testPatternInvalid() {
        for (int i = 0; i < this.patternInvalid.length; ++i) {
            String text = i + " value=[" + this.patternInvalid[i] + "] passed ";
            Calendar date = this.validator.validate(this.patternInvalid[i], "HH-mm-ss");
            TimeValidatorTest.assertNull((String)("validate() " + text + date), (Object)date);
            TimeValidatorTest.assertFalse((String)("isValid() " + text), (boolean)this.validator.isValid(this.patternInvalid[i], "HH-mm-ss"));
        }
    }

    public void testLocaleValid() {
        for (int i = 0; i < this.localeValid.length; ++i) {
            String text = i + " value=[" + this.localeValid[i] + "] failed ";
            Calendar calendar = this.validator.validate(this.localeValid[i], Locale.UK);
            TimeValidatorTest.assertNotNull((String)("validate() " + text), (Object)calendar);
            Date date = calendar.getTime();
            TimeValidatorTest.assertTrue((String)("isValid() " + text), (boolean)this.validator.isValid(this.localeValid[i], Locale.UK));
            TimeValidatorTest.assertEquals((String)("compare " + text), (Object)this.localeExpect[i], (Object)date);
        }
    }

    public void testLocaleInvalid() {
        for (int i = 0; i < this.localeInvalid.length; ++i) {
            String text = i + " value=[" + this.localeInvalid[i] + "] passed ";
            Calendar date = this.validator.validate(this.localeInvalid[i], Locale.US);
            TimeValidatorTest.assertNull((String)("validate() " + text + date), (Object)date);
            TimeValidatorTest.assertFalse((String)("isValid() " + text), (boolean)this.validator.isValid(this.localeInvalid[i], Locale.UK));
        }
    }

    public void testTimeZone() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        TimeZone defaultZone = TimeZone.getDefault();
        TimeZone.setDefault(GMT);
        Calendar result = null;
        result = this.validator.validate("18:01");
        TimeValidatorTest.assertNotNull((String)"default result", (Object)result);
        TimeValidatorTest.assertEquals((String)"default zone", (Object)GMT, (Object)result.getTimeZone());
        TimeValidatorTest.assertEquals((String)"default hour", (int)18, (int)result.get(11));
        TimeValidatorTest.assertEquals((String)"default minute", (int)1, (int)result.get(12));
        result = null;
        result = this.validator.validate("16:49", EST);
        TimeValidatorTest.assertNotNull((String)"zone result", (Object)result);
        TimeValidatorTest.assertEquals((String)"zone zone", (Object)EST, (Object)result.getTimeZone());
        TimeValidatorTest.assertEquals((String)"zone hour", (int)16, (int)result.get(11));
        TimeValidatorTest.assertEquals((String)"zone minute", (int)49, (int)result.get(12));
        result = null;
        result = this.validator.validate("14-34", "HH-mm", EST);
        TimeValidatorTest.assertNotNull((String)"pattern result", (Object)result);
        TimeValidatorTest.assertEquals((String)"pattern zone", (Object)EST, (Object)result.getTimeZone());
        TimeValidatorTest.assertEquals((String)"pattern hour", (int)14, (int)result.get(11));
        TimeValidatorTest.assertEquals((String)"pattern minute", (int)34, (int)result.get(12));
        result = null;
        result = this.validator.validate("7:18 PM", Locale.US, EST);
        TimeValidatorTest.assertNotNull((String)"locale result", (Object)result);
        TimeValidatorTest.assertEquals((String)"locale zone", (Object)EST, (Object)result.getTimeZone());
        TimeValidatorTest.assertEquals((String)"locale hour", (int)19, (int)result.get(11));
        TimeValidatorTest.assertEquals((String)"locale minute", (int)18, (int)result.get(12));
        result = null;
        result = this.validator.validate("31/Dez/05 21-05", "dd/MMM/yy HH-mm", Locale.GERMAN, EST);
        TimeValidatorTest.assertNotNull((String)"pattern result", (Object)result);
        TimeValidatorTest.assertEquals((String)"pattern zone", (Object)EST, (Object)result.getTimeZone());
        TimeValidatorTest.assertEquals((String)"pattern day", (int)2005, (int)result.get(1));
        TimeValidatorTest.assertEquals((String)"pattern day", (int)11, (int)result.get(2));
        TimeValidatorTest.assertEquals((String)"pattern day", (int)31, (int)result.get(5));
        TimeValidatorTest.assertEquals((String)"pattern hour", (int)21, (int)result.get(11));
        TimeValidatorTest.assertEquals((String)"pattern minute", (int)5, (int)result.get(12));
        result = null;
        result = this.validator.validate("31/Dez/05 21-05", "dd/MMM/yy HH-mm", Locale.GERMAN);
        TimeValidatorTest.assertNotNull((String)"pattern result", (Object)result);
        TimeValidatorTest.assertEquals((String)"pattern zone", (Object)GMT, (Object)result.getTimeZone());
        TimeValidatorTest.assertEquals((String)"pattern day", (int)2005, (int)result.get(1));
        TimeValidatorTest.assertEquals((String)"pattern day", (int)11, (int)result.get(2));
        TimeValidatorTest.assertEquals((String)"pattern day", (int)31, (int)result.get(5));
        TimeValidatorTest.assertEquals((String)"pattern hour", (int)21, (int)result.get(11));
        TimeValidatorTest.assertEquals((String)"pattern minute", (int)5, (int)result.get(12));
        result = null;
        Locale.setDefault(origDefault);
        TimeZone.setDefault(defaultZone);
    }

    public void testFormat() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        Calendar test = TimeValidator.getInstance().validate("16:49:23", "HH:mm:ss");
        TimeValidatorTest.assertNotNull((String)"Test Date ", (Object)test);
        TimeValidatorTest.assertEquals((String)"Format pattern", (String)"16-49-23", (String)this.validator.format((Object)test, "HH-mm-ss"));
        TimeValidatorTest.assertEquals((String)"Format locale", (String)"4:49 PM", (String)this.validator.format((Object)test, Locale.US));
        TimeValidatorTest.assertEquals((String)"Format default", (String)"16:49", (String)this.validator.format((Object)test));
        Locale.setDefault(origDefault);
    }

    public void testCompare() {
        int testTime = 154523;
        int min = 100;
        int hour = 10000;
        Calendar milliGreater = TimeValidatorTest.createTime(GMT, testTime, 500);
        Calendar value = TimeValidatorTest.createTime(GMT, testTime, 400);
        Calendar milliLess = TimeValidatorTest.createTime(GMT, testTime, 300);
        Calendar secGreater = TimeValidatorTest.createTime(GMT, testTime + 1, 100);
        Calendar secLess = TimeValidatorTest.createTime(GMT, testTime - 1, 100);
        Calendar minGreater = TimeValidatorTest.createTime(GMT, testTime + min, 100);
        Calendar minLess = TimeValidatorTest.createTime(GMT, testTime - min, 100);
        Calendar hourGreater = TimeValidatorTest.createTime(GMT, testTime + hour, 100);
        Calendar hourLess = TimeValidatorTest.createTime(GMT, testTime - hour, 100);
        TimeValidatorTest.assertEquals((String)"mili LT", (int)-1, (int)this.validator.compareTime(value, milliGreater));
        TimeValidatorTest.assertEquals((String)"mili EQ", (int)0, (int)this.validator.compareTime(value, value));
        TimeValidatorTest.assertEquals((String)"mili GT", (int)1, (int)this.validator.compareTime(value, milliLess));
        TimeValidatorTest.assertEquals((String)"secs LT", (int)-1, (int)this.validator.compareSeconds(value, secGreater));
        TimeValidatorTest.assertEquals((String)"secs =1", (int)0, (int)this.validator.compareSeconds(value, milliGreater));
        TimeValidatorTest.assertEquals((String)"secs =2", (int)0, (int)this.validator.compareSeconds(value, value));
        TimeValidatorTest.assertEquals((String)"secs =3", (int)0, (int)this.validator.compareSeconds(value, milliLess));
        TimeValidatorTest.assertEquals((String)"secs GT", (int)1, (int)this.validator.compareSeconds(value, secLess));
        TimeValidatorTest.assertEquals((String)"mins LT", (int)-1, (int)this.validator.compareMinutes(value, minGreater));
        TimeValidatorTest.assertEquals((String)"mins =1", (int)0, (int)this.validator.compareMinutes(value, secGreater));
        TimeValidatorTest.assertEquals((String)"mins =2", (int)0, (int)this.validator.compareMinutes(value, value));
        TimeValidatorTest.assertEquals((String)"mins =3", (int)0, (int)this.validator.compareMinutes(value, secLess));
        TimeValidatorTest.assertEquals((String)"mins GT", (int)1, (int)this.validator.compareMinutes(value, minLess));
        TimeValidatorTest.assertEquals((String)"hour LT", (int)-1, (int)this.validator.compareHours(value, hourGreater));
        TimeValidatorTest.assertEquals((String)"hour =1", (int)0, (int)this.validator.compareHours(value, minGreater));
        TimeValidatorTest.assertEquals((String)"hour =2", (int)0, (int)this.validator.compareHours(value, value));
        TimeValidatorTest.assertEquals((String)"hour =3", (int)0, (int)this.validator.compareHours(value, minLess));
        TimeValidatorTest.assertEquals((String)"hour GT", (int)1, (int)this.validator.compareHours(value, hourLess));
    }

    protected static Calendar createTime(TimeZone zone, int time, int millisecond) {
        Calendar calendar = zone == null ? Calendar.getInstance() : Calendar.getInstance(zone);
        int hour = time / 10000 * 10000;
        int min = time / 100 * 100 - hour;
        int sec = time - (hour + min);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, hour / 10000);
        calendar.set(12, min / 100);
        calendar.set(13, sec);
        calendar.set(14, millisecond);
        return calendar;
    }

    protected static Date createDate(TimeZone zone, int time, int millisecond) {
        Calendar calendar = TimeValidatorTest.createTime(zone, time, millisecond);
        return calendar.getTime();
    }
}

