/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.xml.sax.SAXException;

public class LocaleTest
extends AbstractCommonTest {
    protected static String FORM_KEY = "nameForm";
    protected static String ACTION = "required";

    public LocaleTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        this.loadResources("LocaleTest-config.xml");
    }

    protected void tearDown() {
    }

    public void testLocale1() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("");
        this.valueTest(name, new Locale("en", "US", "TEST1"), false, false, false);
    }

    public void testLocale2() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("");
        this.valueTest(name, new Locale("en", "US", "TEST2"), true, false, true);
    }

    public void testLocale3() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("");
        this.valueTest(name, new Locale("en", "UK"), false, true, true);
    }

    public void testLocale4() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("");
        this.valueTest(name, new Locale("en", "UK", "TEST"), false, true, true);
    }

    public void testLocale5() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("");
        this.valueTest(name, new Locale("en", ""), false, false, true);
    }

    private void valueTest(Object name, Locale loc, boolean firstGood, boolean lastGood, boolean middleGood) throws ValidatorException {
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", name);
        validator.setParameter("java.util.Locale", (Object)loc);
        ValidatorResults results = null;
        results = validator.validate();
        LocaleTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult resultlast = results.getValidatorResult("lastName");
        ValidatorResult resultfirst = results.getValidatorResult("firstName");
        ValidatorResult resultmiddle = results.getValidatorResult("middleName");
        if (firstGood) {
            LocaleTest.assertNull((Object)resultfirst);
        } else {
            LocaleTest.assertNotNull((Object)resultfirst);
        }
        if (middleGood) {
            LocaleTest.assertNull((Object)resultmiddle);
        } else {
            LocaleTest.assertNotNull((Object)resultmiddle);
        }
        if (lastGood) {
            LocaleTest.assertNull((Object)resultlast);
        } else {
            LocaleTest.assertNotNull((Object)resultlast);
        }
    }
}

