/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.BigDecimalValidator;

public class BigDecimalValidatorTest
extends AbstractNumberValidatorTest {
    public BigDecimalValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new BigDecimalValidator(false);
        this.strictValidator = new BigDecimalValidator();
        this.testPattern = "#,###.###";
        this.max = null;
        this.maxPlusOne = null;
        this.min = null;
        this.minMinusOne = null;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.234X"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = new BigDecimal("1234.5");
        BigDecimal testNumber2 = new BigDecimal(".1");
        BigDecimal testNumber3 = new BigDecimal("12345.67899");
        this.testZero = new BigDecimal("0");
        this.validStrict = new String[]{"0", "1234.5", "1,234.5", ".1", "12345.678990"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, testNumber2, testNumber3};
        this.valid = new String[]{"0", "1234.5", "1,234.5", "1,234.5", "1234.5X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234.5";
        this.localeValue = this.testStringDE = "1.234,5";
        this.localePattern = "#.###,#";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    public void testBigDecimalValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        BigDecimal expected = new BigDecimal(12345);
        BigDecimalValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)BigDecimalValidator.getInstance().validate(defaultVal));
        BigDecimalValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)BigDecimalValidator.getInstance().validate(localeVal, locale));
        BigDecimalValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)BigDecimalValidator.getInstance().validate(patternVal, pattern));
        BigDecimalValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)BigDecimalValidator.getInstance().validate(germanPatternVal, pattern, Locale.GERMAN));
        BigDecimalValidatorTest.assertTrue((String)"isValid(A) default", (boolean)BigDecimalValidator.getInstance().isValid(defaultVal));
        BigDecimalValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)BigDecimalValidator.getInstance().isValid(localeVal, locale));
        BigDecimalValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)BigDecimalValidator.getInstance().isValid(patternVal, pattern));
        BigDecimalValidatorTest.assertTrue((String)"isValid(A) both", (boolean)BigDecimalValidator.getInstance().isValid(germanPatternVal, pattern, Locale.GERMAN));
        BigDecimalValidatorTest.assertNull((String)"validate(B) default", (Object)BigDecimalValidator.getInstance().validate(XXXX));
        BigDecimalValidatorTest.assertNull((String)"validate(B) locale ", (Object)BigDecimalValidator.getInstance().validate(XXXX, locale));
        BigDecimalValidatorTest.assertNull((String)"validate(B) pattern", (Object)BigDecimalValidator.getInstance().validate(XXXX, pattern));
        BigDecimalValidatorTest.assertNull((String)"validate(B) both", (Object)BigDecimalValidator.getInstance().validate(patternVal, pattern, Locale.GERMAN));
        BigDecimalValidatorTest.assertFalse((String)"isValid(B) default", (boolean)BigDecimalValidator.getInstance().isValid(XXXX));
        BigDecimalValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)BigDecimalValidator.getInstance().isValid(XXXX, locale));
        BigDecimalValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)BigDecimalValidator.getInstance().isValid(XXXX, pattern));
        BigDecimalValidatorTest.assertFalse((String)"isValid(B) both", (boolean)BigDecimalValidator.getInstance().isValid(patternVal, pattern, Locale.GERMAN));
    }

    public void testBigDecimalRangeMinMax() {
        BigDecimalValidator validator = new BigDecimalValidator(true, 0, true);
        BigDecimal number9 = new BigDecimal("9");
        BigDecimal number10 = new BigDecimal("10");
        BigDecimal number11 = new BigDecimal("11");
        BigDecimal number19 = new BigDecimal("19");
        BigDecimal number20 = new BigDecimal("20");
        BigDecimal number21 = new BigDecimal("21");
        float min = 10.0f;
        float max = 20.0f;
        BigDecimalValidatorTest.assertFalse((String)"isInRange(A) < min", (boolean)validator.isInRange(number9, (double)min, (double)max));
        BigDecimalValidatorTest.assertTrue((String)"isInRange(A) = min", (boolean)validator.isInRange(number10, (double)min, (double)max));
        BigDecimalValidatorTest.assertTrue((String)"isInRange(A) in range", (boolean)validator.isInRange(number11, (double)min, (double)max));
        BigDecimalValidatorTest.assertTrue((String)"isInRange(A) = max", (boolean)validator.isInRange(number20, (double)min, (double)max));
        BigDecimalValidatorTest.assertFalse((String)"isInRange(A) > max", (boolean)validator.isInRange(number21, (double)min, (double)max));
        BigDecimalValidatorTest.assertFalse((String)"minValue(A) < min", (boolean)validator.minValue(number9, (double)min));
        BigDecimalValidatorTest.assertTrue((String)"minValue(A) = min", (boolean)validator.minValue(number10, (double)min));
        BigDecimalValidatorTest.assertTrue((String)"minValue(A) > min", (boolean)validator.minValue(number11, (double)min));
        BigDecimalValidatorTest.assertTrue((String)"maxValue(A) < max", (boolean)validator.maxValue(number19, (double)max));
        BigDecimalValidatorTest.assertTrue((String)"maxValue(A) = max", (boolean)validator.maxValue(number20, (double)max));
        BigDecimalValidatorTest.assertFalse((String)"maxValue(A) > max", (boolean)validator.maxValue(number21, (double)max));
    }
}

