/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.ISBNCheckDigit;

public class ISBNCheckDigitTest
extends AbstractCheckDigitTest {
    public ISBNCheckDigitTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.routine = ISBNCheckDigit.ISBN_CHECK_DIGIT;
        this.valid = new String[]{"9780072129519", "9780764558313", "1930110995", "020163385X", "1590596277", "9781590596272"};
        this.missingMessage = "ISBN Code is missing";
        this.zeroSum = "000000000000";
    }

    public void testInvalidLength() {
        ISBNCheckDigitTest.assertFalse((String)"isValid() Lth 9 ", (boolean)this.routine.isValid("123456789"));
        ISBNCheckDigitTest.assertFalse((String)"isValid() Lth 11", (boolean)this.routine.isValid("12345678901"));
        ISBNCheckDigitTest.assertFalse((String)"isValid() Lth 12", (boolean)this.routine.isValid("123456789012"));
        ISBNCheckDigitTest.assertFalse((String)"isValid() Lth 14", (boolean)this.routine.isValid("12345678901234"));
        try {
            this.routine.calculate("12345678");
            ISBNCheckDigitTest.fail((String)"calculate() Lth 8 - expected exception");
        }
        catch (Exception e) {
            ISBNCheckDigitTest.assertEquals((String)"calculate() Lth 8", (String)"Invalid ISBN Length = 8", (String)e.getMessage());
        }
        try {
            this.routine.calculate("1234567890");
            ISBNCheckDigitTest.fail((String)"calculate() Lth 10 - expected exception");
        }
        catch (Exception e) {
            ISBNCheckDigitTest.assertEquals((String)"calculate() Lth 10", (String)"Invalid ISBN Length = 10", (String)e.getMessage());
        }
        try {
            this.routine.calculate("12345678901");
            ISBNCheckDigitTest.fail((String)"calculate() Lth 11 - expected exception");
        }
        catch (Exception e) {
            ISBNCheckDigitTest.assertEquals((String)"calculate() Lth 11", (String)"Invalid ISBN Length = 11", (String)e.getMessage());
        }
        try {
            this.routine.calculate("1234567890123");
            ISBNCheckDigitTest.fail((String)"calculate() Lth 13 - expected exception");
        }
        catch (Exception e) {
            ISBNCheckDigitTest.assertEquals((String)"calculate() Lth 13", (String)"Invalid ISBN Length = 13", (String)e.getMessage());
        }
    }
}

