/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import junit.framework.TestCase;
import org.apache.commons.validator.routines.ISINValidator;

public class ISINValidatorTest
extends TestCase {
    private static final ISINValidator VALIDATOR_TRUE = ISINValidator.getInstance((boolean)true);
    private static final ISINValidator VALIDATOR_FALSE = ISINValidator.getInstance((boolean)false);
    private final String[] validFormat = new String[]{"US0378331005", "BMG8571G1096", "AU0000XVGZA3", "GB0002634946", "FR0004026250", "DK0009763344", "GB00B03MLX29", "US7562071065", "US56845T3059", "LU0327357389", "US032511BN64", "INE112A01023", "EZ0000000003", "XS0000000009"};
    private final String[] invalidFormat = new String[]{null, "", "   ", "US037833100O", "BMG8571G109D", "AU0000XVGZAD", "GB000263494I", "FR000402625C", "DK000976334H", "3133EHHF3", "AU0000xvgzA3", "gb0002634946"};
    private final String[] invalidFormatTrue = new String[]{"AA0000000006"};

    public ISINValidatorTest(String name) {
        super(name);
    }

    public void testIsValidTrue() {
        for (String f : this.validFormat) {
            ISINValidatorTest.assertTrue((String)f, (boolean)VALIDATOR_TRUE.isValid(f));
        }
    }

    public void testInvalidTrue() {
        for (String f : this.invalidFormat) {
            ISINValidatorTest.assertFalse((String)f, (boolean)VALIDATOR_TRUE.isValid(f));
        }
        for (String f : this.invalidFormatTrue) {
            ISINValidatorTest.assertFalse((String)f, (boolean)VALIDATOR_TRUE.isValid(f));
        }
    }

    public void testIsValidFalse() {
        for (String f : this.validFormat) {
            ISINValidatorTest.assertTrue((String)f, (boolean)VALIDATOR_FALSE.isValid(f));
        }
    }

    public void testInvalidFalse() {
        for (String f : this.invalidFormat) {
            ISINValidatorTest.assertFalse((String)f, (boolean)VALIDATOR_FALSE.isValid(f));
        }
    }
}

