/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.LongValidator;

public class LongValidatorTest
extends AbstractNumberValidatorTest {
    private static final Long LONG_MIN_VAL = Long.MIN_VALUE;
    private static final Long LONG_MAX_VAL = Long.MAX_VALUE;
    private static final String LONG_MAX = "9223372036854775807";
    private static final String LONG_MAX_0 = "9223372036854775807.99999999999999999999999";
    private static final String LONG_MAX_1 = "9223372036854775808";
    private static final String LONG_MIN = "-9223372036854775808";
    private static final String LONG_MIN_0 = "-9223372036854775808.99999999999999999999999";
    private static final String LONG_MIN_1 = "-9223372036854775809";
    private static final String NINES = "9999999999999999999999999999999999999";

    public LongValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new LongValidator(false, 0);
        this.strictValidator = new LongValidator();
        this.testPattern = "#,###";
        this.max = null;
        this.maxPlusOne = null;
        this.min = null;
        this.minMinusOne = null;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2", LONG_MAX_1, LONG_MIN_1, NINES};
        this.invalid = new String[]{null, "", "X", "X12", "", LONG_MAX_1, LONG_MIN_1, NINES};
        this.testNumber = 1234L;
        this.testZero = 0L;
        this.validStrict = new String[]{"0", "1234", "1,234", LONG_MAX, LONG_MIN};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, LONG_MAX_VAL, LONG_MIN_VAL};
        this.valid = new String[]{"0", "1234", "1,234", "1,234.5", "1234X", LONG_MAX, LONG_MIN, LONG_MAX_0, LONG_MIN_0};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber, LONG_MAX_VAL, LONG_MIN_VAL, LONG_MAX_VAL, LONG_MIN_VAL};
        this.testStringUS = "1,234";
        this.localeValue = this.testStringDE = "1.234";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    public void testLongValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        Long expected = 12345L;
        LongValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)LongValidator.getInstance().validate(defaultVal));
        LongValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)LongValidator.getInstance().validate(localeVal, locale));
        LongValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)LongValidator.getInstance().validate(patternVal, pattern));
        LongValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)LongValidator.getInstance().validate(germanPatternVal, pattern, Locale.GERMAN));
        LongValidatorTest.assertTrue((String)"isValid(A) default", (boolean)LongValidator.getInstance().isValid(defaultVal));
        LongValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)LongValidator.getInstance().isValid(localeVal, locale));
        LongValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)LongValidator.getInstance().isValid(patternVal, pattern));
        LongValidatorTest.assertTrue((String)"isValid(A) both", (boolean)LongValidator.getInstance().isValid(germanPatternVal, pattern, Locale.GERMAN));
        LongValidatorTest.assertNull((String)"validate(B) default", (Object)LongValidator.getInstance().validate(XXXX));
        LongValidatorTest.assertNull((String)"validate(B) locale ", (Object)LongValidator.getInstance().validate(XXXX, locale));
        LongValidatorTest.assertNull((String)"validate(B) pattern", (Object)LongValidator.getInstance().validate(XXXX, pattern));
        LongValidatorTest.assertNull((String)"validate(B) both", (Object)LongValidator.getInstance().validate(patternVal, pattern, Locale.GERMAN));
        LongValidatorTest.assertFalse((String)"isValid(B) default", (boolean)LongValidator.getInstance().isValid(XXXX));
        LongValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)LongValidator.getInstance().isValid(XXXX, locale));
        LongValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)LongValidator.getInstance().isValid(XXXX, pattern));
        LongValidatorTest.assertFalse((String)"isValid(B) both", (boolean)LongValidator.getInstance().isValid(patternVal, pattern, Locale.GERMAN));
    }

    public void testLongRangeMinMax() {
        LongValidator validator = (LongValidator)this.strictValidator;
        Long number9 = validator.validate("9", "#");
        Long number10 = validator.validate("10", "#");
        Long number11 = validator.validate("11", "#");
        Long number19 = validator.validate("19", "#");
        Long number20 = validator.validate("20", "#");
        Long number21 = validator.validate("21", "#");
        LongValidatorTest.assertFalse((String)"isInRange() < min", (boolean)validator.isInRange(number9, 10L, 20L));
        LongValidatorTest.assertTrue((String)"isInRange() = min", (boolean)validator.isInRange(number10, 10L, 20L));
        LongValidatorTest.assertTrue((String)"isInRange() in range", (boolean)validator.isInRange(number11, 10L, 20L));
        LongValidatorTest.assertTrue((String)"isInRange() = max", (boolean)validator.isInRange(number20, 10L, 20L));
        LongValidatorTest.assertFalse((String)"isInRange() > max", (boolean)validator.isInRange(number21, 10L, 20L));
        LongValidatorTest.assertFalse((String)"minValue() < min", (boolean)validator.minValue(number9, 10L));
        LongValidatorTest.assertTrue((String)"minValue() = min", (boolean)validator.minValue(number10, 10L));
        LongValidatorTest.assertTrue((String)"minValue() > min", (boolean)validator.minValue(number11, 10L));
        LongValidatorTest.assertTrue((String)"maxValue() < max", (boolean)validator.maxValue(number19, 20L));
        LongValidatorTest.assertTrue((String)"maxValue() = max", (boolean)validator.maxValue(number20, 20L));
        LongValidatorTest.assertFalse((String)"maxValue() > max", (boolean)validator.maxValue(number21, 20L));
    }
}

