/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.TypeBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;
import org.xml.sax.SAXException;

public class GenericTypeValidatorTest
extends AbstractCommonTest {
    protected static String FORM_KEY = "typeForm";
    protected static String ACTION = "byte";

    public GenericTypeValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        this.loadResources("GenericTypeValidatorTest-config.xml");
    }

    protected void tearDown() {
    }

    public void testType() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("129");
        info.setInteger("-144");
        info.setLong("88000");
        info.setFloat("12.1555f");
        info.setDouble("129.1551511111d");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        ValidatorResults results = null;
        results = validator.validate();
        GenericTypeValidatorTest.assertNotNull((String)"Results are null.", (Object)results);
        Map hResultValues = results.getResultValueMap();
        GenericTypeValidatorTest.assertTrue((String)"Expecting byte result to be an instance of Byte.", (boolean)(hResultValues.get("byte") instanceof Byte));
        GenericTypeValidatorTest.assertTrue((String)"Expecting short result to be an instance of Short.", (boolean)(hResultValues.get("short") instanceof Short));
        GenericTypeValidatorTest.assertTrue((String)"Expecting integer result to be an instance of Integer.", (boolean)(hResultValues.get("integer") instanceof Integer));
        GenericTypeValidatorTest.assertTrue((String)"Expecting long result to be an instance of Long.", (boolean)(hResultValues.get("long") instanceof Long));
        GenericTypeValidatorTest.assertTrue((String)"Expecting float result to be an instance of Float.", (boolean)(hResultValues.get("float") instanceof Float));
        GenericTypeValidatorTest.assertTrue((String)"Expecting double result to be an instance of Double.", (boolean)(hResultValues.get("double") instanceof Double));
        for (String key : hResultValues.keySet()) {
            Object value = hResultValues.get(key);
            GenericTypeValidatorTest.assertNotNull((String)"value ValidatorResults.getResultValueMap() should not be null.", value);
        }
    }

    public void testUSLocale() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("129");
        info.setInteger("-144");
        info.setLong("88000");
        info.setFloat("12.1555");
        info.setDouble("129.1551511111");
        info.setDate("12/21/2010");
        this.localeTest(info, Locale.US);
    }

    public void testFRLocale() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("-129");
        info.setInteger("1443");
        info.setLong("88000");
        info.setFloat("12,1555");
        info.setDouble("129,1551511111");
        info.setDate("21/12/2010");
        Map<String, ?> map = this.localeTest(info, Locale.FRENCH);
        GenericTypeValidatorTest.assertTrue((String)"float value not correct", (((Float)map.get("float")).intValue() == 12 ? 1 : 0) != 0);
        GenericTypeValidatorTest.assertTrue((String)"double value not correct", (((Double)map.get("double")).intValue() == 129 ? 1 : 0) != 0);
    }

    private Map<String, ?> localeTest(TypeBean info, Locale locale) throws ValidatorException {
        Validator validator = new Validator(this.resources, "typeLocaleForm");
        validator.setParameter("java.lang.Object", (Object)info);
        validator.setParameter("java.util.Locale", (Object)locale);
        ValidatorResults results = null;
        results = validator.validate();
        GenericTypeValidatorTest.assertNotNull((String)"Results are null.", (Object)results);
        Map hResultValues = results.getResultValueMap();
        GenericTypeValidatorTest.assertTrue((String)("Expecting byte result to be an instance of Byte for locale: " + locale), (boolean)(hResultValues.get("byte") instanceof Byte));
        GenericTypeValidatorTest.assertTrue((String)("Expecting short result to be an instance of Short for locale: " + locale), (boolean)(hResultValues.get("short") instanceof Short));
        GenericTypeValidatorTest.assertTrue((String)("Expecting integer result to be an instance of Integer for locale: " + locale), (boolean)(hResultValues.get("integer") instanceof Integer));
        GenericTypeValidatorTest.assertTrue((String)("Expecting long result to be an instance of Long for locale: " + locale), (boolean)(hResultValues.get("long") instanceof Long));
        GenericTypeValidatorTest.assertTrue((String)("Expecting float result to be an instance of Float for locale: " + locale), (boolean)(hResultValues.get("float") instanceof Float));
        GenericTypeValidatorTest.assertTrue((String)("Expecting double result to be an instance of Double for locale: " + locale), (boolean)(hResultValues.get("double") instanceof Double));
        GenericTypeValidatorTest.assertTrue((String)("Expecting date result to be an instance of Date for locale: " + locale), (boolean)(hResultValues.get("date") instanceof Date));
        for (String key : hResultValues.keySet()) {
            Object value = hResultValues.get(key);
            GenericTypeValidatorTest.assertNotNull((String)("value ValidatorResults.getResultValueMap() should not be null for locale: " + locale), value);
        }
        return hResultValues;
    }
}

