/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.validator.routines.AbstractCalendarValidator;
import org.apache.commons.validator.routines.AbstractCalendarValidatorTest;
import org.apache.commons.validator.routines.CalendarValidator;

public class CalendarValidatorTest
extends AbstractCalendarValidatorTest {
    private static final int DATE_2005_11_23 = 20051123;
    private static final int TIME_12_03_45 = 120345;
    private CalendarValidator calValidator;

    public CalendarValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.calValidator = new CalendarValidator();
        this.validator = this.calValidator;
    }

    public void testCalendarValidatorMethods() {
        Locale.setDefault(Locale.US);
        Locale locale = Locale.GERMAN;
        String pattern = "yyyy-MM-dd";
        String patternVal = "2005-12-31";
        String germanVal = "31 Dez 2005";
        String germanPattern = "dd MMM yyyy";
        String localeVal = "31.12.2005";
        String defaultVal = "12/31/05";
        String XXXX = "XXXX";
        Date expected = CalendarValidatorTest.createCalendar(null, 20051231, 0).getTime();
        CalendarValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)CalendarValidator.getInstance().validate(defaultVal).getTime());
        CalendarValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)CalendarValidator.getInstance().validate(localeVal, locale).getTime());
        CalendarValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)CalendarValidator.getInstance().validate(patternVal, pattern).getTime());
        CalendarValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)CalendarValidator.getInstance().validate(germanVal, germanPattern, Locale.GERMAN).getTime());
        CalendarValidatorTest.assertTrue((String)"isValid(A) default", (boolean)CalendarValidator.getInstance().isValid(defaultVal));
        CalendarValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)CalendarValidator.getInstance().isValid(localeVal, locale));
        CalendarValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)CalendarValidator.getInstance().isValid(patternVal, pattern));
        CalendarValidatorTest.assertTrue((String)"isValid(A) both", (boolean)CalendarValidator.getInstance().isValid(germanVal, germanPattern, Locale.GERMAN));
        CalendarValidatorTest.assertNull((String)"validate(B) default", (Object)CalendarValidator.getInstance().validate(XXXX));
        CalendarValidatorTest.assertNull((String)"validate(B) locale ", (Object)CalendarValidator.getInstance().validate(XXXX, locale));
        CalendarValidatorTest.assertNull((String)"validate(B) pattern", (Object)CalendarValidator.getInstance().validate(XXXX, pattern));
        CalendarValidatorTest.assertNull((String)"validate(B) both", (Object)CalendarValidator.getInstance().validate("31 Dec 2005", germanPattern, Locale.GERMAN));
        CalendarValidatorTest.assertFalse((String)"isValid(B) default", (boolean)CalendarValidator.getInstance().isValid(XXXX));
        CalendarValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)CalendarValidator.getInstance().isValid(XXXX, locale));
        CalendarValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)CalendarValidator.getInstance().isValid(XXXX, pattern));
        CalendarValidatorTest.assertFalse((String)"isValid(B) both", (boolean)CalendarValidator.getInstance().isValid("31 Dec 2005", germanPattern, Locale.GERMAN));
        TimeZone zone = TimeZone.getDefault().getRawOffset() == EET.getRawOffset() ? EST : EET;
        Date expectedZone = CalendarValidatorTest.createCalendar(zone, 20051231, 0).getTime();
        CalendarValidatorTest.assertFalse((String)"default/EET same ", (expected.getTime() == expectedZone.getTime() ? 1 : 0) != 0);
        CalendarValidatorTest.assertEquals((String)"validate(C) default", (Object)expectedZone, (Object)CalendarValidator.getInstance().validate(defaultVal, zone).getTime());
        CalendarValidatorTest.assertEquals((String)"validate(C) locale ", (Object)expectedZone, (Object)CalendarValidator.getInstance().validate(localeVal, locale, zone).getTime());
        CalendarValidatorTest.assertEquals((String)"validate(C) pattern", (Object)expectedZone, (Object)CalendarValidator.getInstance().validate(patternVal, pattern, zone).getTime());
        CalendarValidatorTest.assertEquals((String)"validate(C) both", (Object)expectedZone, (Object)CalendarValidator.getInstance().validate(germanVal, germanPattern, Locale.GERMAN, zone).getTime());
    }

    public void testCompare() {
        int sameTime = 124522;
        int testDate = 20050823;
        Calendar diffHour = CalendarValidatorTest.createCalendar(GMT, testDate, 115922);
        Calendar diffMin = CalendarValidatorTest.createCalendar(GMT, testDate, 124422);
        Calendar diffSec = CalendarValidatorTest.createCalendar(GMT, testDate, 124521);
        Calendar value = CalendarValidatorTest.createCalendar(GMT, testDate, sameTime);
        Calendar cal20050824 = CalendarValidatorTest.createCalendar(GMT, 20050824, sameTime);
        Calendar cal20050822 = CalendarValidatorTest.createCalendar(GMT, 20050822, sameTime);
        Calendar cal20050830 = CalendarValidatorTest.createCalendar(GMT, 20050830, sameTime);
        Calendar cal20050816 = CalendarValidatorTest.createCalendar(GMT, 20050816, sameTime);
        Calendar cal20050901 = CalendarValidatorTest.createCalendar(GMT, 20050901, sameTime);
        Calendar cal20050801 = CalendarValidatorTest.createCalendar(GMT, 20050801, sameTime);
        Calendar cal20050731 = CalendarValidatorTest.createCalendar(GMT, 20050731, sameTime);
        Calendar cal20051101 = CalendarValidatorTest.createCalendar(GMT, 20051101, sameTime);
        Calendar cal20051001 = CalendarValidatorTest.createCalendar(GMT, 20051001, sameTime);
        Calendar cal20050701 = CalendarValidatorTest.createCalendar(GMT, 20050701, sameTime);
        Calendar cal20050630 = CalendarValidatorTest.createCalendar(GMT, 20050630, sameTime);
        Calendar cal20060101 = CalendarValidatorTest.createCalendar(GMT, 20060101, sameTime);
        Calendar cal20050101 = CalendarValidatorTest.createCalendar(GMT, 20050101, sameTime);
        Calendar cal20041231 = CalendarValidatorTest.createCalendar(GMT, 20041231, sameTime);
        CalendarValidatorTest.assertEquals((String)"hour GT", (int)1, (int)this.calValidator.compare(value, diffHour, 11));
        CalendarValidatorTest.assertEquals((String)"hour EQ", (int)0, (int)this.calValidator.compare(value, diffMin, 11));
        CalendarValidatorTest.assertEquals((String)"mins GT", (int)1, (int)this.calValidator.compare(value, diffMin, 12));
        CalendarValidatorTest.assertEquals((String)"mins EQ", (int)0, (int)this.calValidator.compare(value, diffSec, 12));
        CalendarValidatorTest.assertEquals((String)"secs GT", (int)1, (int)this.calValidator.compare(value, diffSec, 13));
        CalendarValidatorTest.assertEquals((String)"date LT", (int)-1, (int)this.calValidator.compareDates(value, cal20050824));
        CalendarValidatorTest.assertEquals((String)"date EQ", (int)0, (int)this.calValidator.compareDates(value, diffHour));
        CalendarValidatorTest.assertEquals((String)"date(B)", (int)0, (int)this.calValidator.compare(value, diffHour, 6));
        CalendarValidatorTest.assertEquals((String)"date GT", (int)1, (int)this.calValidator.compareDates(value, cal20050822));
        CalendarValidatorTest.assertEquals((String)"week LT", (int)-1, (int)this.calValidator.compareWeeks(value, cal20050830));
        CalendarValidatorTest.assertEquals((String)"week =1", (int)0, (int)this.calValidator.compareWeeks(value, cal20050824));
        CalendarValidatorTest.assertEquals((String)"week =2", (int)0, (int)this.calValidator.compareWeeks(value, cal20050822));
        CalendarValidatorTest.assertEquals((String)"week =3", (int)0, (int)this.calValidator.compare(value, cal20050822, 4));
        CalendarValidatorTest.assertEquals((String)"week =4", (int)0, (int)this.calValidator.compareWeeks(value, cal20050822));
        CalendarValidatorTest.assertEquals((String)"week GT", (int)1, (int)this.calValidator.compareWeeks(value, cal20050816));
        CalendarValidatorTest.assertEquals((String)"mnth LT", (int)-1, (int)this.calValidator.compareMonths(value, cal20050901));
        CalendarValidatorTest.assertEquals((String)"mnth =1", (int)0, (int)this.calValidator.compareMonths(value, cal20050830));
        CalendarValidatorTest.assertEquals((String)"mnth =2", (int)0, (int)this.calValidator.compareMonths(value, cal20050801));
        CalendarValidatorTest.assertEquals((String)"mnth =3", (int)0, (int)this.calValidator.compareMonths(value, cal20050816));
        CalendarValidatorTest.assertEquals((String)"mnth GT", (int)1, (int)this.calValidator.compareMonths(value, cal20050731));
        CalendarValidatorTest.assertEquals((String)"qtrA <1", (int)-1, (int)this.calValidator.compareQuarters(value, cal20051101));
        CalendarValidatorTest.assertEquals((String)"qtrA <2", (int)-1, (int)this.calValidator.compareQuarters(value, cal20051001));
        CalendarValidatorTest.assertEquals((String)"qtrA =1", (int)0, (int)this.calValidator.compareQuarters(value, cal20050901));
        CalendarValidatorTest.assertEquals((String)"qtrA =2", (int)0, (int)this.calValidator.compareQuarters(value, cal20050701));
        CalendarValidatorTest.assertEquals((String)"qtrA =3", (int)0, (int)this.calValidator.compareQuarters(value, cal20050731));
        CalendarValidatorTest.assertEquals((String)"qtrA GT", (int)1, (int)this.calValidator.compareQuarters(value, cal20050630));
        CalendarValidatorTest.assertEquals((String)"qtrB LT", (int)-1, (int)this.calValidator.compareQuarters(value, cal20051101, 2));
        CalendarValidatorTest.assertEquals((String)"qtrB =1", (int)0, (int)this.calValidator.compareQuarters(value, cal20051001, 2));
        CalendarValidatorTest.assertEquals((String)"qtrB =2", (int)0, (int)this.calValidator.compareQuarters(value, cal20050901, 2));
        CalendarValidatorTest.assertEquals((String)"qtrB =3", (int)1, (int)this.calValidator.compareQuarters(value, cal20050701, 2));
        CalendarValidatorTest.assertEquals((String)"qtrB =4", (int)1, (int)this.calValidator.compareQuarters(value, cal20050731, 2));
        CalendarValidatorTest.assertEquals((String)"qtrB GT", (int)1, (int)this.calValidator.compareQuarters(value, cal20050630, 2));
        CalendarValidatorTest.assertEquals((String)"year LT", (int)-1, (int)this.calValidator.compareYears(value, cal20060101));
        CalendarValidatorTest.assertEquals((String)"year EQ", (int)0, (int)this.calValidator.compareYears(value, cal20050101));
        CalendarValidatorTest.assertEquals((String)"year GT", (int)1, (int)this.calValidator.compareYears(value, cal20041231));
        try {
            this.calValidator.compare(value, value, -1);
            CalendarValidatorTest.fail((String)"Invalid Compare field - expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException e) {
            CalendarValidatorTest.assertEquals((String)"check message", (String)"Invalid field: -1", (String)e.getMessage());
        }
    }

    public void testDateTimeStyle() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        AbstractCalendarValidator dateTimeValidator = new AbstractCalendarValidator(true, 3, 3){
            private static final long serialVersionUID = 1L;

            protected Object processParsedValue(Object value, Format formatter) {
                return value;
            }
        };
        CalendarValidatorTest.assertTrue((String)"validate(A) default", (boolean)dateTimeValidator.isValid("31/12/05 14:23"));
        CalendarValidatorTest.assertTrue((String)"validate(A) locale ", (boolean)dateTimeValidator.isValid("12/31/05 2:23 PM", Locale.US));
        Locale.setDefault(origDefault);
    }

    @Override
    public void testFormat() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        Calendar cal20050101 = CalendarValidatorTest.createCalendar(GMT, 20051231, 11500);
        CalendarValidatorTest.assertNull((String)"null", (Object)this.calValidator.format(null));
        CalendarValidatorTest.assertEquals((String)"default", (String)"31/12/05", (String)this.calValidator.format((Object)cal20050101));
        CalendarValidatorTest.assertEquals((String)"locale", (String)"12/31/05", (String)this.calValidator.format((Object)cal20050101, Locale.US));
        CalendarValidatorTest.assertEquals((String)"patternA", (String)"2005-12-31 01:15", (String)this.calValidator.format((Object)cal20050101, "yyyy-MM-dd HH:mm"));
        CalendarValidatorTest.assertEquals((String)"patternB", (String)"2005-12-31 GMT", (String)this.calValidator.format((Object)cal20050101, "yyyy-MM-dd z"));
        CalendarValidatorTest.assertEquals((String)"both", (String)"31 Dez 2005", (String)this.calValidator.format((Object)cal20050101, "dd MMM yyyy", Locale.GERMAN));
        CalendarValidatorTest.assertEquals((String)"EST default", (String)"30/12/05", (String)this.calValidator.format((Object)cal20050101, EST));
        CalendarValidatorTest.assertEquals((String)"EST locale", (String)"12/30/05", (String)this.calValidator.format((Object)cal20050101, Locale.US, EST));
        CalendarValidatorTest.assertEquals((String)"EST patternA", (String)"2005-12-30 20:15", (String)this.calValidator.format((Object)cal20050101, "yyyy-MM-dd HH:mm", EST));
        CalendarValidatorTest.assertEquals((String)"EST patternB", (String)"2005-12-30 EST", (String)this.calValidator.format((Object)cal20050101, "yyyy-MM-dd z", EST));
        CalendarValidatorTest.assertEquals((String)"EST both", (String)"30 Dez 2005", (String)this.calValidator.format((Object)cal20050101, "dd MMM yyyy", Locale.GERMAN, EST));
        Locale.setDefault(origDefault);
    }

    public void testAdjustToTimeZone() {
        Calendar calEST = CalendarValidatorTest.createCalendar(EST, 20051123, 120345);
        Date dateEST = calEST.getTime();
        Calendar calGMT = CalendarValidatorTest.createCalendar(GMT, 20051123, 120345);
        Date dateGMT = calGMT.getTime();
        Calendar calCET = CalendarValidatorTest.createCalendar(EET, 20051123, 120345);
        Date dateCET = calCET.getTime();
        CalendarValidatorTest.assertFalse((String)"Check GMT != CET", (dateGMT.getTime() == dateCET.getTime() ? 1 : 0) != 0);
        CalendarValidatorTest.assertFalse((String)"Check GMT != EST", (dateGMT.getTime() == dateEST.getTime() ? 1 : 0) != 0);
        CalendarValidatorTest.assertFalse((String)"Check CET != EST", (dateCET.getTime() == dateEST.getTime() ? 1 : 0) != 0);
        CalendarValidator.adjustToTimeZone((Calendar)calEST, (TimeZone)GMT);
        CalendarValidatorTest.assertEquals((String)"EST to GMT", (Object)dateGMT, (Object)calEST.getTime());
        CalendarValidatorTest.assertFalse((String)"Check EST = GMT", (dateEST == calEST.getTime() ? 1 : 0) != 0);
        CalendarValidator.adjustToTimeZone((Calendar)calEST, (TimeZone)EST);
        CalendarValidatorTest.assertEquals((String)"back to EST", (Object)dateEST, (Object)calEST.getTime());
        CalendarValidatorTest.assertFalse((String)"Check EST != GMT", (dateGMT == calEST.getTime() ? 1 : 0) != 0);
        CalendarValidator.adjustToTimeZone((Calendar)calCET, (TimeZone)GMT);
        CalendarValidatorTest.assertEquals((String)"CET to GMT", (Object)dateGMT, (Object)calCET.getTime());
        CalendarValidatorTest.assertFalse((String)"Check CET = GMT", (dateCET == calCET.getTime() ? 1 : 0) != 0);
        CalendarValidator.adjustToTimeZone((Calendar)calCET, (TimeZone)EET);
        CalendarValidatorTest.assertEquals((String)"back to CET", (Object)dateCET, (Object)calCET.getTime());
        CalendarValidatorTest.assertFalse((String)"Check CET != GMT", (dateGMT == calCET.getTime() ? 1 : 0) != 0);
        Calendar calUTC = CalendarValidatorTest.createCalendar(UTC, 20051123, 120345);
        CalendarValidatorTest.assertTrue((String)"SAME: UTC = GMT", (boolean)UTC.hasSameRules(GMT));
        CalendarValidatorTest.assertEquals((String)"SAME: Check time (A)", (Object)calUTC.getTime(), (Object)calGMT.getTime());
        CalendarValidatorTest.assertFalse((String)"SAME: Check GMT(A)", (boolean)GMT.equals(calUTC.getTimeZone()));
        CalendarValidatorTest.assertTrue((String)"SAME: Check UTC(A)", (boolean)UTC.equals(calUTC.getTimeZone()));
        CalendarValidator.adjustToTimeZone((Calendar)calUTC, (TimeZone)GMT);
        CalendarValidatorTest.assertEquals((String)"SAME: Check time (B)", (Object)calUTC.getTime(), (Object)calGMT.getTime());
        CalendarValidatorTest.assertTrue((String)"SAME: Check GMT(B)", (boolean)GMT.equals(calUTC.getTimeZone()));
        CalendarValidatorTest.assertFalse((String)"SAME: Check UTC(B)", (boolean)UTC.equals(calUTC.getTimeZone()));
    }
}

