/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.ShortValidator;

public class ShortValidatorTest
extends AbstractNumberValidatorTest {
    public ShortValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new ShortValidator(false, 0);
        this.strictValidator = new ShortValidator();
        this.testPattern = "#,###";
        this.max = (short)Short.MAX_VALUE;
        this.maxPlusOne = this.max.longValue() + 1L;
        this.min = (short)Short.MIN_VALUE;
        this.minMinusOne = this.min.longValue() - 1L;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = (short)1234;
        this.testZero = (short)0;
        this.validStrict = new String[]{"0", "1234", "1,234"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234", "1,234", "1,234.5", "1234X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234";
        this.localeValue = this.testStringDE = "1.234";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    public void testShortValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        Short expected = 12345;
        ShortValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)ShortValidator.getInstance().validate(defaultVal));
        ShortValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)ShortValidator.getInstance().validate(localeVal, locale));
        ShortValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)ShortValidator.getInstance().validate(patternVal, pattern));
        ShortValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)ShortValidator.getInstance().validate(germanPatternVal, pattern, Locale.GERMAN));
        ShortValidatorTest.assertTrue((String)"isValid(A) default", (boolean)ShortValidator.getInstance().isValid(defaultVal));
        ShortValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)ShortValidator.getInstance().isValid(localeVal, locale));
        ShortValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)ShortValidator.getInstance().isValid(patternVal, pattern));
        ShortValidatorTest.assertTrue((String)"isValid(A) both", (boolean)ShortValidator.getInstance().isValid(germanPatternVal, pattern, Locale.GERMAN));
        ShortValidatorTest.assertNull((String)"validate(B) default", (Object)ShortValidator.getInstance().validate(XXXX));
        ShortValidatorTest.assertNull((String)"validate(B) locale ", (Object)ShortValidator.getInstance().validate(XXXX, locale));
        ShortValidatorTest.assertNull((String)"validate(B) pattern", (Object)ShortValidator.getInstance().validate(XXXX, pattern));
        ShortValidatorTest.assertNull((String)"validate(B) both", (Object)ShortValidator.getInstance().validate(patternVal, pattern, Locale.GERMAN));
        ShortValidatorTest.assertFalse((String)"isValid(B) default", (boolean)ShortValidator.getInstance().isValid(XXXX));
        ShortValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)ShortValidator.getInstance().isValid(XXXX, locale));
        ShortValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)ShortValidator.getInstance().isValid(XXXX, pattern));
        ShortValidatorTest.assertFalse((String)"isValid(B) both", (boolean)ShortValidator.getInstance().isValid(patternVal, pattern, Locale.GERMAN));
    }

    public void testShortRangeMinMax() {
        ShortValidator validator = (ShortValidator)this.strictValidator;
        Short number9 = validator.validate("9", "#");
        Short number10 = validator.validate("10", "#");
        Short number11 = validator.validate("11", "#");
        Short number19 = validator.validate("19", "#");
        Short number20 = validator.validate("20", "#");
        Short number21 = validator.validate("21", "#");
        short min = 10;
        short max = 20;
        ShortValidatorTest.assertFalse((String)"isInRange() < min", (boolean)validator.isInRange(number9, min, max));
        ShortValidatorTest.assertTrue((String)"isInRange() = min", (boolean)validator.isInRange(number10, min, max));
        ShortValidatorTest.assertTrue((String)"isInRange() in range", (boolean)validator.isInRange(number11, min, max));
        ShortValidatorTest.assertTrue((String)"isInRange() = max", (boolean)validator.isInRange(number20, min, max));
        ShortValidatorTest.assertFalse((String)"isInRange() > max", (boolean)validator.isInRange(number21, min, max));
        ShortValidatorTest.assertFalse((String)"minValue() < min", (boolean)validator.minValue(number9, min));
        ShortValidatorTest.assertTrue((String)"minValue() = min", (boolean)validator.minValue(number10, min));
        ShortValidatorTest.assertTrue((String)"minValue() > min", (boolean)validator.minValue(number11, min));
        ShortValidatorTest.assertTrue((String)"maxValue() < max", (boolean)validator.maxValue(number19, max));
        ShortValidatorTest.assertTrue((String)"maxValue() = max", (boolean)validator.maxValue(number20, max));
        ShortValidatorTest.assertFalse((String)"maxValue() > max", (boolean)validator.maxValue(number21, max));
    }
}

