/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.ValueBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

public class DateTest
extends AbstractCommonTest {
    protected String FORM_KEY = "dateForm";
    protected String ACTION = "date";

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("DateTest-config.xml");
    }

    @Test
    public void testInvalidDate() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("12/01as/2005");
        this.valueTest(info, false);
    }

    @Test
    public void testValidDate() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("12/01/2005");
        this.valueTest(info, true);
    }

    protected void valueTest(Object info, boolean passed) throws ValidatorException {
        Validator validator = new Validator(this.resources, this.FORM_KEY);
        validator.setParameter("java.lang.Object", info);
        validator.setParameter("java.util.Locale", (Object)Locale.US);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult result = results.getValidatorResult("value");
        Assertions.assertNotNull((Object)result, () -> this.ACTION + " value ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)result.containsAction(this.ACTION), () -> this.ACTION + " value ValidatorResult should contain the '" + this.ACTION + "' action.");
        Assertions.assertTrue((boolean)(passed ? result.isValid(this.ACTION) : !result.isValid(this.ACTION)), () -> this.ACTION + " value ValidatorResult for the '" + this.ACTION + "' action should have " + (passed ? "passed" : "failed") + ".");
    }
}

