/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.ResultPair;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.ValueBean;
import org.apache.commons.validator.routines.EmailValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

@Deprecated
public class EmailTest
extends AbstractCommonTest {
    protected static String FORM_KEY = "emailForm";
    protected static String ACTION = "email";
    ResultPair[] testEmailFromPerl = new ResultPair[]{new ResultPair("abigail@example.com", true), new ResultPair("abigail@example.com ", true), new ResultPair(" abigail@example.com", true), new ResultPair("abigail @example.com ", true), new ResultPair("*@example.net", true), new ResultPair("\"\\\"\"@foo.bar", true), new ResultPair("fred&barny@example.com", true), new ResultPair("---@example.com", true), new ResultPair("foo-bar@example.net", true), new ResultPair("\"127.0.0.1\"@[127.0.0.1]", true), new ResultPair("Abigail <abigail@example.com>", true), new ResultPair("Abigail<abigail@example.com>", true), new ResultPair("Abigail<@a,@b,@c:abigail@example.com>", true), new ResultPair("\"This is a phrase\"<abigail@example.com>", true), new ResultPair("\"Abigail \"<abigail@example.com>", true), new ResultPair("\"Joe & J. Harvey\" <example @Org>", true), new ResultPair("Abigail <abigail @ example.com>", true), new ResultPair("Abigail made this <  abigail   @   example  .    com    >", true), new ResultPair("Abigail(the bitch)@example.com", true), new ResultPair("Abigail <abigail @ example . (bar) com >", true), new ResultPair("Abigail < (one)  abigail (two) @(three)example . (bar) com (quz) >", true), new ResultPair("Abigail (foo) (((baz)(nested) (comment)) ! ) < (one)  abigail (two) @(three)example . (bar) com (quz) >", true), new ResultPair("Abigail <abigail(fo\\(o)@example.com>", true), new ResultPair("Abigail <abigail(fo\\)o)@example.com> ", true), new ResultPair("(foo) abigail@example.com", true), new ResultPair("abigail@example.com (foo)", true), new ResultPair("\"Abi\\\"gail\" <abigail@example.com>", true), new ResultPair("abigail@[example.com]", true), new ResultPair("abigail@[exa\\[ple.com]", true), new ResultPair("abigail@[exa\\]ple.com]", true), new ResultPair("\":sysmail\"@  Some-Group. Some-Org", true), new ResultPair("Muhammed.(I am  the greatest) Ali @(the)Vegas.WBA", true), new ResultPair("mailbox.sub1.sub2@this-domain", true), new ResultPair("sub-net.mailbox@sub-domain.domain", true), new ResultPair("name:;", true), new ResultPair("':;", true), new ResultPair("name:   ;", true), new ResultPair("Alfred Neuman <Neuman@BBN-TENEXA>", true), new ResultPair("Neuman@BBN-TENEXA", true), new ResultPair("\"George, Ted\" <Shared@Group.Arpanet>", true), new ResultPair("Wilt . (the  Stilt) Chamberlain@NBA.US", true), new ResultPair("Cruisers:  Port@Portugal, Jones@SEA;", true), new ResultPair("$@[]", true), new ResultPair("*()@[]", true), new ResultPair("\"quoted ( brackets\" ( a comment )@example.com", true), new ResultPair("\"Joe & J. Harvey\"\\x0D\\x0A     <ddd\\@ Org>", true), new ResultPair("\"Joe &\\x0D\\x0A J. Harvey\" <ddd \\@ Org>", true), new ResultPair("Gourmets:  Pompous Person <WhoZiWhatZit\\@Cordon-Bleu>,\\x0D\\x0A        Childs\\@WGBH.Boston, \"Galloping Gourmet\"\\@\\x0D\\x0A        ANT.Down-Under (Australian National Television),\\x0D\\x0A        Cheapie\\@Discount-Liquors;", true), new ResultPair("   Just a string", false), new ResultPair("string", false), new ResultPair("(comment)", false), new ResultPair("()@example.com", false), new ResultPair("fred(&)barny@example.com", false), new ResultPair("fred\\ barny@example.com", false), new ResultPair("Abigail <abi gail @ example.com>", false), new ResultPair("Abigail <abigail(fo(o)@example.com>", false), new ResultPair("Abigail <abigail(fo)o)@example.com>", false), new ResultPair("\"Abi\"gail\" <abigail@example.com>", false), new ResultPair("abigail@[exa]ple.com]", false), new ResultPair("abigail@[exa[ple.com]", false), new ResultPair("abigail@[exaple].com]", false), new ResultPair("abigail@", false), new ResultPair("@example.com", false), new ResultPair("phrase: abigail@example.com abigail@example.com ;", false), new ResultPair("invalid\ufffdchar@example.com", false)};

    public void _testEmailFromPerl() throws ValidatorException {
        ValueBean info = new ValueBean();
        for (ResultPair element : this.testEmailFromPerl) {
            info.setValue(element.item);
            this.valueTest(info, element.valid);
        }
    }

    public void _testEmailUserName() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("joe1blow@apache.org");
        this.valueTest(info, true);
        info.setValue("joe$blow@apache.org");
        this.valueTest(info, true);
        info.setValue("joe-@apache.org");
        this.valueTest(info, true);
        info.setValue("joe_@apache.org");
        this.valueTest(info, true);
        info.setValue("joe.@apache.org");
        this.valueTest(info, false);
        info.setValue("joe+@apache.org");
        this.valueTest(info, false);
        info.setValue("joe!@apache.org");
        this.valueTest(info, false);
        info.setValue("joe*@apache.org");
        this.valueTest(info, false);
        info.setValue("joe'@apache.org");
        this.valueTest(info, false);
        info.setValue("joe(@apache.org");
        this.valueTest(info, false);
        info.setValue("joe)@apache.org");
        this.valueTest(info, false);
        info.setValue("joe,@apache.org");
        this.valueTest(info, false);
        info.setValue("joe%45@apache.org");
        this.valueTest(info, false);
        info.setValue("joe;@apache.org");
        this.valueTest(info, false);
        info.setValue("joe?@apache.org");
        this.valueTest(info, false);
        info.setValue("joe&@apache.org");
        this.valueTest(info, false);
        info.setValue("joe=@apache.org");
        this.valueTest(info, false);
        info.setValue("\"joe.\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe+\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe!\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe*\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe'\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe(\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe)\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe,\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe%45\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe;\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe?\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe&\"@apache.org");
        this.valueTest(info, true);
        info.setValue("\"joe=\"@apache.org");
        this.valueTest(info, true);
    }

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("EmailTest-config.xml");
    }

    @Test
    public void testEmail() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("jsmith@apache.org");
        this.valueTest(info, true);
    }

    @Test
    public void testEmailAtTLD() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("m@de");
        this.valueTest(info, false);
        EmailValidator validator = EmailValidator.getInstance((boolean)true, (boolean)true);
        boolean result = validator.isValid("m@de");
        Assertions.assertTrue((boolean)result, (String)"Result should have been true");
    }

    @Test
    public void testEmailExtension() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("jsmith@apache.org");
        this.valueTest(info, true);
        info.setValue("jsmith@apache.com");
        this.valueTest(info, true);
        info.setValue("jsmith@apache.net");
        this.valueTest(info, true);
        info.setValue("jsmith@apache.info");
        this.valueTest(info, true);
        info.setValue("jsmith@apache.");
        this.valueTest(info, false);
        info.setValue("jsmith@apache.c");
        this.valueTest(info, false);
        info.setValue("someone@yahoo.museum");
        this.valueTest(info, true);
        info.setValue("someone@yahoo.mu-seum");
        this.valueTest(info, false);
    }

    @Test
    public void testEmailLocalhost() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("joe@localhost");
        this.valueTest(info, false);
        info.setValue("joe@localhost.localdomain");
        this.valueTest(info, false);
    }

    @Test
    public void testEmailWithBogusCharacter() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("andy.noble@\u008fdata-workshop.com");
        this.valueTest(info, false);
        info.setValue("andy.o'reilly@data-workshop.com");
        this.valueTest(info, true);
        info.setValue("andy@o'reilly.data-workshop.com");
        this.valueTest(info, false);
        info.setValue("foo+bar@i.am.not.in.us.example.com");
        this.valueTest(info, true);
    }

    @Test
    public void testEmailWithCommas() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("joeblow@apa,che.org");
        this.valueTest(info, false);
        info.setValue("joeblow@apache.o,rg");
        this.valueTest(info, false);
        info.setValue("joeblow@apache,org");
        this.valueTest(info, false);
    }

    @Test
    public void testEmailWithControlChars() {
        org.apache.commons.validator.EmailValidator validator = new org.apache.commons.validator.EmailValidator();
        for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            Assertions.assertFalse((boolean)validator.isValid("foo" + c + "bar@domain.com"), (String)("Test control char " + c));
        }
        Assertions.assertFalse((boolean)validator.isValid("foo\u007fbar@domain.com"), (String)"Test control char 127");
    }

    @Test
    public void testEmailWithDash() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("andy.noble@data-workshop.com");
        this.valueTest(info, true);
        info.setValue("andy-noble@data-workshop.-com");
        this.valueTest(info, false);
        info.setValue("andy-noble@data-workshop.c-om");
        this.valueTest(info, false);
        info.setValue("andy-noble@data-workshop.co-m");
        this.valueTest(info, false);
    }

    @Test
    public void testEmailWithDotEnd() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("andy.noble@data-workshop.com.");
        this.valueTest(info, false);
    }

    @Test
    public void testEmailWithNumericAddress() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("someone@[216.109.118.76]");
        this.valueTest(info, true);
        info.setValue("someone@yahoo.com");
        this.valueTest(info, true);
    }

    @Test
    public void testEmailWithSpaces() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("joeblow @apache.org");
        this.valueTest(info, false);
        info.setValue("joeblow@ apache.org");
        this.valueTest(info, false);
        info.setValue(" joeblow@apache.org");
        this.valueTest(info, false);
        info.setValue("joeblow@apache.org ");
        this.valueTest(info, false);
        info.setValue("joe blow@apache.org ");
        this.valueTest(info, false);
        info.setValue("joeblow@apa che.org ");
        this.valueTest(info, false);
        info.setValue("\"joe blow\"@apache.org");
        this.valueTest(info, true);
    }

    private void valueTest(ValueBean info, boolean passed) throws ValidatorException {
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult result = results.getValidatorResult("value");
        Assertions.assertNotNull((Object)result, () -> ACTION + " value ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)result.containsAction(ACTION), () -> "Value " + info.getValue() + " ValidatorResult should contain the '" + ACTION + "' action.");
        Assertions.assertTrue((boolean)(passed ? result.isValid(ACTION) : !result.isValid(ACTION)), () -> "Value " + info.getValue() + "ValidatorResult for the '" + ACTION + "' action should have " + (passed ? "passed" : "failed") + ".");
    }
}

