/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.validator.routines.AbstractCalendarValidatorTest;
import org.apache.commons.validator.routines.DateValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DateValidatorTest
extends AbstractCalendarValidatorTest {
    private DateValidator dateValidator;

    @BeforeEach
    protected void setUp() {
        this.dateValidator = new DateValidator();
        this.validator = this.dateValidator;
    }

    @Test
    public void testCompare() {
        int sameTime = 124522;
        int testDate = 20050823;
        Date diffHour = DateValidatorTest.createDate(GMT, 20050823, 115922);
        Date value = DateValidatorTest.createDate(GMT, 20050823, 124522);
        Date date20050824 = DateValidatorTest.createDate(GMT, 20050824, 124522);
        Date date20050822 = DateValidatorTest.createDate(GMT, 20050822, 124522);
        Date date20050830 = DateValidatorTest.createDate(GMT, 20050830, 124522);
        Date date20050816 = DateValidatorTest.createDate(GMT, 20050816, 124522);
        Date date20050901 = DateValidatorTest.createDate(GMT, 20050901, 124522);
        Date date20050801 = DateValidatorTest.createDate(GMT, 20050801, 124522);
        Date date20050731 = DateValidatorTest.createDate(GMT, 20050731, 124522);
        Date date20051101 = DateValidatorTest.createDate(GMT, 20051101, 124522);
        Date date20051001 = DateValidatorTest.createDate(GMT, 20051001, 124522);
        Date date20050701 = DateValidatorTest.createDate(GMT, 20050701, 124522);
        Date date20050630 = DateValidatorTest.createDate(GMT, 20050630, 124522);
        Date date20050110 = DateValidatorTest.createDate(GMT, 20050110, 124522);
        Date date20060101 = DateValidatorTest.createDate(GMT, 20060101, 124522);
        Date date20050101 = DateValidatorTest.createDate(GMT, 20050101, 124522);
        Date date20041231 = DateValidatorTest.createDate(GMT, 20041231, 124522);
        Assertions.assertEquals((int)-1, (int)this.dateValidator.compareDates(value, date20050824, GMT), (String)"date LT");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareDates(value, diffHour, GMT), (String)"date EQ");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareDates(value, date20050822, GMT), (String)"date GT");
        Assertions.assertEquals((int)-1, (int)this.dateValidator.compareWeeks(value, date20050830, GMT), (String)"week LT");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareWeeks(value, date20050824, GMT), (String)"week =1");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareWeeks(value, date20050822, GMT), (String)"week =2");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareWeeks(value, date20050822, GMT), (String)"week =3");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareWeeks(value, date20050816, GMT), (String)"week GT");
        Assertions.assertEquals((int)-1, (int)this.dateValidator.compareMonths(value, date20050901, GMT), (String)"mnth LT");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareMonths(value, date20050830, GMT), (String)"mnth =1");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareMonths(value, date20050801, GMT), (String)"mnth =2");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareMonths(value, date20050816, GMT), (String)"mnth =3");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareMonths(value, date20050731, GMT), (String)"mnth GT");
        Assertions.assertEquals((int)-1, (int)this.dateValidator.compareQuarters(value, date20051101, GMT), (String)"qtrA <1");
        Assertions.assertEquals((int)-1, (int)this.dateValidator.compareQuarters(value, date20051001, GMT), (String)"qtrA <2");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareQuarters(value, date20050901, GMT), (String)"qtrA =1");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareQuarters(value, date20050701, GMT), (String)"qtrA =2");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareQuarters(value, date20050731, GMT), (String)"qtrA =3");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareQuarters(value, date20050630, GMT), (String)"qtrA GT");
        Assertions.assertEquals((int)-1, (int)this.dateValidator.compareQuarters(value, date20051101, GMT, 2), (String)"qtrB LT");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareQuarters(value, date20051001, GMT, 2), (String)"qtrB =1");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareQuarters(value, date20050901, GMT, 2), (String)"qtrB =2");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareQuarters(value, date20050701, GMT, 2), (String)"qtrB =3");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareQuarters(value, date20050731, GMT, 2), (String)"qtrB =4");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareQuarters(value, date20050630, GMT, 2), (String)"qtrB GT");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareQuarters(value, date20050110, GMT, 2), (String)"qtrB prev");
        Assertions.assertEquals((int)-1, (int)this.dateValidator.compareYears(value, date20060101, GMT), (String)"year LT");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareYears(value, date20050101, GMT), (String)"year EQ");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareYears(value, date20041231, GMT), (String)"year GT");
        Date sameDayTwoAm = DateValidatorTest.createDate(GMT, 20050823, 20000);
        Assertions.assertEquals((int)-1, (int)this.dateValidator.compareDates(value, date20050824, EST), (String)"date LT");
        Assertions.assertEquals((int)0, (int)this.dateValidator.compareDates(value, diffHour, EST), (String)"date EQ");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareDates(value, sameDayTwoAm, EST), (String)"date EQ");
        Assertions.assertEquals((int)1, (int)this.dateValidator.compareDates(value, date20050822, EST), (String)"date GT");
    }

    @Test
    public void testDateValidatorMethods() {
        Locale.setDefault(Locale.US);
        Locale locale = Locale.GERMAN;
        String pattern = "yyyy-MM-dd";
        String patternVal = "2005-12-31";
        String germanVal = "31 Dez 2005";
        String germanPattern = "dd MMM yyyy";
        String localeVal = "31.12.2005";
        String defaultVal = "12/31/05";
        String XXXX = "XXXX";
        Date expected = DateValidatorTest.createCalendar(null, 20051231, 0).getTime();
        Assertions.assertEquals((Object)expected, (Object)DateValidator.getInstance().validate("12/31/05"), (String)"validate(A) default");
        Assertions.assertEquals((Object)expected, (Object)DateValidator.getInstance().validate("31.12.2005", locale), (String)"validate(A) locale ");
        Assertions.assertEquals((Object)expected, (Object)DateValidator.getInstance().validate("2005-12-31", "yyyy-MM-dd"), (String)"validate(A) pattern");
        Assertions.assertEquals((Object)expected, (Object)DateValidator.getInstance().validate("31 Dez 2005", "dd MMM yyyy", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)DateValidator.getInstance().isValid("12/31/05"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)DateValidator.getInstance().isValid("31.12.2005", locale), (String)"isValid(A) locale ");
        Assertions.assertTrue((boolean)DateValidator.getInstance().isValid("2005-12-31", "yyyy-MM-dd"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)DateValidator.getInstance().isValid("31 Dez 2005", "dd MMM yyyy", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)DateValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)DateValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale ");
        Assertions.assertNull((Object)DateValidator.getInstance().validate("XXXX", "yyyy-MM-dd"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)DateValidator.getInstance().validate("31 Dec 2005", "dd MMM yyyy", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)DateValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)DateValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale ");
        Assertions.assertFalse((boolean)DateValidator.getInstance().isValid("XXXX", "yyyy-MM-dd"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)DateValidator.getInstance().isValid("31 Dec 2005", "dd MMM yyyy", Locale.GERMAN), (String)"isValid(B) both");
        TimeZone zone = TimeZone.getDefault().getRawOffset() == EET.getRawOffset() ? EST : EET;
        Date expectedZone = DateValidatorTest.createCalendar(zone, 20051231, 0).getTime();
        Assertions.assertFalse((expected.getTime() == expectedZone.getTime() ? 1 : 0) != 0, (String)("default/zone same " + zone));
        Assertions.assertEquals((Object)expectedZone, (Object)DateValidator.getInstance().validate("12/31/05", zone), (String)"validate(C) default");
        Assertions.assertEquals((Object)expectedZone, (Object)DateValidator.getInstance().validate("31.12.2005", locale, zone), (String)"validate(C) locale ");
        Assertions.assertEquals((Object)expectedZone, (Object)DateValidator.getInstance().validate("2005-12-31", "yyyy-MM-dd", zone), (String)"validate(C) pattern");
        Assertions.assertEquals((Object)expectedZone, (Object)DateValidator.getInstance().validate("31 Dez 2005", "dd MMM yyyy", Locale.GERMAN, zone), (String)"validate(C) both");
    }

    @Test
    public void testLocaleProviders() throws Exception {
        String localeProviders = System.getProperty("java.locale.providers");
        if (localeProviders != null) {
            Assertions.assertTrue((boolean)localeProviders.startsWith("COMPAT"), (String)"java.locale.providers must start with COMPAT");
        }
        String txt = "3/20/15 10:59:00 PM";
        DateFormat dateformat = DateFormat.getDateTimeInstance(3, 2, Locale.US);
        dateformat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = dateformat.parse("3/20/15 10:59:00 PM");
        Assertions.assertNotNull((Object)date);
    }
}

