/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.validator.ResultPair;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlValidatorTest {
    private final boolean printStatus = false;
    private final boolean printIndex = false;
    ResultPair[] testUrlScheme = new ResultPair[]{new ResultPair("http://", true), new ResultPair("ftp://", true), new ResultPair("h3t://", true), new ResultPair("3ht://", false), new ResultPair("http:/", false), new ResultPair("http:", false), new ResultPair("http/", false), new ResultPair("://", false)};
    ResultPair[] testUrlAuthority = new ResultPair[]{new ResultPair("www.google.com", true), new ResultPair("www.google.com.", true), new ResultPair("go.com", true), new ResultPair("go.au", true), new ResultPair("0.0.0.0", true), new ResultPair("255.255.255.255", true), new ResultPair("256.256.256.256", false), new ResultPair("255.com", true), new ResultPair("1.2.3.4.5", false), new ResultPair("1.2.3.4.", false), new ResultPair("1.2.3", false), new ResultPair(".1.2.3.4", false), new ResultPair("go.a", false), new ResultPair("go.a1a", false), new ResultPair("go.cc", true), new ResultPair("go.1aa", false), new ResultPair("aaa.", false), new ResultPair(".aaa", false), new ResultPair("aaa", false), new ResultPair("", false)};
    ResultPair[] testUrlPort = new ResultPair[]{new ResultPair(":80", true), new ResultPair(":65535", true), new ResultPair(":65536", false), new ResultPair(":0", true), new ResultPair("", true), new ResultPair(":-1", false), new ResultPair(":65636", false), new ResultPair(":999999999999999999", false), new ResultPair(":65a", false)};
    ResultPair[] testPath = new ResultPair[]{new ResultPair("/test1", true), new ResultPair("/t123", true), new ResultPair("/$23", true), new ResultPair("/..", false), new ResultPair("/../", false), new ResultPair("/test1/", true), new ResultPair("", true), new ResultPair("/test1/file", true), new ResultPair("/..//file", false), new ResultPair("/test1//file", false)};
    ResultPair[] testUrlPathOptions = new ResultPair[]{new ResultPair("/test1", true), new ResultPair("/t123", true), new ResultPair("/$23", true), new ResultPair("/..", false), new ResultPair("/../", false), new ResultPair("/test1/", true), new ResultPair("/#", false), new ResultPair("", true), new ResultPair("/test1/file", true), new ResultPair("/t123/file", true), new ResultPair("/$23/file", true), new ResultPair("/../file", false), new ResultPair("/..//file", false), new ResultPair("/test1//file", true), new ResultPair("/#/file", false)};
    ResultPair[] testUrlQuery = new ResultPair[]{new ResultPair("?action=view", true), new ResultPair("?action=edit&mode=up", true), new ResultPair("", true)};
    Object[] testUrlParts = new Object[]{this.testUrlScheme, this.testUrlAuthority, this.testUrlPort, this.testPath, this.testUrlQuery};
    Object[] testUrlPartsOptions = new Object[]{this.testUrlScheme, this.testUrlAuthority, this.testUrlPort, this.testUrlPathOptions, this.testUrlQuery};
    int[] testPartsIndex = new int[]{0, 0, 0, 0, 0};
    private final String[] schemes = new String[]{"http", "gopher", "g0-To+.", "not_valid"};
    ResultPair[] testScheme = new ResultPair[]{new ResultPair("http", true), new ResultPair("ftp", false), new ResultPair("httpd", false), new ResultPair("gopher", true), new ResultPair("g0-to+.", true), new ResultPair("not_valid", false), new ResultPair("HtTp", true), new ResultPair("telnet", false)};

    static boolean incrementTestPartsIndex(int[] testPartsIndex, Object[] testParts) {
        boolean carry = true;
        boolean maxIndex = true;
        for (int testPartsIndexIndex = testPartsIndex.length - 1; testPartsIndexIndex >= 0; --testPartsIndexIndex) {
            int index = testPartsIndex[testPartsIndexIndex];
            ResultPair[] part = (ResultPair[])testParts[testPartsIndexIndex];
            maxIndex &= index == part.length - 1;
            if (!carry) continue;
            if (index < part.length - 1) {
                testPartsIndex[testPartsIndexIndex] = ++index;
                carry = false;
                continue;
            }
            testPartsIndex[testPartsIndexIndex] = 0;
            carry = true;
        }
        return !maxIndex;
    }

    public static void main(String[] args) {
        UrlValidator uv = new UrlValidator();
        for (String arg : args) {
            try {
                URI uri = new URI(arg);
                uri = uri.normalize();
                System.out.println(uri.toString());
                System.out.printf("URI scheme: %s%n", uri.getScheme());
                System.out.printf("URI scheme specific part: %s%n", uri.getSchemeSpecificPart());
                System.out.printf("URI raw scheme specific part: %s%n", uri.getRawSchemeSpecificPart());
                System.out.printf("URI auth: %s%n", uri.getAuthority());
                System.out.printf("URI raw auth: %s%n", uri.getRawAuthority());
                System.out.printf("URI userInfo: %s%n", uri.getUserInfo());
                System.out.printf("URI raw userInfo: %s%n", uri.getRawUserInfo());
                System.out.printf("URI host: %s%n", uri.getHost());
                System.out.printf("URI port: %s%n", uri.getPort());
                System.out.printf("URI path: %s%n", uri.getPath());
                System.out.printf("URI raw path: %s%n", uri.getRawPath());
                System.out.printf("URI query: %s%n", uri.getQuery());
                System.out.printf("URI raw query: %s%n", uri.getRawQuery());
                System.out.printf("URI fragment: %s%n", uri.getFragment());
                System.out.printf("URI raw fragment: %s%n", uri.getRawFragment());
            }
            catch (URISyntaxException e) {
                System.out.println(e.getMessage());
            }
            System.out.printf("isValid: %s%n", uv.isValid(arg));
        }
    }

    @Before
    public void setUp() {
        for (int index = 0; index < this.testPartsIndex.length - 1; ++index) {
            this.testPartsIndex[index] = 0;
        }
    }

    @Test
    public void testFragments() {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, 4L);
        Assertions.assertFalse((boolean)urlValidator.isValid("http://apache.org/a/b/c#frag"));
        urlValidator = new UrlValidator(schemes);
        Assertions.assertTrue((boolean)urlValidator.isValid("http://apache.org/a/b/c#frag"));
    }

    @Test
    public void testIsValid() {
        this.testIsValid(this.testUrlParts, 1L);
        this.setUp();
        long options = 7L;
        this.testIsValid(this.testUrlPartsOptions, 7L);
    }

    public void testIsValid(Object[] testObjects, long options) {
        UrlValidator urlVal = new UrlValidator(null, null, options);
        Assertions.assertTrue((boolean)urlVal.isValid("http://www.google.com"));
        Assertions.assertTrue((boolean)urlVal.isValid("http://www.google.com/"));
        int statusPerLine = 60;
        boolean printed = false;
        do {
            StringBuilder testBuffer = new StringBuilder();
            boolean expected = true;
            for (int testPartsIndexIndex = 0; testPartsIndexIndex < this.testPartsIndex.length; ++testPartsIndexIndex) {
                int index = this.testPartsIndex[testPartsIndexIndex];
                ResultPair[] part = (ResultPair[])testObjects[testPartsIndexIndex];
                testBuffer.append(part[index].item);
                expected &= part[index].valid;
            }
            String url = testBuffer.toString();
            boolean result = urlVal.isValid(url);
            Assertions.assertEquals((Object)expected, (Object)result, (String)url);
        } while (UrlValidatorTest.incrementTestPartsIndex(this.testPartsIndex, testObjects));
    }

    @Test
    public void testIsValidScheme() {
        UrlValidator urlVal = new UrlValidator(this.schemes, 0L);
        for (ResultPair testPair : this.testScheme) {
            boolean result = urlVal.isValidScheme(testPair.item);
            Assertions.assertEquals((Object)testPair.valid, (Object)result, (String)testPair.item);
        }
    }

    private String testPartsIndextoString() {
        StringBuilder carryMsg = new StringBuilder("{");
        for (int testPartsIndexIndex = 0; testPartsIndexIndex < this.testPartsIndex.length; ++testPartsIndexIndex) {
            carryMsg.append(this.testPartsIndex[testPartsIndexIndex]);
            if (testPartsIndexIndex < this.testPartsIndex.length - 1) {
                carryMsg.append(',');
                continue;
            }
            carryMsg.append('}');
        }
        return carryMsg.toString();
    }

    @Test
    public void testValidateUrl() {
        Assertions.assertTrue((boolean)true);
    }

    @Test
    public void testValidator202() {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, 4L);
        Assertions.assertTrue((boolean)urlValidator.isValid("http://l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.org"));
    }

    @Test
    public void testValidator204() {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        Assertions.assertTrue((boolean)urlValidator.isValid("http://tech.yahoo.com/rc/desktops/102;_ylt=Ao8yevQHlZ4On0O3ZJGXLEQFLZA5"));
    }

    @Test
    public void testValidator218() {
        UrlValidator validator = new UrlValidator(2L);
        Assertions.assertTrue((boolean)validator.isValid("http://somewhere.com/pathxyz/file(1).html"), (String)"parentheses should be valid in URLs");
    }

    @Test
    public void testValidator235() {
        String version = System.getProperty("java.version");
        if (version.compareTo("1.6") < 0) {
            System.out.println("Cannot run Unicode IDN tests");
            return;
        }
        UrlValidator validator = new UrlValidator();
        Assertions.assertTrue((boolean)validator.isValid("http://xn--d1abbgf6aiiy.xn--p1ai"), (String)"xn--d1abbgf6aiiy.xn--p1ai should validate");
        Assertions.assertTrue((boolean)validator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444"), (String)"\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444 should validate");
        Assertions.assertTrue((boolean)validator.isValid("http://www.b\u00fccher.ch"), (String)"www.b\u00fccher.ch should validate");
        Assertions.assertFalse((boolean)validator.isValid("http://www.\ufffd.ch"), (String)"www.\ufffd.ch FFFD should fail");
        Assertions.assertTrue((boolean)validator.isValid("ftp://www.b\u00fccher.ch"), (String)"www.b\u00fccher.ch should validate");
        Assertions.assertFalse((boolean)validator.isValid("ftp://www.\ufffd.ch"), (String)"www.\ufffd.ch FFFD should fail");
    }

    @Test
    public void testValidator248() {
        RegexValidator regex = new RegexValidator(new String[]{"localhost", ".*\\.my-testing"});
        UrlValidator validator = new UrlValidator(regex, 0L);
        Assertions.assertTrue((boolean)validator.isValid("http://localhost/test/index.html"), (String)"localhost URL should validate");
        Assertions.assertTrue((boolean)validator.isValid("http://first.my-testing/test/index.html"), (String)"first.my-testing should validate");
        Assertions.assertTrue((boolean)validator.isValid("http://sup3r.my-testing/test/index.html"), (String)"sup3r.my-testing should validate");
        Assertions.assertFalse((boolean)validator.isValid("http://broke.my-test/test/index.html"), (String)"broke.my-test should not validate");
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org/test/index.html"), (String)"www.apache.org should still validate");
        validator = new UrlValidator(8L);
        Assertions.assertTrue((boolean)validator.isValid("http://localhost/test/index.html"), (String)"localhost URL should validate");
        Assertions.assertTrue((boolean)validator.isValid("http://machinename/test/index.html"), (String)"machinename URL should validate");
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org/test/index.html"), (String)"www.apache.org should still validate");
    }

    @Test
    public void testValidator276() {
        UrlValidator validator = new UrlValidator();
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org/test/index.html"), (String)"http://apache.org/ should be allowed by default");
        Assertions.assertFalse((boolean)validator.isValid("file:///C:/some.file"), (String)"file:///c:/ shouldn't be allowed by default");
        Assertions.assertFalse((boolean)validator.isValid("file:///C:\\some.file"), (String)"file:///c:\\ shouldn't be allowed by default");
        Assertions.assertFalse((boolean)validator.isValid("file:///etc/hosts"), (String)"file:///etc/ shouldn't be allowed by default");
        Assertions.assertFalse((boolean)validator.isValid("file://localhost/etc/hosts"), (String)"file://localhost/etc/ shouldn't be allowed by default");
        Assertions.assertFalse((boolean)validator.isValid("file://localhost/c:/some.file"), (String)"file://localhost/c:/ shouldn't be allowed by default");
        validator = new UrlValidator(new String[]{"http", "file"}, 8L);
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org/test/index.html"), (String)"http://apache.org/ should be allowed by default");
        Assertions.assertTrue((boolean)validator.isValid("file:///C:/some.file"), (String)"file:///c:/ should now be allowed");
        Assertions.assertFalse((boolean)validator.isValid("file:///C:\\some.file"), (String)"file:///c:\\ should not be allowed");
        Assertions.assertTrue((boolean)validator.isValid("file:///etc/hosts"), (String)"file:///etc/ should now be allowed");
        Assertions.assertTrue((boolean)validator.isValid("file://localhost/etc/hosts"), (String)"file://localhost/etc/ should now be allowed");
        Assertions.assertTrue((boolean)validator.isValid("file://localhost/c:/some.file"), (String)"file://localhost/c:/ should now be allowed");
        Assertions.assertFalse((boolean)validator.isValid("file://C:/some.file"), (String)"file://c:/ shouldn't ever be allowed, needs file:///c:/");
        Assertions.assertFalse((boolean)validator.isValid("file://C:\\some.file"), (String)"file://c:\\ shouldn't ever be allowed, needs file:///c:/");
    }

    @Test
    public void testValidator283() {
        UrlValidator validator = new UrlValidator();
        Assertions.assertFalse((boolean)validator.isValid("http://finance.yahoo.com/news/Owners-54B-NY-housing-apf-2493139299.html?x=0&ap=%fr"));
        Assertions.assertTrue((boolean)validator.isValid("http://finance.yahoo.com/news/Owners-54B-NY-housing-apf-2493139299.html?x=0&ap=%22"));
    }

    @Test
    public void testValidator288() {
        UrlValidator validator = new UrlValidator(8L);
        Assertions.assertTrue((boolean)validator.isValid("http://hostname"), (String)"hostname should validate");
        Assertions.assertTrue((boolean)validator.isValid("http://hostname/test/index.html"), (String)"hostname with path should validate");
        Assertions.assertTrue((boolean)validator.isValid("http://localhost/test/index.html"), (String)"localhost URL should validate");
        Assertions.assertFalse((boolean)validator.isValid("http://first.my-testing/test/index.html"), (String)"first.my-testing should not validate");
        Assertions.assertFalse((boolean)validator.isValid("http://broke.hostname/test/index.html"), (String)"broke.hostname should not validate");
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org/test/index.html"), (String)"www.apache.org should still validate");
        validator = new UrlValidator(0L);
        Assertions.assertFalse((boolean)validator.isValid("http://hostname"), (String)"hostname should no longer validate");
        Assertions.assertFalse((boolean)validator.isValid("http://localhost/test/index.html"), (String)"localhost URL should no longer validate");
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org/test/index.html"), (String)"www.apache.org should still validate");
    }

    @Test
    public void testValidator290() {
        UrlValidator validator = new UrlValidator();
        Assertions.assertTrue((boolean)validator.isValid("http://xn--h1acbxfam.idn.icann.org/"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--lgbbat1ad8j"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--fiqs8s"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--fiqz9s"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--wgbh1c"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--j6w193g"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--h2brj9c"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--mgbbh1a71e"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--fpcrj9c3d"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--gecrj9c"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--s9brj9c"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--xkc2dl3a5ee0h"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--45brj9c"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--mgba3a4f16a"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--mgbayh7gpa"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--mgbc0a9azcg"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--ygbi2ammx"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--wgbl6a"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--p1ai"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--mgberp4a5d4ar"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--90a3ac"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--yfro4i67o"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--clchc0ea0b2g2a9gcd"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--3e0b707e"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--fzc2c9e2c"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--xkc2al3hye2a"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--ogbpf8fl"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--kprw13d"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--kpry57d"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--o3cw4h"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--pgbs0dh"));
        Assertions.assertTrue((boolean)validator.isValid("http://test.xn--mgbaam7a8h"));
    }

    @Test
    public void testValidator309() {
        UrlValidator urlValidator = new UrlValidator();
        Assertions.assertTrue((boolean)urlValidator.isValid("http://sample.ondemand.com/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("hTtP://sample.ondemand.CoM/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("httpS://SAMPLE.ONEMAND.COM/"));
        urlValidator = new UrlValidator(new String[]{"HTTP", "HTTPS"});
        Assertions.assertTrue((boolean)urlValidator.isValid("http://sample.ondemand.com/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("hTtP://sample.ondemand.CoM/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("httpS://SAMPLE.ONEMAND.COM/"));
    }

    @Test
    public void testValidator339() {
        UrlValidator urlValidator = new UrlValidator();
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.cnn.com/WORLD/?hpt=sitenav"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.cnn.com./WORLD/?hpt=sitenav"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://www.cnn.com../"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://www.cnn.invalid/"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://www.cnn.invalid./"));
    }

    @Test
    public void testValidator339IDN() {
        UrlValidator urlValidator = new UrlValidator();
        Assertions.assertTrue((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444/WORLD/?hpt=sitenav"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444./WORLD/?hpt=sitenav"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444..../"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444.../"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444../"));
    }

    @Test
    public void testValidator342() {
        UrlValidator urlValidator = new UrlValidator();
        Assertions.assertTrue((boolean)urlValidator.isValid("http://example.rocks/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://example.rocks"));
    }

    @Test
    public void testValidator353() {
        UrlValidator validator = new UrlValidator();
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org:80/path"));
        Assertions.assertTrue((boolean)validator.isValid("http://user:pass@www.apache.org:80/path"));
        Assertions.assertTrue((boolean)validator.isValid("http://user:@www.apache.org:80/path"));
        Assertions.assertTrue((boolean)validator.isValid("http://user@www.apache.org:80/path"));
        Assertions.assertTrue((boolean)validator.isValid("http://us%00er:-._~!$&'()*+,;=@www.apache.org:80/path"));
        Assertions.assertFalse((boolean)validator.isValid("http://:pass@www.apache.org:80/path"));
        Assertions.assertFalse((boolean)validator.isValid("http://:@www.apache.org:80/path"));
        Assertions.assertFalse((boolean)validator.isValid("http://user:pa:ss@www.apache.org/path"));
        Assertions.assertFalse((boolean)validator.isValid("http://user:pa@ss@www.apache.org/path"));
    }

    @Test
    public void testValidator361() {
        UrlValidator validator = new UrlValidator();
        Assertions.assertTrue((boolean)validator.isValid("http://hello.tokyo/"));
    }

    @Test
    public void testValidator363() {
        UrlValidator urlValidator = new UrlValidator();
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/a/b/hello..world"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/a/hello..world"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/hello.world/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/hello..world/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/hello.world"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/hello..world"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/..world"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/.../world"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://www.example.org/../world"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://www.example.org/.."));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://www.example.org/../"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://www.example.org/./.."));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://www.example.org/././.."));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/..."));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/.../"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://www.example.org/.../.."));
    }

    @Test
    public void testValidator375() {
        UrlValidator validator = new UrlValidator();
        String url = "http://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:80/index.html";
        Assertions.assertTrue((boolean)validator.isValid(url), (String)("IPv6 address URL should validate: " + url));
        url = "http://[::1]:80/index.html";
        Assertions.assertTrue((boolean)validator.isValid(url), (String)("IPv6 address URL should validate: " + url));
        url = "http://FEDC:BA98:7654:3210:FEDC:BA98:7654:3210:80/index.html";
        Assertions.assertFalse((boolean)validator.isValid(url), (String)("IPv6 address without [] should not validate: " + url));
    }

    @Test
    public void testValidator380() {
        UrlValidator validator = new UrlValidator();
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org:80/path"));
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org:8/path"));
        Assertions.assertTrue((boolean)validator.isValid("http://www.apache.org:/path"));
    }

    @Test
    public void testValidator382() {
        UrlValidator validator = new UrlValidator();
        Assertions.assertTrue((boolean)validator.isValid("ftp://username:password@example.com:8042/over/there/index.dtb?type=animal&name=narwhal#nose"));
    }

    @Test
    public void testValidator391FAILS() {
        String[] schemes = new String[]{"file"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        Assertions.assertTrue((boolean)urlValidator.isValid("file:/C:/path/to/dir/"));
    }

    @Test
    public void testValidator391OK() {
        String[] schemes = new String[]{"file"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        Assertions.assertTrue((boolean)urlValidator.isValid("file:///C:/path/to/dir/"));
    }

    @Test
    public void testValidator411() {
        UrlValidator urlValidator = new UrlValidator();
        Assertions.assertTrue((boolean)urlValidator.isValid("http://example.rocks:/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://example.rocks:0/"));
        Assertions.assertTrue((boolean)urlValidator.isValid("http://example.rocks:65535/"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://example.rocks:65536/"));
        Assertions.assertFalse((boolean)urlValidator.isValid("http://example.rocks:100000/"));
    }

    @Test
    public void testValidator420() {
        UrlValidator validator = new UrlValidator();
        Assertions.assertFalse((boolean)validator.isValid("http://example.com/serach?address=Main Avenue"));
        Assertions.assertTrue((boolean)validator.isValid("http://example.com/serach?address=Main%20Avenue"));
        Assertions.assertTrue((boolean)validator.isValid("http://example.com/serach?address=Main+Avenue"));
    }

    @Test
    public void testValidator452() {
        UrlValidator urlValidator = new UrlValidator();
        Assertions.assertTrue((boolean)urlValidator.isValid("http://[::FFFF:129.144.52.38]:80/index.html"));
    }

    @Test
    public void testValidator464() {
        String[] schemes = new String[]{"file"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        String fileNAK = "file://bad ^ domain.com/label/test";
        Assertions.assertFalse((boolean)urlValidator.isValid("file://bad ^ domain.com/label/test"), (String)"file://bad ^ domain.com/label/test");
    }

    @Test
    public void testValidator467() {
        UrlValidator validator = new UrlValidator(2L);
        Assertions.assertTrue((boolean)validator.isValid("https://example.com/some_path/path/"));
        Assertions.assertTrue((boolean)validator.isValid("https://example.com//somepath/path/"));
        Assertions.assertTrue((boolean)validator.isValid("https://example.com//some_path/path/"));
        Assertions.assertTrue((boolean)validator.isValid("http://example.com//_test"));
    }

    @Test
    public void testValidator473_1() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new UrlValidator(new String[0], null, 0L, null));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"DomainValidator must not be null")));
    }

    @Test
    public void testValidator473_2() {
        ArrayList items = new ArrayList();
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new UrlValidator(new String[0], null, 0L, DomainValidator.getInstance((boolean)true, (List)items)));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"DomainValidator disagrees with ALLOW_LOCAL_URLS setting")));
    }

    @Test
    public void testValidator473_3() {
        ArrayList items = new ArrayList();
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new UrlValidator(new String[0], null, 8L, DomainValidator.getInstance((boolean)false, (List)items)));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"DomainValidator disagrees with ALLOW_LOCAL_URLS setting")));
    }
}

