/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.ISINCheckDigit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ISINCheckDigitTest
extends AbstractCheckDigitTest {
    private static final String[] INVALID_CHECK_DIGITS = new String[]{"US037833100O", "BMG8571G109D", "AU0000XVGZAD", "GB000263494I", "FR000402625C", "DK000976334H"};

    @BeforeEach
    protected void setUp() {
        this.routine = ISINCheckDigit.ISIN_CHECK_DIGIT;
        this.valid = new String[]{"US0378331005", "BMG8571G1096", "AU0000XVGZA3", "GB0002634946", "FR0004026250", "3133EHHF3", "DK0009763344", "dk0009763344", "AU0000xvgza3", "EZ0000000003", "XS0000000009", "AA0000000006"};
        this.invalid = new String[]{"0378#3100"};
    }

    @Test
    public void testVALIDATOR_345() {
        for (String invalidCheckDigit : INVALID_CHECK_DIGITS) {
            Assertions.assertFalse((boolean)this.routine.isValid(invalidCheckDigit), () -> "Should fail: " + invalidCheckDigit);
        }
    }
}

