/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.FormSet;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.util.ValidatorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidatorTest {
    public static Date formatDate(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        Date date = null;
        try {
            DateFormat formatter = DateFormat.getDateInstance(3, Locale.US);
            formatter.setLenient(false);
            date = formatter.parse(value);
        }
        catch (ParseException e) {
            System.out.println("ValidatorTest.formatDate() - " + e.getMessage());
        }
        return date;
    }

    public static boolean isCapLetter(Object bean, Field field, List<String> l) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (value == null || value.length() != 1) {
            l.add("Error");
            return false;
        }
        if (value.charAt(0) >= 'A' && value.charAt(0) <= 'Z') {
            return true;
        }
        l.add("Error");
        return false;
    }

    private ValidatorResources setupDateResources(String property, String action) {
        ValidatorResources resources = new ValidatorResources();
        ValidatorAction va = new ValidatorAction();
        va.setName(action);
        va.setClassname("org.apache.commons.validator.ValidatorTest");
        va.setMethod("formatDate");
        va.setMethodParams("java.lang.Object,org.apache.commons.validator.Field");
        FormSet fs = new FormSet();
        Form form = new Form();
        form.setName("testForm");
        Field field = new Field();
        field.setProperty(property);
        field.setDepends(action);
        form.addField(field);
        fs.addForm(form);
        resources.addValidatorAction(va);
        resources.addFormSet(fs);
        resources.process();
        return resources;
    }

    @Test
    public void testManualBoolean() {
        ValidatorResources resources = new ValidatorResources();
        ValidatorAction va = new ValidatorAction();
        va.setName("capLetter");
        va.setClassName("org.apache.commons.validator.ValidatorTest");
        va.setMethod("isCapLetter");
        va.setMethodParams("java.lang.Object,org.apache.commons.validator.Field,java.util.List");
        FormSet fs = new FormSet();
        Form form = new Form();
        form.setName("testForm");
        Field field = new Field();
        field.setProperty("letter");
        field.setDepends("capLetter");
        form.addField(field);
        fs.addForm(form);
        resources.addValidatorAction(va);
        resources.addFormSet(fs);
        resources.process();
        ArrayList l = new ArrayList();
        TestBean bean = new TestBean();
        bean.setLetter("A");
        Validator validator = new Validator(resources, "testForm");
        validator.setParameter("java.lang.Object", (Object)bean);
        validator.setParameter("java.util.List", l);
        try {
            validator.validate();
        }
        catch (Exception e) {
            Assertions.fail((String)"An exception was thrown while calling Validator.validate()");
        }
        Assertions.assertEquals((int)0, (int)l.size(), (String)"Validation of the letter 'A'.");
        l.clear();
        bean.setLetter("AA");
        try {
            validator.validate();
        }
        catch (Exception e) {
            Assertions.fail((String)"An exception was thrown while calling Validator.validate()");
        }
        Assertions.assertEquals((int)1, (int)l.size(), (String)"Validation of the letter 'AA'.");
    }

    @Test
    public void testManualBooleanDeprecated() {
        ValidatorResources resources = new ValidatorResources();
        ValidatorAction va = new ValidatorAction();
        va.setName("capLetter");
        va.setClassname("org.apache.commons.validator.ValidatorTest");
        va.setMethod("isCapLetter");
        va.setMethodParams("java.lang.Object,org.apache.commons.validator.Field,java.util.List");
        FormSet fs = new FormSet();
        Form form = new Form();
        form.setName("testForm");
        Field field = new Field();
        field.setProperty("letter");
        field.setDepends("capLetter");
        form.addField(field);
        fs.addForm(form);
        resources.addValidatorAction(va);
        resources.addFormSet(fs);
        resources.process();
        ArrayList l = new ArrayList();
        TestBean bean = new TestBean();
        bean.setLetter("A");
        Validator validator = new Validator(resources, "testForm");
        validator.setParameter("java.lang.Object", (Object)bean);
        validator.setParameter("java.util.List", l);
        try {
            validator.validate();
        }
        catch (Exception e) {
            Assertions.fail((String)"An exception was thrown while calling Validator.validate()");
        }
        Assertions.assertEquals((int)0, (int)l.size(), (String)"Validation of the letter 'A'.");
        l.clear();
        bean.setLetter("AA");
        try {
            validator.validate();
        }
        catch (Exception e) {
            Assertions.fail((String)"An exception was thrown while calling Validator.validate()");
        }
        Assertions.assertEquals((int)1, (int)l.size(), (String)"Validation of the letter 'AA'.");
    }

    @Test
    public void testManualObject() {
        ValidatorResult result;
        ValidatorResults results;
        String property = "date";
        String action = "date";
        ValidatorResources resources = this.setupDateResources("date", "date");
        TestBean bean = new TestBean();
        bean.setDate("2/3/1999");
        Validator validator = new Validator(resources, "testForm");
        validator.setParameter("java.lang.Object", (Object)bean);
        try {
            results = validator.validate();
            Assertions.assertNotNull((Object)results, (String)"Results are null.");
            result = results.getValidatorResult("date");
            Assertions.assertNotNull((Object)results, (String)"Results are null.");
            Assertions.assertTrue((boolean)result.containsAction("date"), (String)"ValidatorResult does not contain 'date' validator result.");
            Assertions.assertTrue((boolean)result.isValid("date"), (String)"Validation of the date formatting has failed.");
        }
        catch (Exception e) {
            Assertions.fail((String)"An exception was thrown while calling Validator.validate()");
        }
        bean.setDate("2/30/1999");
        try {
            results = validator.validate();
            Assertions.assertNotNull((Object)results, (String)"Results are null.");
            result = results.getValidatorResult("date");
            Assertions.assertNotNull((Object)results, (String)"Results are null.");
            Assertions.assertTrue((boolean)result.containsAction("date"), (String)"ValidatorResult does not contain 'date' validator result.");
            Assertions.assertTrue((!result.isValid("date") ? 1 : 0) != 0, (String)"Validation of the date formatting has passed when it should have failed.");
        }
        catch (Exception e) {
            Assertions.fail((String)"An exception was thrown while calling Validator.validate()");
        }
    }

    @Test
    public void testOnlyReturnErrors() throws ValidatorException {
        String property = "date";
        String action = "date";
        ValidatorResources resources = this.setupDateResources("date", "date");
        TestBean bean = new TestBean();
        bean.setDate("2/3/1999");
        Validator validator = new Validator(resources, "testForm");
        validator.setParameter("java.lang.Object", (Object)bean);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results);
        Assertions.assertTrue((boolean)results.getPropertyNames().contains("date"));
        validator.setOnlyReturnErrors(true);
        results = validator.validate();
        Assertions.assertFalse((boolean)results.getPropertyNames().contains("date"));
    }

    @Test
    public void testOnlyValidateField() throws ValidatorException {
        String property = "date";
        String action = "date";
        ValidatorResources resources = this.setupDateResources("date", "date");
        TestBean bean = new TestBean();
        bean.setDate("2/3/1999");
        Validator validator = new Validator(resources, "testForm", "date");
        validator.setParameter("java.lang.Object", (Object)bean);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results);
        Assertions.assertTrue((boolean)results.getPropertyNames().contains("date"));
    }

    public static class TestBean {
        private String letter;
        private String date;

        public String getDate() {
            return this.date;
        }

        public String getLetter() {
            return this.letter;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setLetter(String letter) {
            this.letter = letter;
        }
    }
}

