/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.LongValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LongValidatorTest
extends AbstractNumberValidatorTest {
    private static final Long LONG_MIN_VAL = Long.MIN_VALUE;
    private static final Long LONG_MAX_VAL = Long.MAX_VALUE;
    private static final String LONG_MAX = "9223372036854775807";
    private static final String LONG_MAX_0 = "9223372036854775807.99999999999999999999999";
    private static final String LONG_MAX_1 = "9223372036854775808";
    private static final String LONG_MIN = "-9223372036854775808";
    private static final String LONG_MIN_0 = "-9223372036854775808.99999999999999999999999";
    private static final String LONG_MIN_1 = "-9223372036854775809";
    private static final String NINES = "9999999999999999999999999999999999999";

    @Override
    @BeforeEach
    protected void setUp() {
        super.setUp();
        this.validator = new LongValidator(false, 0);
        this.strictValidator = new LongValidator();
        this.testPattern = "#,###";
        this.max = null;
        this.maxPlusOne = null;
        this.min = null;
        this.minMinusOne = null;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2", LONG_MAX_1, LONG_MIN_1, NINES};
        this.invalid = new String[]{null, "", "X", "X12", "", LONG_MAX_1, LONG_MIN_1, NINES};
        this.testNumber = 1234L;
        this.testZero = 0L;
        this.validStrict = new String[]{"0", "1234", "1,234", LONG_MAX, LONG_MIN};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, LONG_MAX_VAL, LONG_MIN_VAL};
        this.valid = new String[]{"0", "1234", "1,234", "1,234.5", "1234X", LONG_MAX, LONG_MIN, LONG_MAX_0, LONG_MIN_0};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber, LONG_MAX_VAL, LONG_MIN_VAL, LONG_MAX_VAL, LONG_MIN_VAL};
        this.testStringUS = "1,234";
        this.localeValue = this.testStringDE = "1.234";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    @Test
    public void testLongRangeMinMax() {
        LongValidator validator = (LongValidator)this.strictValidator;
        Long number9 = validator.validate("9", "#");
        Long number10 = validator.validate("10", "#");
        Long number11 = validator.validate("11", "#");
        Long number19 = validator.validate("19", "#");
        Long number20 = validator.validate("20", "#");
        Long number21 = validator.validate("21", "#");
        Assertions.assertFalse((boolean)validator.isInRange(number9, 10L, 20L), (String)"isInRange() < min");
        Assertions.assertTrue((boolean)validator.isInRange(number10, 10L, 20L), (String)"isInRange() = min");
        Assertions.assertTrue((boolean)validator.isInRange(number11, 10L, 20L), (String)"isInRange() in range");
        Assertions.assertTrue((boolean)validator.isInRange(number20, 10L, 20L), (String)"isInRange() = max");
        Assertions.assertFalse((boolean)validator.isInRange(number21, 10L, 20L), (String)"isInRange() > max");
        Assertions.assertFalse((boolean)validator.minValue(number9, 10L), (String)"minValue() < min");
        Assertions.assertTrue((boolean)validator.minValue(number10, 10L), (String)"minValue() = min");
        Assertions.assertTrue((boolean)validator.minValue(number11, 10L), (String)"minValue() > min");
        Assertions.assertTrue((boolean)validator.maxValue(number19, 20L), (String)"maxValue() < max");
        Assertions.assertTrue((boolean)validator.maxValue(number20, 20L), (String)"maxValue() = max");
        Assertions.assertFalse((boolean)validator.maxValue(number21, 20L), (String)"maxValue() > max");
    }

    @Test
    public void testLongValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        Long expected = 12345L;
        Assertions.assertEquals((Long)expected, (Long)LongValidator.getInstance().validate("12,345"), (String)"validate(A) default");
        Assertions.assertEquals((Long)expected, (Long)LongValidator.getInstance().validate("12.345", locale), (String)"validate(A) locale");
        Assertions.assertEquals((Long)expected, (Long)LongValidator.getInstance().validate("1,23,45", "0,00,00"), (String)"validate(A) pattern");
        Assertions.assertEquals((Long)expected, (Long)LongValidator.getInstance().validate("1.23.45", "0,00,00", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)LongValidator.getInstance().isValid("12,345"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)LongValidator.getInstance().isValid("12.345", locale), (String)"isValid(A) locale");
        Assertions.assertTrue((boolean)LongValidator.getInstance().isValid("1,23,45", "0,00,00"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)LongValidator.getInstance().isValid("1.23.45", "0,00,00", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)LongValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)LongValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale");
        Assertions.assertNull((Object)LongValidator.getInstance().validate("XXXX", "0,00,00"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)LongValidator.getInstance().validate("1,23,45", "0,00,00", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)LongValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)LongValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale");
        Assertions.assertFalse((boolean)LongValidator.getInstance().isValid("XXXX", "0,00,00"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)LongValidator.getInstance().isValid("1,23,45", "0,00,00", Locale.GERMAN), (String)"isValid(B) both");
    }
}

