/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.ISBNCheckDigit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ISBNCheckDigitTest
extends AbstractCheckDigitTest {
    @BeforeEach
    protected void setUp() {
        this.routine = ISBNCheckDigit.ISBN_CHECK_DIGIT;
        this.valid = new String[]{"9780072129519", "9780764558313", "1930110995", "020163385X", "1590596277", "9781590596272"};
        this.missingMessage = "ISBN Code is missing";
        this.zeroSum = "000000000000";
    }

    @Test
    public void testInvalidLength() {
        Assertions.assertFalse((boolean)this.routine.isValid("123456789"), (String)"isValid() Lth 9 ");
        Assertions.assertFalse((boolean)this.routine.isValid("12345678901"), (String)"isValid() Lth 11");
        Assertions.assertFalse((boolean)this.routine.isValid("123456789012"), (String)"isValid() Lth 12");
        Assertions.assertFalse((boolean)this.routine.isValid("12345678901234"), (String)"isValid() Lth 14");
        try {
            this.routine.calculate("12345678");
            Assertions.fail((String)"calculate() Lth 8 - expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)"Invalid ISBN Length = 8", (String)"calculate() Lth 8");
        }
        try {
            this.routine.calculate("1234567890");
            Assertions.fail((String)"calculate() Lth 10 - expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Invalid ISBN Length = 10", (Object)e.getMessage(), (String)"calculate() Lth 10");
        }
        try {
            this.routine.calculate("12345678901");
            Assertions.fail((String)"calculate() Lth 11 - expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Invalid ISBN Length = 11", (Object)e.getMessage(), (String)"calculate() Lth 11");
        }
        try {
            this.routine.calculate("1234567890123");
            Assertions.fail((String)"calculate() Lth 13 - expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Invalid ISBN Length = 13", (Object)e.getMessage(), (String)"calculate() Lth 13");
        }
    }
}

