/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.DecimalFormat;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.FloatValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FloatValidatorTest
extends AbstractNumberValidatorTest {
    @Override
    @BeforeEach
    protected void setUp() {
        super.setUp();
        this.validator = new FloatValidator(false, 0);
        this.strictValidator = new FloatValidator();
        this.testPattern = "#,###.#";
        this.max = Float.valueOf(Float.MAX_VALUE);
        this.maxPlusOne = this.max.doubleValue() * 10.0;
        this.min = Float.valueOf(-3.4028235E38f);
        this.minMinusOne = this.min.doubleValue() * 10.0;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = Float.valueOf(1234.5f);
        this.testZero = Float.valueOf(0.0f);
        this.validStrict = new String[]{"0", "1234.5", "1,234.5"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234.5", "1,234.5", "1,234.5", "1234.5X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234.5";
        this.localeValue = this.testStringDE = "1.234,5";
        this.localePattern = "#.###,#";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    @Test
    public void testFloatRangeMinMax() {
        FloatValidator validator = (FloatValidator)this.strictValidator;
        Float number9 = validator.validate("9", "#");
        Float number10 = validator.validate("10", "#");
        Float number11 = validator.validate("11", "#");
        Float number19 = validator.validate("19", "#");
        Float number20 = validator.validate("20", "#");
        Float number21 = validator.validate("21", "#");
        Assertions.assertFalse((boolean)validator.isInRange(number9, 10.0f, 20.0f), (String)"isInRange() < min");
        Assertions.assertTrue((boolean)validator.isInRange(number10, 10.0f, 20.0f), (String)"isInRange() = min");
        Assertions.assertTrue((boolean)validator.isInRange(number11, 10.0f, 20.0f), (String)"isInRange() in range");
        Assertions.assertTrue((boolean)validator.isInRange(number20, 10.0f, 20.0f), (String)"isInRange() = max");
        Assertions.assertFalse((boolean)validator.isInRange(number21, 10.0f, 20.0f), (String)"isInRange() > max");
        Assertions.assertFalse((boolean)validator.minValue(number9, 10.0f), (String)"minValue() < min");
        Assertions.assertTrue((boolean)validator.minValue(number10, 10.0f), (String)"minValue() = min");
        Assertions.assertTrue((boolean)validator.minValue(number11, 10.0f), (String)"minValue() > min");
        Assertions.assertTrue((boolean)validator.maxValue(number19, 20.0f), (String)"maxValue() < max");
        Assertions.assertTrue((boolean)validator.maxValue(number20, 20.0f), (String)"maxValue() = max");
        Assertions.assertFalse((boolean)validator.maxValue(number21, 20.0f), (String)"maxValue() > max");
    }

    @Test
    public void testFloatSmallestValues() {
        String pattern = "#.#################################################################";
        DecimalFormat fmt = new DecimalFormat("#.#################################################################");
        Float smallestPositive = Float.valueOf(Float.MIN_VALUE);
        String strSmallestPositive = fmt.format(smallestPositive);
        Assertions.assertEquals((Float)smallestPositive, (Float)FloatValidator.getInstance().validate(strSmallestPositive, "#.#################################################################"), (String)"Smallest +ve");
        Float smallestNegative = Float.valueOf(-1.4E-45f);
        String strSmallestNegative = fmt.format(smallestNegative);
        Assertions.assertEquals((Float)smallestNegative, (Float)FloatValidator.getInstance().validate(strSmallestNegative, "#.#################################################################"), (String)"Smallest -ve");
        Double tooSmallPositive = 1.4012984643248171E-46;
        String strTooSmallPositive = fmt.format(tooSmallPositive);
        Assertions.assertFalse((boolean)FloatValidator.getInstance().isValid(strTooSmallPositive, "#.#################################################################"), (String)"Too small +ve");
        Double tooSmallNegative = tooSmallPositive * -1.0;
        String strTooSmallNegative = fmt.format(tooSmallNegative);
        Assertions.assertFalse((boolean)FloatValidator.getInstance().isValid(strTooSmallNegative, "#.#################################################################"), (String)"Too small -ve");
    }

    @Test
    public void testFloatValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String localeVal = "12.345";
        String germanPatternVal = "1.23.45";
        String defaultVal = "12,345";
        String xxxx = "XXXX";
        Float expected = Float.valueOf(12345.0f);
        Assertions.assertEquals((Float)expected, (Float)FloatValidator.getInstance().validate("12,345"), (String)"validate(A) default");
        Assertions.assertEquals((Float)expected, (Float)FloatValidator.getInstance().validate("12.345", locale), (String)"validate(A) locale");
        Assertions.assertEquals((Float)expected, (Float)FloatValidator.getInstance().validate("1,23,45", "0,00,00"), (String)"validate(A) pattern");
        Assertions.assertEquals((Float)expected, (Float)FloatValidator.getInstance().validate("1.23.45", "0,00,00", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)FloatValidator.getInstance().isValid("12,345"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)FloatValidator.getInstance().isValid("12.345", locale), (String)"isValid(A) locale");
        Assertions.assertTrue((boolean)FloatValidator.getInstance().isValid("1,23,45", "0,00,00"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)FloatValidator.getInstance().isValid("1.23.45", "0,00,00", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)FloatValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)FloatValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale ");
        Assertions.assertNull((Object)FloatValidator.getInstance().validate("XXXX", "0,00,00"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)FloatValidator.getInstance().validate("1,23,45", "0,00,00", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)FloatValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)FloatValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale");
        Assertions.assertFalse((boolean)FloatValidator.getInstance().isValid("XXXX", "0,00,00"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)FloatValidator.getInstance().isValid("1,23,45", "0,00,00", Locale.GERMAN), (String)"isValid(B) both");
    }
}

