/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.ShortValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ShortValidatorTest
extends AbstractNumberValidatorTest {
    @Override
    @BeforeEach
    protected void setUp() {
        super.setUp();
        this.validator = new ShortValidator(false, 0);
        this.strictValidator = new ShortValidator();
        this.testPattern = "#,###";
        this.max = (short)Short.MAX_VALUE;
        this.maxPlusOne = this.max.longValue() + 1L;
        this.min = (short)Short.MIN_VALUE;
        this.minMinusOne = this.min.longValue() - 1L;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = (short)1234;
        this.testZero = (short)0;
        this.validStrict = new String[]{"0", "1234", "1,234"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234", "1,234", "1,234.5", "1234X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234";
        this.localeValue = this.testStringDE = "1.234";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    @Test
    public void testShortRangeMinMax() {
        ShortValidator validator = (ShortValidator)this.strictValidator;
        Short number9 = validator.validate("9", "#");
        Short number10 = validator.validate("10", "#");
        Short number11 = validator.validate("11", "#");
        Short number19 = validator.validate("19", "#");
        Short number20 = validator.validate("20", "#");
        Short number21 = validator.validate("21", "#");
        int min = 10;
        int max = 20;
        Assertions.assertFalse((boolean)validator.isInRange(number9, (short)10, (short)20), (String)"isInRange() < min");
        Assertions.assertTrue((boolean)validator.isInRange(number10, (short)10, (short)20), (String)"isInRange() = min");
        Assertions.assertTrue((boolean)validator.isInRange(number11, (short)10, (short)20), (String)"isInRange() in range");
        Assertions.assertTrue((boolean)validator.isInRange(number20, (short)10, (short)20), (String)"isInRange() = max");
        Assertions.assertFalse((boolean)validator.isInRange(number21, (short)10, (short)20), (String)"isInRange() > max");
        Assertions.assertFalse((boolean)validator.minValue(number9, (short)10), (String)"minValue() < min");
        Assertions.assertTrue((boolean)validator.minValue(number10, (short)10), (String)"minValue() = min");
        Assertions.assertTrue((boolean)validator.minValue(number11, (short)10), (String)"minValue() > min");
        Assertions.assertTrue((boolean)validator.maxValue(number19, (short)20), (String)"maxValue() < max");
        Assertions.assertTrue((boolean)validator.maxValue(number20, (short)20), (String)"maxValue() = max");
        Assertions.assertFalse((boolean)validator.maxValue(number21, (short)20), (String)"maxValue() > max");
    }

    @Test
    public void testShortValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String xxxx = "XXXX";
        Short expected = 12345;
        Assertions.assertEquals((Short)expected, (Short)ShortValidator.getInstance().validate("12,345"), (String)"validate(A) default");
        Assertions.assertEquals((Short)expected, (Short)ShortValidator.getInstance().validate("12.345", locale), (String)"validate(A) locale");
        Assertions.assertEquals((Short)expected, (Short)ShortValidator.getInstance().validate("1,23,45", "0,00,00"), (String)"validate(A) pattern");
        Assertions.assertEquals((Short)expected, (Short)ShortValidator.getInstance().validate("1.23.45", "0,00,00", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)ShortValidator.getInstance().isValid("12,345"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)ShortValidator.getInstance().isValid("12.345", locale), (String)"isValid(A) locale");
        Assertions.assertTrue((boolean)ShortValidator.getInstance().isValid("1,23,45", "0,00,00"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)ShortValidator.getInstance().isValid("1.23.45", "0,00,00", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)ShortValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)ShortValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale");
        Assertions.assertNull((Object)ShortValidator.getInstance().validate("XXXX", "0,00,00"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)ShortValidator.getInstance().validate("1,23,45", "0,00,00", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)ShortValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)ShortValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale");
        Assertions.assertFalse((boolean)ShortValidator.getInstance().isValid("XXXX", "0,00,00"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)ShortValidator.getInstance().isValid("1,23,45", "0,00,00", Locale.GERMAN), (String)"isValid(B) both");
    }
}

