/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.ValueBean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

public abstract class AbstractNumberTest
extends AbstractCommonTest {
    protected String formKey;
    protected String action;

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("TestNumber-config.xml");
    }

    @AfterEach
    protected void tearDown() {
    }

    @Test
    public void testNumber() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("0");
        this.valueTest(info, true);
    }

    @Test
    public void testNumberFailure() throws ValidatorException {
        ValueBean info = new ValueBean();
        this.valueTest(info, false);
    }

    protected void valueTest(Object info, boolean passed) throws ValidatorException {
        Validator validator = new Validator(this.resources, this.formKey);
        validator.setParameter("java.lang.Object", info);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult result = results.getValidatorResult("value");
        Assertions.assertNotNull((Object)result, () -> this.action + " value ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)result.containsAction(this.action), () -> this.action + " value ValidatorResult should contain the '" + this.action + "' action.");
        Assertions.assertTrue((boolean)(passed ? result.isValid(this.action) : !result.isValid(this.action)), () -> this.action + " value ValidatorResult for the '" + this.action + "' action should have " + (passed ? "passed" : "failed") + ".");
    }
}

