/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

public class MultipleTest
extends AbstractCommonTest {
    protected static final String FORM_KEY = "nameForm";
    protected static final String ACTION = "required";

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("MultipleTests-config.xml");
    }

    @AfterEach
    protected void tearDown() {
    }

    @Test
    public void testBothBlank() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!firstNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"Last Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), () -> "Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!lastNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "Last Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertTrue((!lastNameResult.containsAction("int") ? 1 : 0) != 0, (String)"Last Name ValidatorResults should not contain the 'int' action.");
    }

    @Test
    public void testFailingFirstDependentValidator() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult middleNameResult = results.getValidatorResult("middleName");
        Assertions.assertNotNull((Object)middleNameResult, (String)"Middle Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)middleNameResult.containsAction(ACTION), (String)"Middle Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!middleNameResult.isValid(ACTION) ? 1 : 0) != 0, (String)"Middle Name ValidatorResult for the 'required' action should have failed");
        Assertions.assertTrue((!middleNameResult.containsAction("int") ? 1 : 0) != 0, (String)"Middle Name ValidatorResult should not contain the 'int' action.");
        Assertions.assertTrue((!middleNameResult.containsAction("positive") ? 1 : 0) != 0, (String)"Middle Name ValidatorResult should not contain the 'positive' action.");
    }

    @Test
    public void testFailingNextDependentValidator() throws ValidatorException {
        NameBean name = new NameBean();
        name.setMiddleName("TEST");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult middleNameResult = results.getValidatorResult("middleName");
        Assertions.assertNotNull((Object)middleNameResult, (String)"Middle Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)middleNameResult.containsAction(ACTION), (String)"Middle Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)middleNameResult.isValid(ACTION), (String)"Middle Name ValidatorResult for the 'required' action should have passed");
        Assertions.assertTrue((boolean)middleNameResult.containsAction("int"), (String)"Middle Name ValidatorResult should contain the 'int' action.");
        Assertions.assertTrue((!middleNameResult.isValid("int") ? 1 : 0) != 0, (String)"Middle Name ValidatorResult for the 'int' action should have failed");
        Assertions.assertTrue((!middleNameResult.containsAction("positive") ? 1 : 0) != 0, (String)"Middle Name ValidatorResult should not contain the 'positive' action.");
    }

    @Test
    public void testPassingDependentsFailingMain() throws ValidatorException {
        NameBean name = new NameBean();
        name.setMiddleName("-2534");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult middleNameResult = results.getValidatorResult("middleName");
        Assertions.assertNotNull((Object)middleNameResult, (String)"Middle Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)middleNameResult.containsAction(ACTION), (String)"Middle Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)middleNameResult.isValid(ACTION), (String)"Middle Name ValidatorResult for the 'required' action should have passed");
        Assertions.assertTrue((boolean)middleNameResult.containsAction("int"), (String)"Middle Name ValidatorResult should contain the 'int' action.");
        Assertions.assertTrue((boolean)middleNameResult.isValid("int"), (String)"Middle Name ValidatorResult for the 'int' action should have passed");
        Assertions.assertTrue((boolean)middleNameResult.containsAction("positive"), (String)"Middle Name ValidatorResult should contain the 'positive' action.");
        Assertions.assertTrue((!middleNameResult.isValid("positive") ? 1 : 0) != 0, (String)"Middle Name ValidatorResult for the 'positive' action should have failed");
    }

    @Test
    public void testPassingDependentsPassingMain() throws ValidatorException {
        NameBean name = new NameBean();
        name.setMiddleName("2534");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult middleNameResult = results.getValidatorResult("middleName");
        Assertions.assertNotNull((Object)middleNameResult, (String)"Middle Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)middleNameResult.containsAction(ACTION), (String)"Middle Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)middleNameResult.isValid(ACTION), (String)"Middle Name ValidatorResult for the 'required' action should have passed");
        Assertions.assertTrue((boolean)middleNameResult.containsAction("int"), (String)"Middle Name ValidatorResult should contain the 'int' action.");
        Assertions.assertTrue((boolean)middleNameResult.isValid("int"), (String)"Middle Name ValidatorResult for the 'int' action should have passed");
        Assertions.assertTrue((boolean)middleNameResult.containsAction("positive"), (String)"Middle Name ValidatorResult should contain the 'positive' action.");
        Assertions.assertTrue((boolean)middleNameResult.isValid("positive"), (String)"Middle Name ValidatorResult for the 'positive' action should have passed");
    }

    @Test
    public void testRequiredFirstNameBlankLastNameShort() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("Test");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!firstNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"Last Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction("int"), (String)"Last Name ValidatorResult should contain the 'int' action.");
        Assertions.assertTrue((!lastNameResult.isValid("int") ? 1 : 0) != 0, (String)"Last Name ValidatorResult for the 'int' action should have failed.");
    }

    @Test
    public void testRequiredLastNameLong() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        name.setLastName("12345678");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)firstNameResult.isValid(ACTION), () -> "First Name ValidatorResult for the 'required' action should have passed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"Last Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction("int"), (String)"Last Name ValidatorResult should contain the 'int' action.");
        Assertions.assertTrue((boolean)lastNameResult.isValid("int"), (String)"Last Name ValidatorResult for the 'int' action should have passed.");
    }

    @Test
    public void testRequiredLastNameShort() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Test");
        name.setLastName("Test");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)firstNameResult.isValid(ACTION), () -> "First Name ValidatorResult for the 'required' action should have passed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"Last Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction("int"), (String)"Last Name ValidatorResult should contain the 'int' action.");
        Assertions.assertTrue((!lastNameResult.isValid("int") ? 1 : 0) != 0, (String)"Last Name ValidatorResult for the 'int' action should have failed.");
    }
}

