/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.validator.routines.TimeValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TimeValidatorTest {
    protected static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected static final TimeZone EST = TimeZone.getTimeZone("EST");
    protected TimeValidator validator;
    protected String[] patternValid = new String[]{"23-59-59", "00-00-00", "00-00-01", "0-0-0", "1-12-1", "10-49-18", "16-23-46"};
    protected Date[] patternExpect = new Date[]{TimeValidatorTest.createDate(null, 235959, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 1, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 11201, 0), TimeValidatorTest.createDate(null, 104918, 0), TimeValidatorTest.createDate(null, 162346, 0)};
    protected String[] localeValid = new String[]{"23:59", "00:00", "00:01", "0:0", "1:12", "10:49", "16:23"};
    protected Date[] localeExpect = new Date[]{TimeValidatorTest.createDate(null, 235900, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 100, 0), TimeValidatorTest.createDate(null, 0, 0), TimeValidatorTest.createDate(null, 11200, 0), TimeValidatorTest.createDate(null, 104900, 0), TimeValidatorTest.createDate(null, 162300, 0)};
    protected String[] patternInvalid = new String[]{"24-00-00", "24-00-01", "25-02-03", "10-61-31", "10-01-61", "05:02-29", "0X-01:01", "05-0X-01", "10-01-0X", "01:01:05", "10-10", "10--10", "10-10-"};
    protected String[] localeInvalid = new String[]{"24:00", "24:00", "25:02", "10:61", "05-02", "0X:01", "05:0X", "01-01", "10:", "10::1", "10:1:"};
    private Locale origDefault;
    private TimeZone defaultZone;

    protected static Date createDate(TimeZone zone, int time, int millisecond) {
        Calendar calendar = TimeValidatorTest.createTime(zone, time, millisecond);
        return calendar.getTime();
    }

    protected static Calendar createTime(TimeZone zone, int time, int millisecond) {
        Calendar calendar = zone == null ? Calendar.getInstance() : Calendar.getInstance(zone);
        int hour = time / 10000 * 10000;
        int min = time / 100 * 100 - hour;
        int sec = time - (hour + min);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, hour / 10000);
        calendar.set(12, min / 100);
        calendar.set(13, sec);
        calendar.set(14, millisecond);
        return calendar;
    }

    @BeforeEach
    protected void setUp() {
        this.validator = new TimeValidator();
        this.defaultZone = TimeZone.getDefault();
        this.origDefault = Locale.getDefault();
    }

    @AfterEach
    protected void tearDown() {
        this.validator = null;
        Locale.setDefault(this.origDefault);
        TimeZone.setDefault(this.defaultZone);
    }

    @Test
    public void testCompare() {
        int testTime = 154523;
        int min = 100;
        int hour = 10000;
        Calendar milliGreater = TimeValidatorTest.createTime(GMT, 154523, 500);
        Calendar value = TimeValidatorTest.createTime(GMT, 154523, 400);
        Calendar milliLess = TimeValidatorTest.createTime(GMT, 154523, 300);
        Calendar secGreater = TimeValidatorTest.createTime(GMT, 154524, 100);
        Calendar secLess = TimeValidatorTest.createTime(GMT, 154522, 100);
        Calendar minGreater = TimeValidatorTest.createTime(GMT, 154623, 100);
        Calendar minLess = TimeValidatorTest.createTime(GMT, 154423, 100);
        Calendar hourGreater = TimeValidatorTest.createTime(GMT, 164523, 100);
        Calendar hourLess = TimeValidatorTest.createTime(GMT, 144523, 100);
        Assertions.assertEquals((int)-1, (int)this.validator.compareTime(value, milliGreater), (String)"mili LT");
        Assertions.assertEquals((int)0, (int)this.validator.compareTime(value, value), (String)"mili EQ");
        Assertions.assertEquals((int)1, (int)this.validator.compareTime(value, milliLess), (String)"mili GT");
        Assertions.assertEquals((int)-1, (int)this.validator.compareSeconds(value, secGreater), (String)"secs LT");
        Assertions.assertEquals((int)0, (int)this.validator.compareSeconds(value, milliGreater), (String)"secs =1");
        Assertions.assertEquals((int)0, (int)this.validator.compareSeconds(value, value), (String)"secs =2");
        Assertions.assertEquals((int)0, (int)this.validator.compareSeconds(value, milliLess), (String)"secs =3");
        Assertions.assertEquals((int)1, (int)this.validator.compareSeconds(value, secLess), (String)"secs GT");
        Assertions.assertEquals((int)-1, (int)this.validator.compareMinutes(value, minGreater), (String)"mins LT");
        Assertions.assertEquals((int)0, (int)this.validator.compareMinutes(value, secGreater), (String)"mins =1");
        Assertions.assertEquals((int)0, (int)this.validator.compareMinutes(value, value), (String)"mins =2");
        Assertions.assertEquals((int)0, (int)this.validator.compareMinutes(value, secLess), (String)"mins =3");
        Assertions.assertEquals((int)1, (int)this.validator.compareMinutes(value, minLess), (String)"mins GT");
        Assertions.assertEquals((int)-1, (int)this.validator.compareHours(value, hourGreater), (String)"hour LT");
        Assertions.assertEquals((int)0, (int)this.validator.compareHours(value, minGreater), (String)"hour =1");
        Assertions.assertEquals((int)0, (int)this.validator.compareHours(value, value), (String)"hour =2");
        Assertions.assertEquals((int)0, (int)this.validator.compareHours(value, minLess), (String)"hour =3");
        Assertions.assertEquals((int)1, (int)this.validator.compareHours(value, hourLess), (String)"hour GT");
    }

    @Test
    public void testFormat() {
        Locale.setDefault(Locale.UK);
        Calendar test = TimeValidator.getInstance().validate("16:49:23", "HH:mm:ss");
        Assertions.assertNotNull((Object)test, (String)"Test Date ");
        Assertions.assertEquals((Object)this.validator.format((Object)test, "HH-mm-ss"), (Object)"16-49-23", (String)"Format pattern");
        Assertions.assertEquals((Object)this.validator.format((Object)test, Locale.US), (Object)"4:49 PM", (String)"Format locale");
        Assertions.assertEquals((Object)this.validator.format((Object)test), (Object)"16:49", (String)"Format default");
    }

    @Test
    public void testLocaleInvalid() {
        for (int i = 0; i < this.localeInvalid.length; ++i) {
            String text = i + " value=[" + this.localeInvalid[i] + "] passed ";
            Calendar date = this.validator.validate(this.localeInvalid[i], Locale.US);
            Assertions.assertNull((Object)date, () -> "validate() " + text + date);
            Assertions.assertFalse((boolean)this.validator.isValid(this.localeInvalid[i], Locale.UK), () -> "isValid() " + text);
        }
    }

    @Test
    public void testLocaleValid() {
        for (int i = 0; i < this.localeValid.length; ++i) {
            String text = i + " value=[" + this.localeValid[i] + "] failed ";
            Calendar calendar = this.validator.validate(this.localeValid[i], Locale.UK);
            Assertions.assertNotNull((Object)calendar, () -> "validate() " + text);
            Date date = calendar.getTime();
            Assertions.assertTrue((boolean)this.validator.isValid(this.localeValid[i], Locale.UK), () -> "isValid() " + text);
            Assertions.assertEquals((Object)this.localeExpect[i], (Object)date, () -> "compare " + text);
        }
    }

    @Test
    public void testPatternInvalid() {
        for (int i = 0; i < this.patternInvalid.length; ++i) {
            String text = i + " value=[" + this.patternInvalid[i] + "] passed ";
            Calendar date = this.validator.validate(this.patternInvalid[i], "HH-mm-ss");
            Assertions.assertNull((Object)date, () -> "validate() " + text + date);
            Assertions.assertFalse((boolean)this.validator.isValid(this.patternInvalid[i], "HH-mm-ss"), () -> "isValid() " + text);
        }
    }

    @Test
    public void testPatternValid() {
        for (int i = 0; i < this.patternValid.length; ++i) {
            String text = i + " value=[" + this.patternValid[i] + "] failed ";
            Calendar calendar = this.validator.validate(this.patternValid[i], "HH-mm-ss");
            Assertions.assertNotNull((Object)calendar, () -> "validateObj() " + text);
            Date date = calendar.getTime();
            Assertions.assertTrue((boolean)this.validator.isValid(this.patternValid[i], "HH-mm-ss"), () -> "isValid() " + text);
            Assertions.assertEquals((Object)this.patternExpect[i], (Object)date, () -> "compare " + text);
        }
    }

    @Test
    public void testTimeZone() {
        Locale.setDefault(Locale.UK);
        TimeZone.setDefault(GMT);
        Calendar result = this.validator.validate("18:01");
        Assertions.assertNotNull((Object)result, (String)"default result");
        Assertions.assertEquals((Object)GMT, (Object)result.getTimeZone(), (String)"default zone");
        Assertions.assertEquals((int)18, (int)result.get(11), (String)"default hour");
        Assertions.assertEquals((int)1, (int)result.get(12), (String)"default minute");
        result = null;
        result = this.validator.validate("16:49", EST);
        Assertions.assertNotNull((Object)result, (String)"zone result");
        Assertions.assertEquals((Object)EST, (Object)result.getTimeZone(), (String)"zone zone");
        Assertions.assertEquals((int)16, (int)result.get(11), (String)"zone hour");
        Assertions.assertEquals((int)49, (int)result.get(12), (String)"zone minute");
        result = null;
        result = this.validator.validate("14-34", "HH-mm", EST);
        Assertions.assertNotNull((Object)result, (String)"pattern result");
        Assertions.assertEquals((Object)EST, (Object)result.getTimeZone(), (String)"pattern zone");
        Assertions.assertEquals((int)14, (int)result.get(11), (String)"pattern hour");
        Assertions.assertEquals((int)34, (int)result.get(12), (String)"pattern minute");
        result = null;
        result = this.validator.validate("7:18 PM", Locale.US, EST);
        Assertions.assertNotNull((Object)result, (String)"locale result");
        Assertions.assertEquals((Object)EST, (Object)result.getTimeZone(), (String)"locale zone");
        Assertions.assertEquals((int)19, (int)result.get(11), (String)"locale hour");
        Assertions.assertEquals((int)18, (int)result.get(12), (String)"locale minute");
        result = null;
        result = this.validator.validate("31/Dez/05 21-05", "dd/MMM/yy HH-mm", Locale.GERMAN, EST);
        Assertions.assertNotNull((Object)result, (String)"pattern result");
        Assertions.assertEquals((Object)EST, (Object)result.getTimeZone(), (String)"pattern zone");
        Assertions.assertEquals((int)2005, (int)result.get(1), (String)"pattern day");
        Assertions.assertEquals((int)11, (int)result.get(2), (String)"pattern day");
        Assertions.assertEquals((int)31, (int)result.get(5), (String)"pattern day");
        Assertions.assertEquals((int)21, (int)result.get(11), (String)"pattern hour");
        Assertions.assertEquals((int)5, (int)result.get(12), (String)"pattern minute");
        result = null;
        result = this.validator.validate("31/Dez/05 21-05", "dd/MMM/yy HH-mm", Locale.GERMAN);
        Assertions.assertNotNull((Object)result, (String)"pattern result");
        Assertions.assertEquals((Object)GMT, (Object)result.getTimeZone(), (String)"pattern zone");
        Assertions.assertEquals((int)2005, (int)result.get(1), (String)"pattern day");
        Assertions.assertEquals((int)11, (int)result.get(2), (String)"pattern day");
        Assertions.assertEquals((int)31, (int)result.get(5), (String)"pattern day");
        Assertions.assertEquals((int)21, (int)result.get(11), (String)"pattern hour");
        Assertions.assertEquals((int)5, (int)result.get(12), (String)"pattern minute");
        result = null;
    }
}

