/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogSource;
import org.apache.commons.validator.Constant;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.FormSet;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;

public class ValidatorResources
implements Serializable {
    protected static Log log = LogSource.getInstance((String)(class$org$apache$commons$validator$ValidatorResources == null ? (class$org$apache$commons$validator$ValidatorResources = ValidatorResources.class$("org.apache.commons.validator.ValidatorResources")) : class$org$apache$commons$validator$ValidatorResources).getName());
    protected FastHashMap hFormSets = new FastHashMap();
    protected FastHashMap hConstants = new FastHashMap();
    protected FastHashMap hActions = new FastHashMap();
    protected static Locale defaultLocale = Locale.getDefault();
    static /* synthetic */ Class class$org$apache$commons$validator$ValidatorResources;

    public void put(FormSet fs) {
        if (fs != null) {
            Vector formsets;
            String key = this.buildKey(fs);
            if (this.hFormSets.get((Object)key) == null) {
                this.hFormSets.put((Object)key, new Vector());
            }
            if (!(formsets = (Vector)this.hFormSets.get((Object)key)).contains(fs)) {
                formsets.add(fs);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Adding FormSet '" + fs.toString() + "'."));
            }
        }
    }

    public void addConstant(Constant c) {
        if (c != null && c.getName() != null && c.getName().length() > 0 && c.getValue() != null && c.getValue().length() > 0) {
            this.hConstants.put((Object)c.getName(), (Object)c.getValue());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Add Global Constant: " + c.getName() + "," + c.getValue()));
        }
    }

    public void addConstantParam(String name, String value) {
        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
            this.hConstants.put((Object)name, (Object)value);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Add Global Constant: " + name + "," + value));
        }
    }

    public void addValidatorAction(ValidatorAction va) {
        if (va != null && va.getName() != null && va.getName().length() > 0 && va.getClassname() != null && va.getClassname().length() > 0 && va.getMethod() != null && va.getMethod().length() > 0) {
            va.process((Map)this.hConstants);
            this.hActions.put((Object)va.getName(), (Object)va);
            if (log.isInfoEnabled()) {
                log.info((Object)("Add ValidatorAction: " + va.getName() + "," + va.getClassname()));
            }
        }
    }

    public ValidatorAction getValidatorAction(String key) {
        return (ValidatorAction)this.hActions.get((Object)key);
    }

    public Map getValidatorActions() {
        return Collections.unmodifiableMap(this.hActions);
    }

    protected String buildKey(FormSet fs) {
        String key = (fs.getLanguage() != null && fs.getLanguage().length() > 0 ? fs.getLanguage() : "") + (fs.getCountry() != null && fs.getCountry().length() > 0 ? "_" + fs.getCountry() : "") + (fs.getVariant() != null && fs.getVariant().length() > 0 ? "_" + fs.getVariant() : "");
        if (key.length() == 0) {
            key = defaultLocale.toString();
        }
        return key;
    }

    public Form get(Locale locale, Object formKey) {
        return this.get(locale.getLanguage(), locale.getCountry(), locale.getVariant(), formKey);
    }

    public Form get(String language, String country, String variant, Object formKey) {
        FormSet fs = null;
        Form f = null;
        String key = null;
        Object o = null;
        key = (language != null && language.length() > 0 ? language : "") + (country != null && country.length() > 0 ? "_" + country : "") + (variant != null && variant.length() > 0 ? "_" + variant : "");
        Vector v = (Vector)this.hFormSets.get((Object)key);
        if (v == null) {
            return f;
        }
        Enumeration formsets = v.elements();
        while (formsets.hasMoreElements()) {
            o = formsets.nextElement();
            if (o == null || (fs = (FormSet)o) == null || fs.getForm(formKey) == null) continue;
            return fs.getForm(formKey);
        }
        key = (language != null && language.length() > 0 ? language : "") + (country != null && country.length() > 0 ? "_" + country : "");
        formsets = v.elements();
        while (formsets.hasMoreElements()) {
            o = formsets.nextElement();
            if (o == null || (fs = (FormSet)o) == null || fs.getForm(formKey) == null) continue;
            return fs.getForm(formKey);
        }
        key = language != null && language.length() > 0 ? language : "";
        formsets = v.elements();
        while (formsets.hasMoreElements()) {
            o = formsets.nextElement();
            if (o == null || (fs = (FormSet)o) == null || fs.getForm(formKey) == null) continue;
            return fs.getForm(formKey);
        }
        key = defaultLocale.toString();
        formsets = v.elements();
        while (formsets.hasMoreElements()) {
            o = formsets.nextElement();
            if (o == null || (fs = (FormSet)o) == null || fs.getForm(formKey) == null) continue;
            return fs.getForm(formKey);
        }
        return null;
    }

    public void process() {
        this.hFormSets.setFast(true);
        this.hConstants.setFast(true);
        this.hActions.setFast(true);
        this.processForms();
    }

    public void processForms() {
        FormSet fs;
        Enumeration formsets_en;
        Vector formsets;
        String defaultKey = defaultLocale.toString();
        Iterator i = this.hFormSets.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.equals(defaultKey)) continue;
            formsets = (Vector)this.hFormSets.get((Object)key);
            formsets_en = formsets.elements();
            while (formsets_en.hasMoreElements()) {
                fs = (FormSet)formsets_en.nextElement();
                Iterator x = fs.getForms().keySet().iterator();
                while (x.hasNext()) {
                    String formKey = (String)x.next();
                    Form form = (Form)fs.getForms().get(formKey);
                    Form newForm = new Form();
                    newForm.setName(form.getName());
                    Form defaultForm = this.get(defaultLocale, formKey);
                    Iterator defaultFields = defaultForm.getFields().iterator();
                    while (defaultFields.hasNext()) {
                        Field defaultField = (Field)defaultFields.next();
                        String fieldKey = defaultField.getKey();
                        if (form.getFieldMap().containsKey(fieldKey)) {
                            newForm.addField((Field)form.getFieldMap().get(fieldKey));
                            continue;
                        }
                        Field field = this.getClosestLocaleField(fs, formKey, fieldKey);
                        newForm.addField((Field)field.clone());
                    }
                    fs.addForm(newForm);
                }
            }
        }
        Iterator i2 = this.hFormSets.values().iterator();
        while (i2.hasNext()) {
            formsets = (Vector)i2.next();
            formsets_en = formsets.elements();
            while (formsets_en.hasMoreElements()) {
                fs = (FormSet)formsets_en.nextElement();
                if (fs.isProcessed()) continue;
                fs.process((Map)this.hConstants);
            }
        }
    }

    protected Field getClosestLocaleField(FormSet fs, String formKey, String fieldKey) {
        Form form;
        Field field = null;
        String language = fs.getLanguage();
        String country = fs.getCountry();
        String variant = fs.getVariant();
        if (!GenericValidator.isBlankOrNull(language) && !GenericValidator.isBlankOrNull(country) && !GenericValidator.isBlankOrNull(variant) && (form = this.get(language, country, null, formKey)).getFieldMap().containsKey(fieldKey)) {
            field = (Field)form.getFieldMap().get(fieldKey);
        }
        if (field == null && !GenericValidator.isBlankOrNull(language) && !GenericValidator.isBlankOrNull(country) && (form = this.get(language, null, null, formKey)).getFieldMap().containsKey(fieldKey)) {
            field = (Field)form.getFieldMap().get(fieldKey);
        }
        if (field == null && (form = this.get(defaultLocale, formKey)).getFieldMap().containsKey(fieldKey)) {
            field = (Field)form.getFieldMap().get(fieldKey);
        }
        return field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

