/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.oro.text.perl.Perl5Util;

public class GenericValidator
implements Serializable {
    public static final String REGEXP_DELIM = "/";

    public static boolean isBlankOrNull(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean matchRegexp(String value, String regexp) {
        boolean match = false;
        if (regexp != null && regexp.length() > 0) {
            Perl5Util r = new Perl5Util();
            match = r.match(GenericValidator.getDelimittedRegexp(regexp), value);
        }
        return match;
    }

    public static boolean isByte(String value) {
        return GenericTypeValidator.formatByte(value) != null;
    }

    public static boolean isShort(String value) {
        return GenericTypeValidator.formatShort(value) != null;
    }

    public static boolean isInt(String value) {
        return GenericTypeValidator.formatInt(value) != null;
    }

    public static boolean isLong(String value) {
        return GenericTypeValidator.formatLong(value) != null;
    }

    public static boolean isFloat(String value) {
        return GenericTypeValidator.formatFloat(value) != null;
    }

    public static boolean isDouble(String value) {
        return GenericTypeValidator.formatDouble(value) != null;
    }

    public static boolean isDate(String value, Locale locale) {
        boolean bValid = true;
        if (value != null) {
            try {
                DateFormat formatter = null;
                formatter = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
                formatter.setLenient(false);
                formatter.parse(value);
            }
            catch (ParseException e) {
                bValid = false;
            }
        } else {
            bValid = false;
        }
        return bValid;
    }

    public static boolean isDate(String value, String datePattern, boolean strict) {
        boolean bValid = true;
        if (value != null && datePattern != null && datePattern.length() > 0) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
                formatter.setLenient(false);
                formatter.parse(value);
                if (strict && datePattern.length() != value.length()) {
                    bValid = false;
                }
            }
            catch (ParseException e) {
                bValid = false;
            }
        } else {
            bValid = false;
        }
        return bValid;
    }

    public static boolean isInRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(float value, float min, float max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(short value, short min, short max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isCreditCard(String value) {
        return GenericValidator.validateCreditCardLuhnCheck(value) && GenericValidator.validateCreditCardPrefixCheck(value);
    }

    protected static boolean validateCreditCardLuhnCheck(String cardNumber) {
        int no_digit = cardNumber.length();
        int oddoeven = no_digit & 1;
        long sum = 0L;
        int count = 0;
        while (count < no_digit) {
            int digit = 0;
            try {
                digit = Integer.parseInt(String.valueOf(cardNumber.charAt(count)));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if ((count & 1 ^ oddoeven) == 0 && (digit *= 2) > 9) {
                digit -= 9;
            }
            sum += (long)digit;
            ++count;
        }
        if (sum == 0L) {
            return false;
        }
        return sum % 10L == 0L;
    }

    protected static boolean validateCreditCardPrefixCheck(String cardNumber) {
        String AX_PREFIX = "34,37,";
        String VS_PREFIX = "4";
        String MC_PREFIX = "51,52,53,54,55,";
        String DS_PREFIX = "6011";
        int length = cardNumber.length();
        if (length < 13) {
            return false;
        }
        boolean valid = false;
        int cardType = 0;
        String prefix2 = cardNumber.substring(0, 2) + ",";
        if ("34,37,".indexOf(prefix2) != -1) {
            cardType = 3;
        }
        if (cardNumber.substring(0, 1).equals("4")) {
            cardType = 4;
        }
        if ("51,52,53,54,55,".indexOf(prefix2) != -1) {
            cardType = 5;
        }
        if (cardNumber.substring(0, 4).equals("6011")) {
            cardType = 6;
        }
        if (cardType == 3 && length == 15) {
            valid = true;
        }
        if (cardType == 4 && (length == 13 || length == 16)) {
            valid = true;
        }
        if (cardType == 5 && length == 16) {
            valid = true;
        }
        if (cardType == 6 && length == 16) {
            valid = true;
        }
        return valid;
    }

    public static boolean isEmail(String value) {
        boolean bValid;
        block14: {
            bValid = true;
            try {
                String specialChars = "\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
                String validChars = "[^\\s" + specialChars + "]";
                String quotedUser = "(\"[^\"]*\")";
                String atom = validChars + '+';
                String word = "(" + atom + "|" + quotedUser + ")";
                String emailPat = GenericValidator.getDelimittedRegexp("^(.+)@(.+)$");
                String ipDomainPat = GenericValidator.getDelimittedRegexp("^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$");
                String userPat = GenericValidator.getDelimittedRegexp("^" + word + "(\\." + word + ")*$");
                String domainPat = GenericValidator.getDelimittedRegexp("^" + atom + "(\\." + atom + ")*$");
                String atomPat = GenericValidator.getDelimittedRegexp("(" + atom + ")");
                Perl5Util matchEmailPat = new Perl5Util();
                Perl5Util matchUserPat = new Perl5Util();
                Perl5Util matchIPPat = new Perl5Util();
                Perl5Util matchDomainPat = new Perl5Util();
                Perl5Util matchAtomPat = new Perl5Util();
                boolean ipAddress = false;
                boolean symbolic = false;
                bValid = matchEmailPat.match(emailPat, value);
                if (bValid) {
                    String user = matchEmailPat.group(1);
                    bValid = matchUserPat.match(userPat, user);
                }
                if (!bValid) break block14;
                String domain = matchEmailPat.group(2);
                ipAddress = matchIPPat.match(ipDomainPat, domain);
                if (ipAddress) {
                    int i = 1;
                    while (i <= 4) {
                        String ipSegment = matchIPPat.group(i);
                        if (ipSegment != null && ipSegment.length() > 0) {
                            int iIpSegment = 0;
                            try {
                                iIpSegment = Integer.parseInt(ipSegment);
                            }
                            catch (Exception e) {
                                bValid = false;
                            }
                            if (iIpSegment > 255) {
                                bValid = false;
                            }
                        } else {
                            bValid = false;
                        }
                        ++i;
                    }
                } else {
                    symbolic = matchDomainPat.match(domainPat, domain);
                }
                if (!symbolic) break block14;
                String[] domainSegment = new String[10];
                boolean match = true;
                int i = 0;
                int l = 0;
                while (match) {
                    match = matchAtomPat.match(atomPat, domain);
                    if (!match) continue;
                    domainSegment[i] = matchAtomPat.group(1);
                    l = domainSegment[i].length() + 1;
                    domain = l >= domain.length() ? "" : domain.substring(l);
                    ++i;
                }
                int len = i;
                if (domainSegment[len - 1].length() < 2 || domainSegment[len - 1].length() > 4) {
                    bValid = false;
                }
                if (len < 2) {
                    bValid = false;
                }
            }
            catch (Exception e) {
                bValid = false;
            }
        }
        return bValid;
    }

    public static boolean maxLength(String value, int max) {
        return value.length() <= max;
    }

    public static boolean minLength(String value, int min) {
        return value.length() >= min;
    }

    protected static String getDelimittedRegexp(String regexp) {
        return REGEXP_DELIM + regexp + REGEXP_DELIM;
    }
}

