/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.validator.GenericValidator;

public class GenericTypeValidator
implements Serializable {
    public static Byte formatByte(String value) {
        Byte result = null;
        try {
            result = new Byte(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Short formatShort(String value) {
        Short result = null;
        try {
            result = new Short(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Integer formatInt(String value) {
        Integer result = null;
        try {
            result = new Integer(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Long formatLong(String value) {
        Long result = null;
        try {
            result = new Long(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Float formatFloat(String value) {
        Float result = null;
        try {
            result = new Float(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Double formatDouble(String value) {
        Double result = null;
        try {
            result = new Double(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Date formatDate(String value, Locale locale) {
        Date date = null;
        if (value != null) {
            try {
                DateFormat formatter = null;
                formatter = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
                formatter.setLenient(false);
                date = formatter.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date formatDate(String value, String datePattern, boolean strict) {
        Date date = null;
        if (value != null && datePattern != null && datePattern.length() > 0) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
                formatter.setLenient(false);
                date = formatter.parse(value);
                if (strict && datePattern.length() != value.length()) {
                    date = null;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return date;
    }

    public static Long formatCreditCard(String value) {
        Long result = null;
        try {
            if (GenericValidator.validateCreditCardLuhnCheck(value) && GenericValidator.validateCreditCardPrefixCheck(value)) {
                result = new Long(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

