/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.commons.validator.Var;

public class Field
implements Cloneable,
Serializable {
    public static final String ARG_DEFAULT = "org.apache.commons.validator.Field.DEFAULT";
    public static final String TOKEN_INDEXED = "[]";
    protected static final String TOKEN_START = "${";
    protected static final String TOKEN_END = "}";
    protected static final String TOKEN_VAR = "var:";
    protected String property = null;
    protected String indexedProperty = null;
    protected String indexedListProperty = null;
    protected String key = null;
    protected String depends = null;
    protected int page = 0;
    protected int fieldOrder = 0;
    protected FastHashMap hDependencies = new FastHashMap();
    protected FastHashMap hVars = new FastHashMap();
    protected FastHashMap hMsgs = new FastHashMap();
    protected FastHashMap hArg0 = new FastHashMap();
    protected FastHashMap hArg1 = new FastHashMap();
    protected FastHashMap hArg2 = new FastHashMap();
    protected FastHashMap hArg3 = new FastHashMap();

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(int fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getIndexedProperty() {
        return this.indexedProperty;
    }

    public void setIndexedProperty(String indexedProperty) {
        this.indexedProperty = indexedProperty;
    }

    public String getIndexedListProperty() {
        return this.indexedListProperty;
    }

    public void setIndexedListProperty(String indexedListProperty) {
        this.indexedListProperty = indexedListProperty;
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String depends) {
        this.depends = depends;
    }

    public void addMsg(Msg msg) {
        if (msg != null && msg.getKey() != null && msg.getKey().length() > 0 && msg.getName() != null && msg.getName().length() > 0) {
            this.hMsgs.put((Object)msg.getName(), (Object)msg.getKey());
        }
    }

    public String getMsg(String key) {
        return (String)this.hMsgs.get((Object)key);
    }

    public void addArg0(Arg arg) {
        if (arg != null && arg.getKey() != null && arg.getKey().length() > 0) {
            if (arg.getName() != null && arg.getName().length() > 0) {
                this.hArg0.put((Object)arg.getName(), (Object)arg);
            } else {
                this.hArg0.put((Object)ARG_DEFAULT, (Object)arg);
            }
        }
    }

    public Arg getArg0() {
        return (Arg)this.hArg0.get((Object)ARG_DEFAULT);
    }

    public Arg getArg0(String key) {
        Object o = this.hArg0.get((Object)key);
        return o != null ? (Arg)o : this.getArg0();
    }

    public void addArg1(Arg arg) {
        if (arg != null && arg.getKey() != null && arg.getKey().length() > 0) {
            if (arg.getName() != null && arg.getName().length() > 0) {
                this.hArg1.put((Object)arg.getName(), (Object)arg);
            } else {
                this.hArg1.put((Object)ARG_DEFAULT, (Object)arg);
            }
        }
    }

    public Arg getArg1() {
        return (Arg)this.hArg1.get((Object)ARG_DEFAULT);
    }

    public Arg getArg1(String key) {
        Object o = this.hArg1.get((Object)key);
        return o != null ? (Arg)o : this.getArg1();
    }

    public void addArg2(Arg arg) {
        if (arg != null && arg.getKey() != null && arg.getKey().length() > 0) {
            if (arg.getName() != null && arg.getName().length() > 0) {
                this.hArg2.put((Object)arg.getName(), (Object)arg);
            } else {
                this.hArg2.put((Object)ARG_DEFAULT, (Object)arg);
            }
        }
    }

    public Arg getArg2() {
        return (Arg)this.hArg2.get((Object)ARG_DEFAULT);
    }

    public Arg getArg2(String key) {
        Object o = this.hArg2.get((Object)key);
        return o != null ? (Arg)o : this.getArg2();
    }

    public void addArg3(Arg arg) {
        if (arg != null && arg.getKey() != null && arg.getKey().length() > 0) {
            if (arg.getName() != null && arg.getName().length() > 0) {
                this.hArg3.put((Object)arg.getName(), (Object)arg);
            } else {
                this.hArg3.put((Object)ARG_DEFAULT, (Object)arg);
            }
        }
    }

    public Arg getArg3() {
        return (Arg)this.hArg3.get((Object)ARG_DEFAULT);
    }

    public Arg getArg3(String key) {
        Object o = this.hArg3.get((Object)key);
        return o != null ? (Arg)o : this.getArg3();
    }

    public void addVar(Var v) {
        if (v != null && v.getName() != null && v.getName().length() > 0 && v.getValue() != null) {
            this.hVars.put((Object)v.getName(), (Object)v);
        }
    }

    public void addVarParam(String name, String value, String jsType) {
        if (name != null && name.length() > 0 && value != null) {
            this.hVars.put((Object)name, (Object)new Var(name, value, jsType));
        }
    }

    public Var getVar(String mainKey) {
        return (Var)this.hVars.get((Object)mainKey);
    }

    public String getVarValue(String mainKey) {
        String value = null;
        Object o = this.hVars.get((Object)mainKey);
        if (o != null && o instanceof Var) {
            Var v = (Var)o;
            value = v.getValue();
        }
        return value;
    }

    public Map getVars() {
        return Collections.unmodifiableMap(this.hVars);
    }

    public String getKey() {
        if (this.key == null) {
            this.generateKey();
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isIndexed() {
        return this.indexedListProperty != null && this.indexedListProperty.length() > 0;
    }

    public void generateKey() {
        this.key = this.isIndexed() ? this.indexedListProperty + TOKEN_INDEXED + "." + this.property : this.property;
    }

    public void process(Map globalConstants, Map constants) {
        this.hMsgs.setFast(false);
        this.hArg0.setFast(true);
        this.hArg1.setFast(true);
        this.hArg2.setFast(true);
        this.hArg3.setFast(true);
        this.hVars.setFast(true);
        this.generateKey();
        Iterator i = constants.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String key2 = TOKEN_START + key + TOKEN_END;
            String replaceValue = (String)constants.get(key);
            this.property = ValidatorUtil.replace(this.property, key2, replaceValue);
            this.processVars(key2, replaceValue);
            this.processMessageComponents(key2, replaceValue);
        }
        Iterator i2 = globalConstants.keySet().iterator();
        while (i2.hasNext()) {
            String key = (String)i2.next();
            String key2 = TOKEN_START + key + TOKEN_END;
            String replaceValue = (String)globalConstants.get(key);
            this.property = ValidatorUtil.replace(this.property, key2, replaceValue);
            this.processVars(key2, replaceValue);
            this.processMessageComponents(key2, replaceValue);
        }
        Iterator i3 = this.hVars.keySet().iterator();
        while (i3.hasNext()) {
            String key = (String)i3.next();
            String key2 = "${var:" + key + TOKEN_END;
            Var var = (Var)this.hVars.get((Object)key);
            String replaceValue = var.getValue();
            this.processMessageComponents(key2, replaceValue);
        }
        if (this.getDepends() != null) {
            StringTokenizer st = new StringTokenizer(this.getDepends(), ",");
            String value = "";
            while (st.hasMoreTokens()) {
                String depend = st.nextToken().trim();
                if (depend == null || depend.length() <= 0) continue;
                this.hDependencies.put((Object)depend, (Object)value);
            }
            this.hDependencies.setFast(true);
        }
        this.hMsgs.setFast(true);
    }

    private void processVars(String key, String replaceValue) {
        Iterator i = this.hVars.keySet().iterator();
        while (i.hasNext()) {
            String varKey = (String)i.next();
            Var var = (Var)this.hVars.get((Object)varKey);
            var.setValue(ValidatorUtil.replace(var.getValue(), key, replaceValue));
        }
    }

    public void processMessageComponents(String key, String replaceValue) {
        String varKey = "${var:";
        if (key != null && !key.startsWith(varKey)) {
            Iterator i = this.hMsgs.keySet().iterator();
            while (i.hasNext()) {
                String msgKey = (String)i.next();
                String value = (String)this.hMsgs.get((Object)msgKey);
                this.hMsgs.put((Object)msgKey, (Object)ValidatorUtil.replace(value, key, replaceValue));
            }
        }
        this.processArg((Map)this.hArg0, key, replaceValue);
        this.processArg((Map)this.hArg1, key, replaceValue);
        this.processArg((Map)this.hArg2, key, replaceValue);
        this.processArg((Map)this.hArg3, key, replaceValue);
    }

    private void processArg(Map hArgs, String key, String replaceValue) {
        Iterator i = hArgs.values().iterator();
        while (i.hasNext()) {
            Arg arg = (Arg)i.next();
            if (arg == null) continue;
            arg.setKey(ValidatorUtil.replace(arg.getKey(), key, replaceValue));
        }
    }

    public boolean isDependency(String key) {
        if (this.hDependencies != null) {
            return this.hDependencies.containsKey((Object)key);
        }
        return false;
    }

    public Collection getDependencies() {
        return Collections.unmodifiableMap(this.hDependencies).keySet();
    }

    public Object clone() {
        try {
            Field field = (Field)super.clone();
            if (this.key != null) {
                field.setKey(new String(this.key));
            }
            if (this.property != null) {
                field.setProperty(new String(this.property));
            }
            if (this.indexedProperty != null) {
                field.setIndexedProperty(new String(this.indexedProperty));
            }
            if (this.indexedListProperty != null) {
                field.setIndexedListProperty(new String(this.indexedListProperty));
            }
            if (this.depends != null) {
                field.setDepends(new String(this.depends));
            }
            field.hDependencies = ValidatorUtil.copyFastHashMap(this.hDependencies);
            field.hVars = ValidatorUtil.copyFastHashMap(this.hVars);
            field.hMsgs = ValidatorUtil.copyFastHashMap(this.hMsgs);
            field.hArg0 = ValidatorUtil.copyFastHashMap(this.hArg0);
            field.hArg1 = ValidatorUtil.copyFastHashMap(this.hArg1);
            field.hArg2 = ValidatorUtil.copyFastHashMap(this.hArg2);
            field.hArg3 = ValidatorUtil.copyFastHashMap(this.hArg3);
            return field;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        results.append("\t\tkey=                 " + this.key + "\n");
        results.append("\t\tproperty=            " + this.property + "\n");
        results.append("\t\tindexedProperty=     " + this.indexedProperty + "\n");
        results.append("\t\tindexedListProperty= " + this.indexedListProperty + "\n");
        results.append("\t\tdepends=             " + this.depends + "\n");
        results.append("\t\tpage=                " + this.page + "\n");
        results.append("\t\tfieldOrder=          " + this.fieldOrder + "\n");
        if (this.hVars != null) {
            results.append("\t\tVars:\n");
            Iterator i = this.hVars.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                results.append("\t\t\t");
                results.append(key);
                results.append("=");
                results.append(this.hVars.get(key));
                results.append("\n");
            }
        }
        return results.toString();
    }

    static {
        ARG_DEFAULT = ARG_DEFAULT;
        TOKEN_INDEXED = TOKEN_INDEXED;
        TOKEN_START = TOKEN_START;
        TOKEN_END = TOKEN_END;
        TOKEN_VAR = TOKEN_VAR;
    }
}

