/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogSource;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.ValidatorUtil;

public class Validator
implements Serializable {
    protected static Log log = LogSource.getInstance((String)(class$org$apache$commons$validator$Validator == null ? (class$org$apache$commons$validator$Validator = Validator.class$("org.apache.commons.validator.Validator")) : class$org$apache$commons$validator$Validator).getName());
    public static String BEAN_KEY = "java.lang.Object";
    public static String VALIDATOR_ACTION_KEY = "org.apache.commons.validator.ValidatorAction";
    public static String FIELD_KEY = "org.apache.commons.validator.Field";
    public static String VALIDATOR_KEY = "org.apache.commons.validator.Validator";
    public static String LOCALE_KEY = "java.util.Locale";
    protected ValidatorResources resources = null;
    protected String formName = null;
    protected HashMap hResources = new HashMap();
    protected int page = 0;
    protected ClassLoader classLoader = null;
    protected boolean useContextClassLoader = false;
    static /* synthetic */ Class class$org$apache$commons$validator$Validator;

    public Validator(ValidatorResources resources) {
        this.resources = resources;
    }

    public Validator(ValidatorResources resources, String formName) {
        this.resources = resources;
        this.formName = formName;
    }

    public void addResource(String key, Object value) {
        this.hResources.put(key, value);
    }

    public Object getResource(String key) {
        return this.hResources.get(key);
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void clear() {
        this.formName = null;
        this.hResources = new HashMap();
        this.page = 0;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private boolean validateFieldForRule(Field field, ValidatorAction va, ValidatorResults results, Map hActions, int pos) throws ValidatorException {
        ValidatorResult result;
        if (results.getValidatorResult(field.getKey()) != null && (result = results.getValidatorResult(field.getKey())).containsAction(va.getName())) {
            return result.isValid(va.getName());
        }
        if (va.getDepends() != null) {
            StringTokenizer st = new StringTokenizer(va.getDepends(), ",");
            while (st.hasMoreTokens()) {
                String depend = st.nextToken().trim();
                ValidatorAction depAction = (ValidatorAction)hActions.get(depend);
                if (depAction == null) {
                    log.error((Object)("No ValidatorAction called " + depend + " found for field " + field.getProperty()));
                    return false;
                }
                if (this.validateFieldForRule(field, depAction, results, hActions, pos)) continue;
                return false;
            }
        }
        try {
            this.hResources.put(VALIDATOR_ACTION_KEY, va);
            this.hResources.put(FIELD_KEY, field);
            Class<?> c = this.getClassLoader().loadClass(va.getClassname());
            List lParams = va.getMethodParamsList();
            int size = lParams.size();
            int beanIndexPos = -1;
            int fieldIndexPos = -1;
            Class[] paramClass = new Class[size];
            Object[] paramValue = new Object[size];
            int x = 0;
            while (x < size) {
                String paramKey = (String)lParams.get(x);
                if (BEAN_KEY.equals(paramKey)) {
                    beanIndexPos = x;
                }
                if (FIELD_KEY.equals(paramKey)) {
                    fieldIndexPos = x;
                }
                paramClass[x] = this.getClassLoader().loadClass(paramKey);
                paramValue[x] = this.hResources.get(paramKey);
                ++x;
            }
            Method m = c.getMethod(va.getMethod(), paramClass);
            if (!Modifier.isStatic(m.getModifiers())) {
                try {
                    if (va.getClassnameInstance() == null) {
                        va.setClassnameInstance(c.newInstance());
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Couldn't load instance of class " + va.getClassname() + ".  " + ex.getMessage()));
                }
            }
            Object result2 = null;
            if (field.isIndexed()) {
                Object oIndexed = PropertyUtils.getProperty(this.hResources.get(BEAN_KEY), (String)field.getIndexedListProperty());
                Object[] indexedList = new Object[]{};
                if (oIndexed instanceof Collection) {
                    indexedList = ((Collection)oIndexed).toArray();
                } else if (oIndexed.getClass().isArray()) {
                    indexedList = (Object[])oIndexed;
                }
                paramValue[beanIndexPos] = indexedList[pos];
                Field indexedField = (Field)field.clone();
                indexedField.setKey(ValidatorUtil.replace(indexedField.getKey(), "[]", "[" + pos + "]"));
                paramValue[fieldIndexPos] = indexedField;
                result2 = m.invoke(va.getClassnameInstance(), paramValue);
                results.add(field, va.getName(), this.isValid(result2), result2);
                if (!this.isValid(result2)) {
                    return false;
                }
            } else {
                result2 = m.invoke(va.getClassnameInstance(), paramValue);
                results.add(field, va.getName(), this.isValid(result2), result2);
                if (!this.isValid(result2)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("reflection: " + e.getMessage()), (Throwable)e);
            results.add(field, va.getName(), false);
            if (e instanceof ValidatorException) {
                throw (ValidatorException)e;
            }
            return false;
        }
        return true;
    }

    private void validateField(Field field, ValidatorResults allResults) throws ValidatorException {
        Map hActions = this.resources.getValidatorActions();
        if (field.isIndexed()) {
            Object oIndexed;
            try {
                oIndexed = PropertyUtils.getProperty(this.hResources.get(BEAN_KEY), (String)field.getIndexedListProperty());
            }
            catch (Exception e) {
                log.error((Object)"in validateField", (Throwable)e);
                return;
            }
            Object[] indexedList = new Object[]{};
            if (oIndexed instanceof Collection) {
                indexedList = ((Collection)oIndexed).toArray();
            } else if (oIndexed.getClass().isArray()) {
                indexedList = (Object[])oIndexed;
            }
            int pos = 0;
            while (pos < indexedList.length) {
                ValidatorResults results = new ValidatorResults();
                StringTokenizer st = new StringTokenizer(field.getDepends(), ",");
                while (st.hasMoreTokens()) {
                    String depend = st.nextToken().trim();
                    ValidatorAction depAction = (ValidatorAction)hActions.get(depend);
                    if (depAction == null) {
                        log.error((Object)("No ValidatorAction called " + depend + " found for field " + field.getProperty()));
                        return;
                    }
                    boolean good = this.validateFieldForRule(field, depAction, results, hActions, pos);
                    allResults.merge(results);
                    if (good) continue;
                    return;
                }
                ++pos;
            }
        } else {
            ValidatorResults results = new ValidatorResults();
            StringTokenizer st = new StringTokenizer(field.getDepends(), ",");
            while (st.hasMoreTokens()) {
                String depend = st.nextToken().trim();
                ValidatorAction depAction = (ValidatorAction)hActions.get(depend);
                if (depAction == null) {
                    log.error((Object)("No ValidatorAction called " + depend + " found for field " + field.getProperty()));
                    return;
                }
                boolean good = this.validateFieldForRule(field, depAction, results, hActions, 0);
                allResults.merge(results);
                if (good) continue;
                return;
            }
        }
    }

    public ValidatorResults validate() throws ValidatorException {
        ValidatorResults results = new ValidatorResults();
        Locale locale = null;
        if (this.hResources.containsKey(LOCALE_KEY)) {
            locale = (Locale)this.hResources.get(LOCALE_KEY);
        }
        this.hResources.put(VALIDATOR_KEY, this);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Form form = null;
        if (this.resources == null) {
            throw new ValidatorException("Resources not defined for Validator");
        }
        form = this.resources.get(locale, this.formName);
        if (form != null) {
            Iterator i = form.getFields().iterator();
            while (i.hasNext()) {
                Field field = (Field)i.next();
                if (field.getPage() > this.page) continue;
                this.validateField(field, results);
            }
        }
        return results;
    }

    private boolean isValid(Object result) {
        boolean bValid = false;
        if (result instanceof Boolean) {
            Boolean valid = (Boolean)result;
            bValid = valid;
        } else {
            bValid = result != null;
        }
        return bValid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

