/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl.test;

import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class VfsClassLoaderTests
extends AbstractProviderTestCase {
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.READ_CONTENT, Capability.URI};
    }

    private VFSClassLoader createClassLoader() throws FileSystemException {
        FileObject file = this.getBaseFolder();
        VFSClassLoader loader = new VFSClassLoader(file, (FileSystemManager)this.getManager());
        return loader;
    }

    public void testLoadClass() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        Class testClass = loader.loadClass("code.ClassToLoad");
        Package pack = testClass.getPackage();
        VfsClassLoaderTests.assertEquals((String)"code", (String)pack.getName());
        this.verifyPackage(pack, false);
        Object testObject = testClass.newInstance();
        VfsClassLoaderTests.assertEquals((String)"**PRIVATE**", (String)testObject.toString());
    }

    public void testLoadResource() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        URL resource = loader.getResource("read-tests/file1.txt");
        VfsClassLoaderTests.assertNotNull((Object)resource);
        URLConnection urlCon = resource.openConnection();
        this.assertSameURLContent("This is a test file.", urlCon);
    }

    public void testSealing() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        Class testClass = loader.loadClass("code.sealed.AnotherClass");
        Package pack = testClass.getPackage();
        VfsClassLoaderTests.assertEquals((String)"code.sealed", (String)pack.getName());
        this.verifyPackage(pack, true);
    }

    private void verifyPackage(Package pack, boolean sealed) {
        if (this.getBaseFolder().getFileSystem().hasCapability(Capability.MANIFEST_ATTRIBUTES)) {
            VfsClassLoaderTests.assertEquals((String)"ImplTitle", (String)pack.getImplementationTitle());
            VfsClassLoaderTests.assertEquals((String)"ImplVendor", (String)pack.getImplementationVendor());
            VfsClassLoaderTests.assertEquals((String)"1.1", (String)pack.getImplementationVersion());
            VfsClassLoaderTests.assertEquals((String)"SpecTitle", (String)pack.getSpecificationTitle());
            VfsClassLoaderTests.assertEquals((String)"SpecVendor", (String)pack.getSpecificationVendor());
            VfsClassLoaderTests.assertEquals((String)"1.0", (String)pack.getSpecificationVersion());
            VfsClassLoaderTests.assertEquals((boolean)sealed, (boolean)pack.isSealed());
        } else {
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationTitle());
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationVendor());
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationVersion());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationTitle());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationVendor());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationVersion());
            VfsClassLoaderTests.assertFalse((boolean)pack.isSealed());
        }
    }
}

