/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.libcheck;

import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpCheck {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            throw new IllegalArgumentException("Usage: FtpCheck user pass host dir");
        }
        String user = args[0];
        String pass = args[1];
        String host = args[2];
        String dir = null;
        if (args.length == 4) {
            dir = args[3];
        }
        FTPClient client = new FTPClient();
        client.connect(host);
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            throw new IllegalArgumentException("cant connect: " + reply);
        }
        if (!client.login(user, pass)) {
            throw new IllegalArgumentException("login failed");
        }
        client.enterLocalPassiveMode();
        OutputStream os = client.storeFileStream(dir + "/test.txt");
        if (os == null) {
            throw new IllegalStateException(client.getReplyString());
        }
        os.write("test".getBytes());
        os.close();
        client.completePendingCommand();
        if (dir != null && !client.changeWorkingDirectory(dir)) {
            throw new IllegalArgumentException("change dir to '" + dir + "' failed");
        }
        System.err.println("System: " + client.getSystemType());
        FTPFile[] files = client.listFiles();
        for (int i = 0; i < files.length; ++i) {
            FTPFile file = files[i];
            if (file == null) {
                System.err.println("#" + i + ": " + null);
                continue;
            }
            System.err.println("#" + i + ": " + file.getRawListing());
            System.err.println("#" + i + ": " + file.toString());
            System.err.println("\t name:" + file.getName() + " type:" + file.getType());
        }
        client.disconnect();
    }
}

