/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar.test;

import junit.framework.Test;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;

public class NestedTarTestCase
extends AbstractProviderTestConfig
implements ProviderTestConfig {
    public static Test suite() throws Exception {
        return new ProviderTestSuite(new NestedTarTestCase(), true);
    }

    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("tar", (FileProvider)new TarFileProvider());
        manager.addExtensionMap("tar", "tar");
        manager.addMimeTypeMap("application/x-tar", "tar");
    }

    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String tarFilePath = AbstractVfsTestCase.getTestResource("nested.tar").getAbsolutePath();
        String uri = "tar:file:" + tarFilePath + "!/test.tar";
        FileObject tarFile = manager.resolveFile(uri);
        FileObject nestedFS = manager.createFileSystem(tarFile);
        return nestedFS.resolveFile("/");
    }
}

