/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.test;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.test.ProviderTestConfig;

public class JunctionProviderConfig
implements ProviderTestConfig {
    private final ProviderTestConfig config;

    public JunctionProviderConfig(ProviderTestConfig config) {
        this.config = config;
    }

    public DefaultFileSystemManager getDefaultFileSystemManager() {
        return this.config.getDefaultFileSystemManager();
    }

    public FilesCache getFilesCache() {
        return this.config.getFilesCache();
    }

    public void prepare(DefaultFileSystemManager manager) throws Exception {
        this.config.prepare(manager);
    }

    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        FileObject baseFolder = this.config.getBaseTestFolder(manager);
        FileSystem newFs = manager.createVirtualFileSystem("vfs:").getFileSystem();
        String junctionPoint = "/some/dir";
        newFs.addJunction("/some/dir", baseFolder);
        return newFs.resolveFile("/some/dir");
    }
}

