/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeSelector;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class ProviderDeleteTests
extends AbstractProviderTestCase {
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        FileObject dir1 = scratchFolder.resolveFile("dir1");
        dir1.createFolder();
        FileObject dir1file1 = dir1.resolveFile("a.txt");
        dir1file1.createFile();
        FileObject dir2 = scratchFolder.resolveFile("dir2");
        dir2.createFolder();
        FileObject dir2file1 = dir2.resolveFile("b.txt");
        dir2file1.createFile();
        return scratchFolder;
    }

    public void testDeleteFiles() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        ProviderDeleteTests.assertEquals((int)scratchFolder.delete(Selectors.EXCLUDE_SELF), (int)4);
    }

    public void testDeleteFile() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("dir1/a.txt");
        ProviderDeleteTests.assertTrue((boolean)file.delete());
    }

    public void testDeleteNonExistantFile() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("dir1/aa.txt");
        ProviderDeleteTests.assertFalse((boolean)file.delete());
    }

    public void testDeleteAllFiles() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        ProviderDeleteTests.assertEquals((int)scratchFolder.delete((FileSelector)new FileTypeSelector(FileType.FILE)), (int)2);
    }

    public void testDeleteOneFiles() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        ProviderDeleteTests.assertEquals((int)scratchFolder.delete((FileSelector)new FileNameSelector("a.txt")), (int)1);
    }

    private class FileNameSelector
    implements FileSelector {
        final String basename;

        private FileNameSelector(String basename) {
            this.basename = basename;
        }

        public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
            return this.basename.equals(fileInfo.getFile().getName().getBaseName());
        }

        public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
            return true;
        }
    }
}

