/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url.test;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.url.UrlFileProvider;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;
import org.apache.commons.vfs2.util.FreeSocketPortUtil;
import org.apache.commons.vfs2.util.NHttpServer;

public class UrlProviderHttpTestCase
extends AbstractProviderTestConfig {
    private static NHttpServer Server;
    private static int SocketPort;
    private static final String TEST_URI = "test.http.uri";
    private static String ConnectionUri;

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static void setUpClass() throws Exception {
        Server = new NHttpServer();
        if (!Server.run(SocketPort, new File(UrlProviderHttpTestCase.getTestDirectory()), 5000L)) {
            throw new IllegalStateException("The embedded HTTP server has not completed startup, increase wait time");
        }
    }

    public static Test suite() throws Exception {
        return new ProviderTestSuite(new UrlProviderHttpTestCase()){

            @Override
            protected void setUp() throws Exception {
                if (UrlProviderHttpTestCase.getSystemTestUriOverride() == null) {
                    UrlProviderHttpTestCase.setUpClass();
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                UrlProviderHttpTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() throws IOException {
        if (Server != null) {
            Server.stop();
        }
    }

    public UrlProviderHttpTestCase() throws IOException {
        SocketPort = FreeSocketPortUtil.findFreeLocalPort();
        ConnectionUri = "http://localhost:" + SocketPort;
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = UrlProviderHttpTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        return manager.resolveFile(uri);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("http", (FileProvider)new UrlFileProvider());
    }
}

