/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.extensions.TestSetup;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.test.ProviderTestConfig;

public abstract class AbstractTestSuite
extends TestSetup {
    private final ProviderTestConfig providerConfig;
    private final String prefix;
    private TestSuite testSuite;
    private FileObject baseFolder;
    private FileObject readFolder;
    private FileObject writeFolder;
    private DefaultFileSystemManager manager;
    private File tempDir;
    private Thread[] startThreadSnapshot;
    private Thread[] endThreadSnapshot;
    private final boolean addEmptyDir;

    public AbstractTestSuite(ProviderTestConfig providerConfig) throws Exception {
        this(providerConfig, "", false, false);
    }

    protected AbstractTestSuite(ProviderTestConfig providerConfig, String prefix, boolean nested) throws Exception {
        this(providerConfig, prefix, nested, false);
    }

    protected AbstractTestSuite(ProviderTestConfig providerConfig, String prefix, boolean nested, boolean addEmptyDir) throws Exception {
        super((Test)new TestSuite());
        this.testSuite = (TestSuite)this.fTest;
        this.providerConfig = providerConfig;
        this.prefix = prefix;
        this.addEmptyDir = addEmptyDir;
        this.addBaseTests();
        if (!nested) {
            // empty if block
        }
    }

    protected void addBaseTests() throws Exception {
    }

    public void addTests(Class<?> testClass) throws Exception {
        Method[] methods;
        if (!AbstractProviderTestCase.class.isAssignableFrom(testClass)) {
            throw new Exception("Test class " + testClass.getName() + " is not assignable to " + AbstractProviderTestCase.class.getName());
        }
        for (Method method2 : methods = testClass.getMethods()) {
            Method method = method2;
            if (!method.getName().startsWith("test") || Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 0) continue;
            AbstractProviderTestCase testCase = (AbstractProviderTestCase)((Object)testClass.newInstance());
            testCase.setMethod(method);
            testCase.setName(this.prefix + method.getName());
            testCase.addEmptyDir(this.addEmptyDir);
            this.testSuite.addTest((Test)testCase);
        }
    }

    public void run(final TestResult result) {
        Protectable p = new Protectable(){

            public void protect() throws Exception {
                AbstractTestSuite.this.setUp();
                AbstractTestSuite.this.basicRun(result);
                AbstractTestSuite.this.tearDown();
                AbstractTestSuite.this.validateThreadSnapshot();
            }
        };
        result.runProtected((Test)this, p);
    }

    protected void setUp() throws Exception {
        this.startThreadSnapshot = this.createThreadSnapshot();
        this.tempDir = AbstractVfsTestCase.getTestDirectory("temp");
        FileUtils.cleanDirectory((File)this.tempDir);
        this.checkTempDir("Temp dir not empty before test");
        this.manager = this.providerConfig.getDefaultFileSystemManager();
        this.manager.setFilesCache(this.providerConfig.getFilesCache());
        DefaultFileReplicator replicator = new DefaultFileReplicator(this.tempDir);
        this.manager.setReplicator((FileReplicator)new PrivilegedFileReplicator((FileReplicator)replicator));
        this.manager.setTemporaryFileStore((TemporaryFileStore)replicator);
        this.providerConfig.prepare(this.manager);
        if (!this.manager.hasProvider("file")) {
            this.manager.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        }
        this.manager.init();
        this.baseFolder = this.providerConfig.getBaseTestFolder((FileSystemManager)this.manager);
        this.readFolder = this.baseFolder.resolveFile("read-tests");
        this.writeFolder = this.baseFolder.resolveFile("write-tests");
        AbstractTestSuite.assertTrue((String)("Folder does not exist: " + this.readFolder), (boolean)this.readFolder.exists());
        AbstractTestSuite.assertFalse((boolean)this.readFolder.getName().getPath().equals("/"));
        Enumeration tests = this.testSuite.tests();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (!(test instanceof AbstractProviderTestCase)) continue;
            AbstractProviderTestCase providerTestCase = (AbstractProviderTestCase)test;
            providerTestCase.setConfig(this.manager, this.providerConfig, this.baseFolder, this.readFolder, this.writeFolder);
        }
    }

    protected void tearDown() throws Exception {
        this.readFolder.close();
        this.writeFolder.close();
        this.baseFolder.close();
        this.readFolder = null;
        this.writeFolder = null;
        this.baseFolder = null;
        this.testSuite = null;
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        this.manager.freeUnusedResources();
        this.manager.close();
        this.checkTempDir("Temp dir not empty after test");
    }

    private void validateThreadSnapshot() {
        this.endThreadSnapshot = this.createThreadSnapshot();
        Thread[] diffThreadSnapshot = this.diffThreadSnapshot(this.startThreadSnapshot, this.endThreadSnapshot);
        if (diffThreadSnapshot.length > 0) {
            String message = this.dumpThreadSnapshot(diffThreadSnapshot);
            System.out.println(message);
        }
    }

    private void checkTempDir(String assertMsg) {
        if (this.tempDir.exists()) {
            AbstractTestSuite.assertTrue((String)(assertMsg + " (" + this.tempDir.getAbsolutePath() + ")"), (this.tempDir.isDirectory() && this.tempDir.list().length == 0 ? 1 : 0) != 0);
        }
    }

    private String dumpThreadSnapshot(Thread[] threadSnapshot) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("created threads still running:\n");
        Field threadTargetField = null;
        try {
            threadTargetField = Thread.class.getDeclaredField("target");
            threadTargetField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        for (int iter = 0; iter < threadSnapshot.length; ++iter) {
            Thread thread = threadSnapshot[iter];
            if (thread == null || !thread.isAlive()) continue;
            sb.append("#");
            sb.append(iter + 1);
            sb.append(": ");
            sb.append(thread.getThreadGroup() != null ? thread.getThreadGroup().getName() : "(null)");
            sb.append("\t");
            sb.append(thread.getName());
            sb.append("\t");
            sb.append((Object)thread.getState());
            sb.append("\t");
            if (thread.isDaemon()) {
                sb.append("daemon");
            } else {
                sb.append("not_a_daemon");
            }
            if (threadTargetField != null) {
                sb.append("\t");
                try {
                    Object threadTarget = threadTargetField.get(thread);
                    if (threadTarget != null) {
                        sb.append(threadTarget.getClass());
                    } else {
                        sb.append("null");
                    }
                }
                catch (IllegalAccessException e) {
                    sb.append("unknown class");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private Thread[] diffThreadSnapshot(Thread[] startThreadSnapshot, Thread[] endThreadSnapshot) {
        ArrayList<Thread> diff = new ArrayList<Thread>(10);
        block0: for (int iterEnd = 0; iterEnd < endThreadSnapshot.length; ++iterEnd) {
            for (int iterStart = 0; iterStart < startThreadSnapshot.length; ++iterStart) {
                if (startThreadSnapshot[iterStart] == endThreadSnapshot[iterEnd]) continue block0;
            }
            diff.add(endThreadSnapshot[iterEnd]);
        }
        Thread[] ret = new Thread[diff.size()];
        diff.toArray(ret);
        return ret;
    }

    private Thread[] createThreadSnapshot() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        Thread[] snapshot = new Thread[200];
        tg.enumerate(snapshot, true);
        return snapshot;
    }
}

