/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.PatternFileSelector;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PatternFileSelectorTest {
    private static FileObject BaseFolder;
    private static final int EntryCount = 10;
    private static final int ExtensionCount = 3;
    private static final int FilesPerExtensionCount = 3;

    @BeforeClass
    public static void setUpClass() throws Exception {
        BaseFolder = VFS.getManager().resolveFile("ram://" + PatternFileSelectorTest.class.getName());
        BaseFolder.deleteAll();
        BaseFolder.createFolder();
        BaseFolder.resolveFile("a.htm").createFile();
        BaseFolder.resolveFile("a.html").createFile();
        BaseFolder.resolveFile("a.xhtml").createFile();
        BaseFolder.resolveFile("b.htm").createFile();
        BaseFolder.resolveFile("b.html").createFile();
        BaseFolder.resolveFile("b.xhtml").createFile();
        BaseFolder.resolveFile("c.htm").createFile();
        BaseFolder.resolveFile("c.html").createFile();
        BaseFolder.resolveFile("c.xhtml").createFile();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (BaseFolder != null) {
            BaseFolder.deleteAll();
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNullString() throws Exception {
        new PatternFileSelector((String)null);
    }

    @Test
    public void testMatchAll() throws Exception {
        FileObject[] list = BaseFolder.findFiles((FileSelector)new PatternFileSelector(".*"));
        Assert.assertEquals((long)10L, (long)list.length);
    }

    @Test
    public void testFileExtensions() throws Exception {
        FileObject[] foArray = BaseFolder.findFiles(Selectors.SELECT_FILES);
        Assert.assertTrue((foArray.length > 0 ? 1 : 0) != 0);
        String regExPrefix = ".*\\.";
        HashSet<String> extensionSet = new HashSet<String>();
        for (FileObject fo : foArray) {
            extensionSet.add(".*\\." + fo.getName().getExtension());
        }
        String message = String.format("Extensions: %s; files: %s", ((Object)extensionSet).toString(), Arrays.asList(foArray).toString());
        Assert.assertEquals((String)message, (long)3L, (long)extensionSet.size());
        for (String extension : extensionSet) {
            PatternFileSelector selector = new PatternFileSelector(extension);
            FileObject[] list = BaseFolder.findFiles((FileSelector)selector);
            Assert.assertEquals((long)3L, (long)list.length);
        }
        for (FileObject fo : foArray) {
            PatternFileSelector selector = new PatternFileSelector(".*\\." + fo.getName().getExtension());
            FileObject[] list = BaseFolder.findFiles((FileSelector)selector);
            Assert.assertEquals((long)3L, (long)list.length);
        }
    }
}

