/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class FilesCacheTestsBase
extends AbstractProviderTestCase {
    public void testClearFiles() throws Exception {
        FilesCache cache = this.getManager().getFilesCache();
        FileObject fo1 = this.getWriteFolder().resolveFile("dir1");
        cache.clear(fo1.getFileSystem());
        cache.clear(fo1.getFileSystem());
        FileObject fo2 = this.getWriteFolder().resolveFile("dir1");
        FilesCacheTestsBase.assertFalse((String)"Objects after cache clear should be different", (fo1 == fo2 ? 1 : 0) != 0);
    }

    public void testBasicCacheOps() throws Exception {
        FilesCache cache = this.getManager().getFilesCache();
        FileObject fo = this.getWriteFolder().resolveFile("dir1");
        FileName fn = fo.getName();
        FileSystem fs = fo.getFileSystem();
        cache.clear(fs);
        FilesCacheTestsBase.assertNull((Object)cache.getFile(fs, fn));
        cache.putFile(fo);
        FilesCacheTestsBase.assertSame((Object)fo, (Object)cache.getFile(fs, fn));
        FilesCacheTestsBase.assertFalse((boolean)cache.putFileIfAbsent(fo));
        cache.clear(fs);
        FilesCacheTestsBase.assertNull((Object)cache.getFile(fs, fn));
        FilesCacheTestsBase.assertTrue((boolean)cache.putFileIfAbsent(fo));
        cache.removeFile(fs, fn);
        FilesCacheTestsBase.assertNull((Object)cache.getFile(fs, fn));
        FilesCacheTestsBase.assertTrue((boolean)cache.putFileIfAbsent(fo));
    }

    protected int getFileHashCode() throws FileSystemException {
        FileObject fo = this.getWriteFolder().resolveFile("file2");
        if (!fo.exists()) {
            fo.createFile();
        }
        return fo.hashCode();
    }
}

