/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class ProviderRenameTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT, Capability.RENAME};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    private void moveFile(FileObject scratchFolder, FileObject file, String content) throws FileSystemException, Exception {
        FileObject fileMove = scratchFolder.resolveFile("file1move.txt");
        ProviderRenameTests.assertTrue((!fileMove.exists() ? 1 : 0) != 0);
        file.moveTo(fileMove);
        ProviderRenameTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        ProviderRenameTests.assertTrue((boolean)fileMove.exists());
        this.assertSameContent(content, fileMove);
        ProviderRenameTests.assertTrue((boolean)fileMove.exists());
        ProviderRenameTests.assertTrue((boolean)fileMove.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTestFile(FileObject file) throws FileSystemException, IOException, UnsupportedEncodingException, Exception {
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        OutputStream os = file.getContent().getOutputStream();
        try {
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        finally {
            os.close();
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        return "Here is some sample content for the file.  Blah Blah Blah.";
    }

    public void testRenameFile() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderRenameTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = this.createTestFile(file);
        this.moveFile(scratchFolder, file, content);
    }

    public void testRenameFileIntoEmptyFolder() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderRenameTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = this.createTestFile(file);
        FileObject destFolder = scratchFolder.resolveFile("empty-target-folder");
        destFolder.createFolder();
        ProviderRenameTests.assertTrue((String)"new destination must be folder", (boolean)destFolder.getType().hasChildren());
        ProviderRenameTests.assertTrue((String)"new destination must be emty", (destFolder.getChildren().length == 0 ? 1 : 0) != 0);
        this.moveFile(destFolder, file, content);
    }

    public void testRenameFileAndLeaveFolderEmpty() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject folder = scratchFolder.resolveFile("folder");
        folder.createFolder();
        ProviderRenameTests.assertTrue((boolean)folder.exists());
        FileObject file = folder.resolveFile("file1.txt");
        ProviderRenameTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = this.createTestFile(file);
        this.moveFile(scratchFolder, file, content);
        ProviderRenameTests.assertTrue((folder.getChildren().length == 0 ? 1 : 0) != 0);
    }
}

