/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.VfsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileSystemManagerFactoryTest {
    private void check(FileSystemManager manager, FileObject file) throws FileSystemException {
        Assertions.assertNotNull((Object)file);
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertSame((Object)FileType.FILE, (Object)file.getType());
        Assertions.assertTrue((boolean)file.isFile());
        file = manager.createFileSystem(file);
        Assertions.assertNotNull((Object)file);
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertSame((Object)FileType.FOLDER, (Object)file.getType());
        Assertions.assertTrue((boolean)file.isFolder());
    }

    @Test
    public void testDefaultInstance() throws Exception {
        FileSystemManager manager = VFS.getManager();
        File jarFile = VfsTestUtils.getTestResource("test.jar");
        FileObject file = manager.toFileObject(jarFile);
        this.check(manager, file);
        FileObject path = manager.toFileObject(jarFile.toPath());
        this.check(manager, file);
        FileObject file2 = manager.resolveFile(jarFile.toURI());
        this.check(manager, file2);
        FileObject file3 = manager.resolveFile(jarFile.toURI().toURL());
        this.check(manager, file3);
    }
}

