/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import junit.framework.Test;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.webdav.WebdavFileProvider;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav.test.JackrabbitMain;
import org.apache.commons.vfs2.provider.webdav.test.JcrUtils;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;
import org.apache.commons.vfs2.util.FreeSocketPortUtil;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class WebdavProviderTestCase
extends AbstractProviderTestConfig {
    private static final char[] PASSWORD = new char[0];
    private static final String USER_ID = "admin";
    private static int SocketPort;
    private static final String TEST_URI = "test.webdav.uri";
    private static JackrabbitMain JrMain;
    private static String ConnectionUri;
    private static File RepoDirectory;
    private static boolean DEBUG;

    static File createTempDirectory() throws IOException {
        File base = new File("./target/test").getCanonicalFile();
        base.mkdirs();
        File tempFile = File.createTempFile("WebdavProviderTestCase_", ".tmp", base);
        if (!tempFile.delete()) {
            throw new IOException("Could not delete temp file: " + tempFile.getAbsolutePath());
        }
        if (!tempFile.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempFile.getAbsolutePath());
        }
        if (DEBUG) {
            System.out.println("Working in " + tempFile);
        }
        return tempFile;
    }

    private static void dump(File repoDirectory) throws Exception {
        TransientRepository repository = WebdavProviderTestCase.getTransientRepository(repoDirectory);
        try {
            Session session = WebdavProviderTestCase.getSession(repository);
            WebdavProviderTestCase.message("Root node dump:");
            WebdavProviderTestCase.dump(session.getRootNode());
            session.logout();
        }
        finally {
            repository.shutdown();
        }
    }

    private static void dump(Node node) throws RepositoryException {
        WebdavProviderTestCase.message(node.getPath());
        if (node.getName().equals("jcr:system")) {
            return;
        }
        if (node.getName().equals("jcr:content")) {
            return;
        }
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (property.getDefinition().isMultiple()) {
                Value[] values;
                for (Value value : values = property.getValues()) {
                    WebdavProviderTestCase.message(property.getPath() + " = " + value.getString());
                }
                continue;
            }
            WebdavProviderTestCase.message(property.getPath() + " = " + property.getString());
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            WebdavProviderTestCase.dump(nodes.nextNode());
        }
    }

    private static Session getSession(TransientRepository repository) throws RepositoryException {
        return repository.login((Credentials)new SimpleCredentials(USER_ID, PASSWORD));
    }

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static TransientRepository getTransientRepository(File repoDirectory) throws IOException {
        return new TransientRepository(new File(repoDirectory, "repository.xml").toString(), repoDirectory.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFiles(File repoDirectory, File sourceDir) throws Exception {
        TransientRepository repository = WebdavProviderTestCase.getTransientRepository(repoDirectory);
        try {
            Session session = WebdavProviderTestCase.getSession(repository);
            WebdavProviderTestCase.importFiles(session.getRootNode(), sourceDir);
            session.save();
            session.logout();
        }
        finally {
            repository.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFiles(Node parent, File sourceDir) throws RepositoryException, IOException {
        File[] files;
        for (File file : files = sourceDir.listFiles()) {
            if (file.isFile()) {
                try (FileInputStream data = new FileInputStream(file);){
                    WebdavProviderTestCase.message("Importing file " + file);
                    JcrUtils.putFile(parent, file.getName(), "application/octet-stream", data);
                    continue;
                }
            }
            if (!file.isDirectory()) continue;
            WebdavProviderTestCase.message("Importing folder " + file);
            Node folder = JcrUtils.getOrAddFolder(parent, file.getName());
            WebdavProviderTestCase.importFiles(folder, file);
        }
    }

    private static void message(IOException e) {
        if (DEBUG) {
            e.printStackTrace();
        }
    }

    private static void message(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    private static void setUpClass() throws Exception {
        RepoDirectory = WebdavProviderTestCase.createTempDirectory();
        WebdavProviderTestCase.message("Created temp directory " + RepoDirectory);
        WebdavProviderTestCase.importFiles(RepoDirectory, new File(WebdavProviderTestCase.getTestDirectory()));
        WebdavProviderTestCase.dump(RepoDirectory);
        WebdavProviderTestCase.startJackrabbit(RepoDirectory);
        WebdavProviderTestCase.message("Returned from org.apache.jackrabbit.standalone.Main " + SocketPort);
    }

    private static void startJackrabbit(File repoDirectory) throws Exception {
        boolean quiet = false;
        if (!DEBUG) {
            Logger.getLogger((String)"org.apache.jackrabbit").setLevel(Level.WARN);
            Logger.getLogger((String)"org.apache.commons.httpclient").setLevel(Level.ERROR);
            Logger.getLogger((String)"org.apache.commons.vfs2").setLevel(Level.WARN);
            Logger.getLogger((String)"org.mortbay").setLevel(Level.WARN);
            quiet = true;
        }
        JrMain = new JackrabbitMain(new String[]{"--port", Integer.toString(SocketPort), "--repo", repoDirectory.toString(), quiet ? "--quiet" : ""});
        JrMain.run();
    }

    public static Test suite() throws Exception {
        return new ProviderTestSuite(new WebdavProviderTestCase()){

            @Override
            protected void setUp() throws Exception {
                if (WebdavProviderTestCase.getSystemTestUriOverride() == null) {
                    WebdavProviderTestCase.setUpClass();
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                WebdavProviderTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() throws Exception {
        block3: {
            JrMain.shutdown();
            if (DEBUG) {
                WebdavProviderTestCase.message("Skipping cleanup of " + RepoDirectory);
                return;
            }
            try {
                WebdavProviderTestCase.message("Deleting temp directory " + RepoDirectory);
                FileUtils.deleteDirectory((File)RepoDirectory);
            }
            catch (IOException e) {
                WebdavProviderTestCase.message(e);
                if (!RepoDirectory.exists()) break block3;
                WebdavProviderTestCase.message("Directory will be deleted on VM exit " + RepoDirectory);
                RepoDirectory.deleteOnExit();
            }
        }
    }

    public WebdavProviderTestCase() throws IOException {
        SocketPort = FreeSocketPortUtil.findFreeLocalPort();
        WebdavProviderTestCase.message("FreeSocketPortUtil.findFreeLocalPort() = " + SocketPort);
        ConnectionUri = String.format("webdav://%s@localhost:%d/repository/default", USER_ID, SocketPort);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = WebdavProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        WebdavFileSystemConfigBuilder builder = (WebdavFileSystemConfigBuilder)manager.getFileSystemConfigBuilder("webdav");
        FileSystemOptions opts = new FileSystemOptions();
        builder.setRootURI(opts, uri);
        return manager.resolveFile(uri, opts);
    }

    @Override
    public boolean isFileSystemRootAccessible() {
        return false;
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("webdav", (FileProvider)new WebdavFileProvider());
        manager.addProvider("tmp", (FileProvider)new TemporaryFileProvider());
    }

    static {
        DEBUG = Boolean.getBoolean("WebdavProviderTestCase.Debug");
    }
}

