/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.vfs2.FileType;
import org.junit.Assert;
import org.junit.Test;

public class FileTypeTest {
    @Test
    public void testSerializationFile() {
        this.test(FileType.FILE);
    }

    @Test
    public void testSerializationContainer() {
        Fixture expectedFixture = new Fixture();
        byte[] serialized = SerializationUtils.serialize((Serializable)expectedFixture);
        Fixture actualFixture = (Fixture)SerializationUtils.deserialize((byte[])serialized);
        this.assertEquals(expectedFixture.getFileType(), actualFixture.getFileType());
    }

    @Test
    public void testSerializationFileOrFolder() {
        this.test(FileType.FILE_OR_FOLDER);
    }

    @Test
    public void testSerializationFolder() {
        this.test(FileType.FOLDER);
    }

    @Test
    public void testSerializationImaginary() {
        this.test(FileType.IMAGINARY);
    }

    private void test(FileType expected) {
        byte[] serialized = SerializationUtils.serialize((Serializable)expected);
        FileType actualFileType = (FileType)SerializationUtils.deserialize((byte[])serialized);
        this.assertEquals(expected, actualFileType);
    }

    private void assertEquals(FileType expected, FileType actualFileType) {
        Assert.assertEquals((Object)expected.getName(), (Object)actualFileType.getName());
        Assert.assertEquals((Object)expected.hasAttributes(), (Object)actualFileType.hasAttributes());
        Assert.assertEquals((Object)expected.hasChildren(), (Object)actualFileType.hasChildren());
        Assert.assertEquals((Object)expected.hasContent(), (Object)actualFileType.hasContent());
    }

    private static class Fixture
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FileType fileType = FileType.FILE;

        private Fixture() {
        }

        public FileType getFileType() {
            return this.fileType;
        }
    }
}

