/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl.test;

import java.io.File;
import java.io.FileWriter;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;

public class DefaultFileMonitorTests
extends AbstractVfsTestCase {
    private FileSystemManager fsManager;
    private File testDir;
    private int changeStatus = 0;
    private File testFile;

    public void setUp() throws Exception {
        super.setUp();
        this.fsManager = VFS.getManager();
        this.testDir = AbstractVfsTestCase.getTestDirectoryFile();
        this.changeStatus = 0;
        this.testFile = new File(this.testDir, "testReload.properties");
        if (this.testFile.exists()) {
            this.testFile.delete();
        }
    }

    public void tearDown() throws Exception {
        if (this.testFile != null && this.testFile.exists()) {
            this.testFile.delete();
        }
        super.tearDown();
    }

    public void testFileCreated() throws Exception {
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.writeToFile(this.testFile);
            Thread.sleep(300L);
            DefaultFileMonitorTests.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTests.assertTrue((String)"Incorrect event", (this.changeStatus == 3 ? 1 : 0) != 0);
        }
        finally {
            monitor.stop();
        }
    }

    public void testFileDeleted() throws Exception {
        this.writeToFile(this.testFile);
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.testFile.delete();
            Thread.sleep(300L);
            DefaultFileMonitorTests.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTests.assertTrue((String)"Incorrect event", (this.changeStatus == 2 ? 1 : 0) != 0);
        }
        finally {
            monitor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileModified() throws Exception {
        this.writeToFile(this.testFile);
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            Thread.sleep(1000L);
            long value = System.currentTimeMillis();
            boolean rc = this.testFile.setLastModified(value);
            DefaultFileMonitorTests.assertTrue((String)"setLastModified succeeded", (boolean)rc);
            Thread.sleep(300L);
            DefaultFileMonitorTests.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTests.assertTrue((String)"Incorrect event", (this.changeStatus == 1 ? 1 : 0) != 0);
        }
        finally {
            monitor.stop();
        }
    }

    public void testFileRecreated() throws Exception {
        FileObject fileObj = this.fsManager.resolveFile(this.testFile.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(100L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.writeToFile(this.testFile);
            Thread.sleep(300L);
            DefaultFileMonitorTests.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTests.assertTrue((String)("Incorrect event " + this.changeStatus), (this.changeStatus == 3 ? 1 : 0) != 0);
            this.changeStatus = 0;
            this.testFile.delete();
            Thread.sleep(300L);
            DefaultFileMonitorTests.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTests.assertTrue((String)("Incorrect event " + this.changeStatus), (this.changeStatus == 2 ? 1 : 0) != 0);
            this.changeStatus = 0;
            Thread.sleep(500L);
            monitor.addFile(fileObj);
            this.writeToFile(this.testFile);
            Thread.sleep(300L);
            DefaultFileMonitorTests.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTests.assertTrue((String)("Incorrect event " + this.changeStatus), (this.changeStatus == 3 ? 1 : 0) != 0);
        }
        finally {
            monitor.stop();
        }
    }

    public void testChildFileRecreated() throws Exception {
        this.writeToFile(this.testFile);
        FileObject fileObj = this.fsManager.resolveFile(this.testDir.toURI().toURL().toString());
        DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
        monitor.setDelay(2000L);
        monitor.addFile(fileObj);
        monitor.start();
        try {
            this.changeStatus = 0;
            Thread.sleep(300L);
            this.testFile.delete();
            Thread.sleep(3000L);
            DefaultFileMonitorTests.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTests.assertTrue((String)("Incorrect event " + this.changeStatus), (this.changeStatus == 2 ? 1 : 0) != 0);
            this.changeStatus = 0;
            Thread.sleep(300L);
            this.writeToFile(this.testFile);
            Thread.sleep(3000L);
            DefaultFileMonitorTests.assertTrue((String)"No event occurred", (this.changeStatus != 0 ? 1 : 0) != 0);
            DefaultFileMonitorTests.assertTrue((String)("Incorrect event " + this.changeStatus), (this.changeStatus == 3 ? 1 : 0) != 0);
        }
        finally {
            monitor.stop();
        }
    }

    private void writeToFile(File file) throws Exception {
        FileWriter out = new FileWriter(file);
        out.write("string=value1");
        out.close();
    }

    public class TestFileListener
    implements FileListener {
        public void fileChanged(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTests.this.changeStatus = 1;
        }

        public void fileDeleted(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTests.this.changeStatus = 2;
        }

        public void fileCreated(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTests.this.changeStatus = 3;
        }
    }
}

