/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav.test;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

class JcrUtils {
    private static final String NodeType_NT_RESOURCE = "nt:resource";
    private static final String Node_JCR_CONTENT = "jcr:content";
    private static final String NodeType_NT_FOLDER = "nt:folder";
    private static final String NodeType_NT_FILE = "nt:file";
    private static final String Property_JCR_MIMETYPE = "jcr:mimeType";
    private static final String Property_JCR_ENCODING = "jcr:encoding";
    private static final String Property_JCR_LAST_MODIFIED = "jcr:lastModified";
    private static final String Property_JCR_DATA = "jcr:data";

    public static Node getOrAddFolder(Node parent, String name) throws RepositoryException {
        return JcrUtils.getOrAddNode(parent, name, NodeType_NT_FOLDER);
    }

    public static Node getOrAddNode(Node parent, String name, String type) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        return parent.addNode(name, type);
    }

    public static Node putFile(Node parent, String name, String mime, InputStream data) throws RepositoryException {
        return JcrUtils.putFile(parent, name, mime, data, Calendar.getInstance());
    }

    public static Node putFile(Node parent, String name, String mime, InputStream data, Calendar date) throws RepositoryException {
        Value binary = parent.getSession().getValueFactory().createValue(data);
        Node file = JcrUtils.getOrAddNode(parent, name, NodeType_NT_FILE);
        Node content = JcrUtils.getOrAddNode(file, Node_JCR_CONTENT, NodeType_NT_RESOURCE);
        content.setProperty(Property_JCR_MIMETYPE, mime);
        String[] parameters = mime.split(";");
        for (int i = 1; i < parameters.length; ++i) {
            String parameter;
            int equals = parameters[i].indexOf(61);
            if (equals == -1 || !"charset".equalsIgnoreCase((parameter = parameters[i].substring(0, equals)).trim())) continue;
            content.setProperty(Property_JCR_ENCODING, parameters[i].substring(equals + 1).trim());
        }
        content.setProperty(Property_JCR_LAST_MODIFIED, date);
        content.setProperty(Property_JCR_DATA, binary);
        return file;
    }

    private JcrUtils() {
    }
}

