/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav.test;

import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;

public class WebdavVersioningTests
extends AbstractProviderTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersioning() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileSystemOptions opts = scratchFolder.getFileSystem().getFileSystemOptions();
        WebdavFileSystemConfigBuilder builder = (WebdavFileSystemConfigBuilder)this.getManager().getFileSystemConfigBuilder("webdav");
        builder.setVersioning(opts, true);
        FileObject file = this.getManager().resolveFile(scratchFolder, "file1.txt", opts);
        FileSystemOptions newOpts = file.getFileSystem().getFileSystemOptions();
        WebdavVersioningTests.assertTrue((opts == newOpts ? 1 : 0) != 0);
        WebdavVersioningTests.assertTrue((boolean)builder.isVersioning(newOpts));
        WebdavVersioningTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        file.createFile();
        WebdavVersioningTests.assertTrue((boolean)file.exists());
        WebdavVersioningTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        WebdavVersioningTests.assertTrue((boolean)file.isFile());
        WebdavVersioningTests.assertEquals((long)0L, (long)file.getContent().getSize());
        WebdavVersioningTests.assertFalse((boolean)file.isExecutable());
        WebdavVersioningTests.assertFalse((boolean)file.isHidden());
        WebdavVersioningTests.assertTrue((boolean)file.isReadable());
        WebdavVersioningTests.assertTrue((boolean)file.isWriteable());
        Map map = file.getContent().getAttributes();
        String name = ((URLFileName)file.getName()).getUserName();
        WebdavVersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        if (name != null) {
            WebdavVersioningTests.assertEquals((Object)name, map.get(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        }
        WebdavVersioningTests.assertTrue((boolean)map.containsKey(VersionControlledResource.CHECKED_IN.toString()));
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        map = file.getContent().getAttributes();
        WebdavVersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        if (name != null) {
            WebdavVersioningTests.assertEquals((Object)name, map.get(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        }
        WebdavVersioningTests.assertTrue((boolean)map.containsKey(VersionControlledResource.CHECKED_IN.toString()));
        builder.setVersioning(opts, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersioningWithCreator() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileSystemOptions opts = scratchFolder.getFileSystem().getFileSystemOptions();
        WebdavFileSystemConfigBuilder builder = (WebdavFileSystemConfigBuilder)this.getManager().getFileSystemConfigBuilder("webdav");
        builder.setVersioning(opts, true);
        builder.setCreatorName(opts, "testUser");
        FileObject file = this.getManager().resolveFile(scratchFolder, "file1.txt", opts);
        FileSystemOptions newOpts = file.getFileSystem().getFileSystemOptions();
        WebdavVersioningTests.assertTrue((opts == newOpts ? 1 : 0) != 0);
        WebdavVersioningTests.assertTrue((boolean)builder.isVersioning(newOpts));
        WebdavVersioningTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        file.createFile();
        WebdavVersioningTests.assertTrue((boolean)file.exists());
        WebdavVersioningTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        WebdavVersioningTests.assertTrue((boolean)file.isFile());
        WebdavVersioningTests.assertEquals((long)0L, (long)file.getContent().getSize());
        WebdavVersioningTests.assertFalse((boolean)file.isExecutable());
        WebdavVersioningTests.assertFalse((boolean)file.isHidden());
        WebdavVersioningTests.assertTrue((boolean)file.isReadable());
        WebdavVersioningTests.assertTrue((boolean)file.isWriteable());
        Map map = file.getContent().getAttributes();
        String name = ((URLFileName)file.getName()).getUserName();
        WebdavVersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        WebdavVersioningTests.assertEquals(map.get(DeltaVConstants.CREATOR_DISPLAYNAME.toString()), (Object)"testUser");
        if (name != null) {
            WebdavVersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.COMMENT.toString()));
            WebdavVersioningTests.assertEquals((Object)("Modified by user " + name), map.get(DeltaVConstants.COMMENT.toString()));
        }
        WebdavVersioningTests.assertTrue((boolean)map.containsKey(VersionControlledResource.CHECKED_IN.toString()));
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        map = file.getContent().getAttributes();
        WebdavVersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.CREATOR_DISPLAYNAME.toString()));
        WebdavVersioningTests.assertEquals(map.get(DeltaVConstants.CREATOR_DISPLAYNAME.toString()), (Object)"testUser");
        if (name != null) {
            WebdavVersioningTests.assertTrue((boolean)map.containsKey(DeltaVConstants.COMMENT.toString()));
            WebdavVersioningTests.assertEquals((Object)("Modified by user " + name), map.get(DeltaVConstants.COMMENT.toString()));
        }
        WebdavVersioningTests.assertTrue((boolean)map.containsKey(VersionControlledResource.CHECKED_IN.toString()));
        builder.setVersioning(opts, false);
        builder.setCreatorName(opts, null);
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }
}

