/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.InputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.test.FileInfo;

public class ContentTests
extends AbstractProviderTestCase {
    public void testAllContent() throws Exception {
        FileInfo expectedFileInfo = this.buildExpectedStructure();
        FileObject actualFolder = this.getReadFolder();
        this.assertSameContent(expectedFileInfo, actualFolder);
    }

    private void assertSameContent(FileInfo expected, FileObject folder) throws Exception {
        for (FileInfo fileInfo : expected.children.values()) {
            FileObject child = folder.resolveFile(fileInfo.baseName, NameScope.CHILD);
            ContentTests.assertTrue((String)child.getName().toString(), (boolean)child.exists());
            if (fileInfo.type == FileType.FILE) {
                this.assertSameContent(fileInfo.content, child);
                continue;
            }
            this.assertSameContent(fileInfo, child);
        }
    }

    public void testExists() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ContentTests.assertTrue((String)"file exists", (boolean)file.exists());
        ContentTests.assertTrue((String)"file exists", (file.getType() != FileType.IMAGINARY ? 1 : 0) != 0);
        file = this.getReadFolder().resolveFile("dir1");
        ContentTests.assertTrue((String)"folder exists", (boolean)file.exists());
        ContentTests.assertTrue((String)"folder exists", (file.getType() != FileType.IMAGINARY ? 1 : 0) != 0);
        file = this.getReadFolder().resolveFile("unknown-child");
        ContentTests.assertTrue((String)"unknown file does not exist", (!file.exists() ? 1 : 0) != 0);
        ContentTests.assertTrue((String)"unknown file does not exist", (file.getType() == FileType.IMAGINARY ? 1 : 0) != 0);
        file = this.getReadFolder().resolveFile("unknown-folder/unknown-child");
        ContentTests.assertTrue((String)"unknown file does not exist", (!file.exists() ? 1 : 0) != 0);
        ContentTests.assertTrue((String)"unknown file does not exist", (file.getType() == FileType.IMAGINARY ? 1 : 0) != 0);
    }

    public void testAttributes() throws FileSystemException {
        this.getReadFolder().getContent().getAttributes();
    }

    public void testRootURI() throws FileSystemException {
        if (!this.getProviderConfig().isFileSystemRootAccessible()) {
            return;
        }
        FileSystem fileSystem = this.getFileSystem();
        String uri = fileSystem.getRootURI();
        this.testRoot(this.getManager().resolveFile(uri, fileSystem.getFileSystemOptions()));
    }

    public void testRootAPI() throws FileSystemException {
        if (!this.getProviderConfig().isFileSystemRootAccessible()) {
            return;
        }
        this.testRoot(this.getFileSystem().getRoot());
    }

    private void testRoot(FileObject root) throws FileSystemException {
        ContentTests.assertTrue((boolean)root.exists());
        ContentTests.assertTrue((root.getType() != FileType.IMAGINARY ? 1 : 0) != 0);
    }

    public void testParent() throws FileSystemException {
        FileObject folder = this.getReadFolder().resolveFile("dir1");
        FileObject child = folder.resolveFile("file3.txt");
        ContentTests.assertTrue((String)"folder exists", (boolean)folder.exists());
        ContentTests.assertTrue((String)"child exists", (boolean)child.exists());
        ContentTests.assertSame((Object)folder, (Object)child.getParent());
        child = folder.resolveFile("unknown-file");
        ContentTests.assertTrue((String)"folder exists", (boolean)folder.exists());
        ContentTests.assertTrue((String)"child does not exist", (!child.exists() ? 1 : 0) != 0);
        ContentTests.assertSame((Object)folder, (Object)child.getParent());
        folder = this.getReadFolder().resolveFile("unknown-folder");
        child = folder.resolveFile("unknown-file");
        ContentTests.assertTrue((String)"folder does not exist", (!folder.exists() ? 1 : 0) != 0);
        ContentTests.assertTrue((String)"child does not exist", (!child.exists() ? 1 : 0) != 0);
        ContentTests.assertSame((Object)folder, (Object)child.getParent());
        FileSystem fileSystem = this.getFileSystem();
        FileObject root = fileSystem.getRoot();
        if (fileSystem.getParentLayer() == null) {
            ContentTests.assertNull((String)"root has null parent", (Object)root.getParent());
        } else {
            ContentTests.assertSame((Object)fileSystem.getParentLayer().getParent(), (Object)root.getParent());
        }
    }

    public void testChildren() throws FileSystemException {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ContentTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        ContentTests.assertTrue((boolean)file.isFile());
        try {
            file.getChildren();
            ContentTests.fail();
        }
        catch (FileSystemException e) {
            ContentTests.assertSameMessage("vfs.provider/list-children-not-folder.error", file, (Throwable)e);
        }
        file = file.resolveFile("some-child");
        ContentTests.assertNotNull((Object)file);
        file = this.getReadFolder().resolveFile("unknown-file");
        ContentTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        try {
            file.getChildren();
            ContentTests.fail();
        }
        catch (FileSystemException e) {
            ContentTests.assertSameMessage("vfs.provider/list-children-not-folder.error", file, (Throwable)e);
        }
        FileObject child = file.resolveFile("some-child");
        ContentTests.assertNotNull((Object)child);
    }

    public void testContent() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        this.assertSameContent("This is a test file.", file);
        file = this.getReadFolder().resolveFile("empty.txt");
        this.assertSameContent("", file);
    }

    public void testUnknownContent() throws Exception {
        FileObject unknownFile = this.getReadFolder().resolveFile("unknown-file");
        FileContent content = unknownFile.getContent();
        try {
            content.getInputStream();
            ContentTests.fail();
        }
        catch (FileSystemException e) {
            ContentTests.assertSameMessage("vfs.provider/read-not-file.error", unknownFile, (Throwable)e);
        }
        try {
            content.getSize();
            ContentTests.fail();
        }
        catch (FileSystemException e) {
            ContentTests.assertSameMessage("vfs.provider/get-size-not-file.error", unknownFile, (Throwable)e);
        }
    }

    public void testReadSingleSequencial() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ContentTests.assertTrue((boolean)file.exists());
        file.getContent().getInputStream().close();
        file.getContent().getInputStream().close();
    }

    public void testReadSingleConcurrent() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ContentTests.assertTrue((boolean)file.exists());
        try (InputStream instr = file.getContent().getInputStream();){
            file.getContent().getInputStream().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadMultipleConcurrent() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ContentTests.assertTrue((boolean)file.exists());
        FileObject emptyFile = this.getReadFolder().resolveFile("empty.txt");
        ContentTests.assertTrue((boolean)emptyFile.exists());
        try (InputStream instr = file.getContent().getInputStream();){
            this.assertSameContent("", emptyFile);
        }
    }

    public void testReuse() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ContentTests.assertEquals((Object)FileType.FILE, (Object)file.getType());
        ContentTests.assertTrue((boolean)file.isFile());
        this.assertSameContent("This is a test file.", file);
        this.assertSameContent("This is a test file.", file);
        file.getContent().close();
        file.close();
        this.assertSameContent("This is a test file.", file);
    }

    public void testInputStreamMultipleCleanup() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ContentTests.assertEquals((Object)FileType.FILE, (Object)file.getType());
        ContentTests.assertTrue((boolean)file.isFile());
        InputStream instr1 = file.getContent().getInputStream();
        ContentTests.assertTrue((instr1.read() == "This is a test file.".charAt(0) ? 1 : 0) != 0);
        InputStream instr2 = file.getContent().getInputStream();
        ContentTests.assertTrue((instr2.read() == "This is a test file.".charAt(0) ? 1 : 0) != 0);
        file.close();
        ContentTests.assertTrue((instr1.read() == -1 ? 1 : 0) != 0);
        ContentTests.assertTrue((instr2.read() == -1 ? 1 : 0) != 0);
    }

    public void testInputStreamSingleCleanup() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ContentTests.assertEquals((Object)FileType.FILE, (Object)file.getType());
        ContentTests.assertTrue((boolean)file.isFile());
        InputStream instr1 = file.getContent().getInputStream();
        ContentTests.assertTrue((instr1.read() == "This is a test file.".charAt(0) ? 1 : 0) != 0);
        file.close();
        ContentTests.assertTrue((instr1.read() == -1 ? 1 : 0) != 0);
    }
}

