/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class ProviderRandomReadTests
extends AbstractProviderTestCase {
    private static final String TEST_DATA = "This is a test file.";

    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_TYPE, Capability.RANDOM_ACCESS_READ};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRandomRead() throws Exception {
        try (FileObject file = null;){
            file = this.getReadFolder().resolveFile("file1.txt");
            RandomAccessContent ra = file.getContent().getRandomAccessContent(RandomAccessMode.READ);
            byte c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)c, (int)TEST_DATA.charAt(0));
            ProviderRandomReadTests.assertEquals((String)"fp", (long)ra.getFilePointer(), (long)1L);
            ra.seek(3L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)c, (int)TEST_DATA.charAt(3));
            ProviderRandomReadTests.assertEquals((String)"fp", (long)ra.getFilePointer(), (long)4L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)c, (int)TEST_DATA.charAt(4));
            ProviderRandomReadTests.assertEquals((String)"fp", (long)ra.getFilePointer(), (long)5L);
            ra.seek(3L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)c, (int)TEST_DATA.charAt(3));
            ProviderRandomReadTests.assertEquals((String)"fp", (long)ra.getFilePointer(), (long)4L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)c, (int)TEST_DATA.charAt(4));
            ProviderRandomReadTests.assertEquals((String)"fp", (long)ra.getFilePointer(), (long)5L);
            ra.seek(10L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)c, (int)TEST_DATA.charAt(10));
            ProviderRandomReadTests.assertEquals((String)"fp", (long)ra.getFilePointer(), (long)11L);
            c = ra.readByte();
            ProviderRandomReadTests.assertEquals((int)c, (int)TEST_DATA.charAt(11));
            ProviderRandomReadTests.assertEquals((String)"fp", (long)ra.getFilePointer(), (long)12L);
        }
    }
}

