/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFileContentTest {
    private static final String expected = "testing";

    @Test
    public void testMarkingWorks() throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            try (OutputStream outputStream = file.getContent().getOutputStream();){
                outputStream.write(expected.getBytes());
                outputStream.flush();
            }
            var6_8 = null;
            try (InputStream stream = file.getContent().getInputStream();){
                if (stream.markSupported()) {
                    for (int i = 0; i < 10; ++i) {
                        stream.mark(0);
                        byte[] data = new byte[100];
                        stream.read(data, 0, 7);
                        stream.read();
                        Assert.assertEquals((Object)expected, (Object)new String(data).trim());
                        stream.reset();
                    }
                }
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testMarkingWhenReadingEOS() throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            try (OutputStream outputStream = file.getContent().getOutputStream();){
                outputStream.write(expected.getBytes());
                outputStream.flush();
            }
            var6_8 = null;
            try (InputStream stream = file.getContent().getInputStream();){
                int readCount = 0;
                if (stream.markSupported()) {
                    for (int i = 0; i < 10; ++i) {
                        stream.mark(0);
                        byte[] data = new byte[100];
                        readCount = stream.read(data, 0, 7);
                        stream.read();
                        Assert.assertEquals((long)readCount, (long)7L);
                        Assert.assertEquals((Object)expected, (Object)new String(data).trim());
                        readCount = stream.read(data, 8, 10);
                        Assert.assertEquals((long)readCount, (long)-1L);
                        stream.reset();
                    }
                }
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPassingIllegalBufferSizeToInputStream() throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            file.getContent().getInputStream(-2);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPassingIllegalBufferSizeToOutputStream() throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            file.getContent().getOutputStream(0);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPassingIllegalBufferSizeToOutputStreamWithAppendFlag() throws Exception {
        File temp = File.createTempFile("temp-file-name", ".tmp");
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.getAbsolutePath());){
            file.getContent().getOutputStream(true, -1);
        }
    }
}

