/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Iterator;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileIteratorTest {
    private static FileObject BaseFolder;
    private static final int FileCount = 14;

    @BeforeClass
    public static void setUpClass() throws Exception {
        BaseFolder = VFS.getManager().resolveFile("ram://" + FileIteratorTest.class.getName());
        BaseFolder.deleteAll();
        BaseFolder.resolveFile("a.htm").createFile();
        BaseFolder.resolveFile("a.html").createFile();
        BaseFolder.resolveFile("a.xhtml").createFile();
        BaseFolder.resolveFile("b.htm").createFile();
        BaseFolder.resolveFile("b.html").createFile();
        BaseFolder.resolveFile("b.xhtml").createFile();
        BaseFolder.resolveFile("c.htm").createFile();
        BaseFolder.resolveFile("c.html").createFile();
        BaseFolder.resolveFile("c.xhtml").createFile();
        BaseFolder.resolveFile("subdir1").createFolder();
        BaseFolder.resolveFile("subdir1/subfile1.txt").createFile();
        BaseFolder.resolveFile("subdir2").createFolder();
        BaseFolder.resolveFile("subdir2/subfile1.txt").createFile();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (BaseFolder != null) {
            BaseFolder.deleteAll();
        }
    }

    @Test
    public void testIterator() throws FileSystemException {
        FileObject[] findFiles = BaseFolder.findFiles(Selectors.SELECT_ALL);
        Assert.assertEquals((long)14L, (long)findFiles.length);
        FileObject[] listFiles = BaseFolder.getChildren();
        Assert.assertTrue((14 > listFiles.length ? 1 : 0) != 0);
        int i = 0;
        for (FileObject actualFile : BaseFolder) {
            FileObject expectedFile = findFiles[i];
            Assert.assertEquals((Object)expectedFile, (Object)actualFile);
            ++i;
        }
        Iterator iter = BaseFolder.iterator();
        i = 0;
        while (iter.hasNext()) {
            FileObject expectedFile = findFiles[i];
            Assert.assertEquals((Object)expectedFile, iter.next());
            ++i;
        }
    }
}

