/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.FileSystemException;
import org.junit.Assert;
import org.junit.Test;

public class FileSystemExceptionTest {
    @Test
    public void testMasksPasswordOfUrlsWithBasicAuthentication() {
        FileSystemException fse = new FileSystemException("vfs.provider/rename.error", new Object[]{"file://test.bin", "http://foo:bar@junit.org/test.bin"});
        Assert.assertEquals((Object)"file://test.bin", (Object)fse.getInfo()[0]);
        Assert.assertEquals((Object)"http://foo:***@junit.org/test.bin", (Object)fse.getInfo()[1]);
    }

    @Test
    public void testDoesNotModifyUrlsWithoutPassword() {
        FileSystemException fse = new FileSystemException("vfs.provider/delete.error", (Object)"http://foo@junit.org/test.bin");
        Assert.assertEquals((Object)"http://foo@junit.org/test.bin", (Object)fse.getInfo()[0]);
    }

    @Test
    public void testProperDetectionOfUrl() {
        FileSystemException fse = new FileSystemException("vfs.provider/delete.error", (Object)"zip:http://foo:bar@junit.org/test.bin");
        Assert.assertEquals((Object)"zip:http://foo:***@junit.org/test.bin", (Object)fse.getInfo()[0]);
    }
}

