/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.CanWriteFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CanWriteFileFilterTest
extends BaseFilterTest {
    private static final String WRITEABLE = "writeable.txt";
    private static final String READONLY = "readonly.txt";
    private static File testDir;
    private static File writeableFile;
    private static FileSelectInfo writeableFileInfo;
    private static File readOnlyFile;
    private static FileSelectInfo readOnlyFileInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @BeforeClass
    public static void beforeClass() throws IOException {
        testDir = CanWriteFileFilterTest.getTestDir(CanWriteFileFilterTest.class.getName());
        writeableFile = new File(testDir, WRITEABLE);
        writeableFileInfo = CanWriteFileFilterTest.createFileSelectInfo(writeableFile);
        FileUtils.touch((File)writeableFile);
        readOnlyFile = new File(testDir, READONLY);
        readOnlyFileInfo = CanWriteFileFilterTest.createFileSelectInfo(readOnlyFile);
        FileUtils.touch((File)readOnlyFile);
        readOnlyFile.setReadable(true);
        readOnlyFile.setWritable(false);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = CanWriteFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(CanWriteFileFilterTest.getTempDir(), CanWriteFileFilterTest.class.getName() + ".zip");
        CanWriteFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = CanWriteFileFilterTest.getZipFileObject(zipFile);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        writeableFileInfo = null;
        writeableFile.delete();
        writeableFile = null;
        readOnlyFileInfo = null;
        readOnlyFile.delete();
        readOnlyFile = null;
        notExistingFileInfo = null;
        notExistingFile = null;
        zipFileObj.close();
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @Test
    public void testAcceptCanWrite() throws FileSystemException {
        Assert.assertTrue((boolean)CanWriteFileFilter.CAN_WRITE.accept(writeableFileInfo));
        Assert.assertFalse((boolean)CanWriteFileFilter.CAN_WRITE.accept(readOnlyFileInfo));
        Assert.assertTrue((boolean)CanWriteFileFilter.CAN_WRITE.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptCannotWrite() throws FileSystemException {
        Assert.assertFalse((boolean)CanWriteFileFilter.CANNOT_WRITE.accept(writeableFileInfo));
        Assert.assertTrue((boolean)CanWriteFileFilter.CANNOT_WRITE.accept(readOnlyFileInfo));
        Assert.assertFalse((boolean)CanWriteFileFilter.CANNOT_WRITE.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptZipFile() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(CanWriteFileFilter.CAN_WRITE));
        Assert.assertTrue((files == null || files.length == 0 ? 1 : 0) != 0);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(CanWriteFileFilter.CANNOT_WRITE));
        this.assertContains(files, READONLY, WRITEABLE);
        Assert.assertEquals((long)2L, (long)files.length);
    }
}

